/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.io.Serializable;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.mux.Multiplexer;
import org.jgroups.mux.MuxHeader;
import org.jgroups.stack.ProtocolStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuxChannel
extends JChannel {
    private static final String name = "MUX";
    private final String id;
    private final String stack_name;
    private final MuxHeader hdr;
    private final Multiplexer mux;

    MuxChannel(String id, String stack_name, Multiplexer mux) {
        super(false);
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Cannot create MuxChannel with id " + id);
        }
        if (stack_name == null || stack_name.length() == 0) {
            throw new IllegalArgumentException("Cannot create MuxChannel with stack_name " + stack_name);
        }
        if (mux == null) {
            throw new IllegalArgumentException("Cannot create MuxChannel with Multiplexer " + mux);
        }
        this.stack_name = stack_name;
        this.id = id;
        this.hdr = new MuxHeader(id);
        this.mux = mux;
        this.closed = !mux.isOpen();
    }

    public String getStackName() {
        return this.stack_name;
    }

    public String getId() {
        return this.id;
    }

    public Multiplexer getMultiplexer() {
        return this.mux;
    }

    @Override
    public String getChannelName() {
        return this.mux.getChannel().getClusterName();
    }

    @Override
    public String getClusterName() {
        return this.mux.getChannel().getClusterName();
    }

    @Override
    public Address getLocalAddress() {
        return this.mux.getLocalAddress();
    }

    @Override
    public String getProperties() {
        return this.mux.getChannel().getProperties();
    }

    public JChannel getChannel() {
        return this.mux.getChannel();
    }

    @Override
    public View getView() {
        return this.closed || !this.connected ? null : this.mux.getServiceView(this.id);
    }

    public View getClusterView() {
        return this.mux.getChannel().getView();
    }

    @Override
    public ProtocolStack getProtocolStack() {
        return this.mux.getChannel().getProtocolStack();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Long> tmp;
        Map<String, Object> retval = this.mux.getChannel().getProtocolStack().dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    protected void setClosed(boolean f) {
        this.closed = f;
    }

    protected void setConnected(boolean f) {
        this.connected = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.checkClosed();
        if (this.isConnected()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + channel_name);
            }
            return;
        }
        this.mux.addServiceIfNotPresent(this.getId(), this);
        if (!this.mux.isConnected()) {
            this.mux.connect(this.getStackName());
        }
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId());
            }
            try {
                this.mux.sendServiceUpMessage(this.getId());
                this.setClosed(false);
                this.setConnected(true);
                this.notifyChannelConnected(this);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending SERVICE_UP message", e);
                }
                throw new ChannelException("MuxChannel.connect() failed", e);
            }
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        this.checkClosed();
        if (this.isConnected()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + cluster_name);
            }
            return;
        }
        this.mux.addServiceIfNotPresent(this.getId(), this);
        if (!this.mux.isConnected()) {
            this.mux.connect(this.getStackName());
        }
        try {
            boolean fetchState;
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId());
            }
            try {
                this.mux.sendServiceUpMessage(this.getId());
                this.setClosed(false);
                this.setConnected(true);
                this.notifyChannelConnected(this);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending SERVICE_UP message", e);
                }
                throw new ChannelException("MuxChannel.connect() failed", e);
            }
            View serviceView = this.mux.getServiceView(this.getId());
            boolean stateTransferOk = false;
            boolean bl = fetchState = serviceView != null && serviceView.size() > 1;
            if (fetchState && !(stateTransferOk = this.getState(target, state_id, timeout, false))) {
                throw new StateTransferException("Could not retrieve state " + state_id + " from " + target);
            }
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setClosed(false);
        this.setConnected(false);
        this.notifyServiceDown();
        this.mux.disconnect();
        this.notifyChannelDisconnected(this);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.isConnected()) {
            this.setConnected(false);
            this.notifyServiceDown();
        }
        this.setClosed(true);
        this.closeMessageQueue(true);
        this.notifyChannelClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyServiceDown() {
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId());
            }
            try {
                this.mux.sendServiceDownMessage(this.getId());
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending SERVICE_DOWN message", e);
                }
            }
        }
        catch (Throwable t) {
            this.log.error("closing channel failed", t);
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
    }

    @Override
    public synchronized void open() throws ChannelException {
        this.setClosed(false);
        this.setConnected(false);
        if (!this.mux.isOpen()) {
            this.mux.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        this.setClosed(true);
        this.setConnected(false);
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId());
            }
            try {
                this.mux.sendServiceDownMessage(this.getId());
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending SERVICE_DOWN message", e);
                }
            }
        }
        catch (Throwable t) {
            this.log.error("shutdown channel failed", t);
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
        this.closeMessageQueue(true);
        this.notifyChannelClosed(this);
    }

    @Override
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        msg.putHeader(name, this.hdr);
        this.mux.getChannel().send(msg);
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
    }

    @Override
    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    @Override
    public void down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            msg.putHeader(name, this.hdr);
        }
        this.mux.getChannel().down(evt);
    }

    @Override
    public Object downcall(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            msg.putHeader(name, this.hdr);
        }
        return this.mux.getChannel().downcall(evt);
    }

    @Override
    public boolean getState(Address target, String state_id, long timeout, boolean useFlushIfPresent) throws ChannelNotConnectedException, ChannelClosedException {
        boolean fetchState;
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        Address service_view_coordinator = this.mux.getStateProvider(target, this.id);
        Address tmp = this.getLocalAddress();
        if (service_view_coordinator != null) {
            target = service_view_coordinator;
        }
        if (tmp != null && tmp.equals(target)) {
            target = null;
        }
        if (!this.mux.stateTransferListenersPresent()) {
            return this.mux.getChannel().getState(target, my_id, timeout, useFlushIfPresent);
        }
        View serviceView = this.mux.getServiceView(this.getId());
        boolean bl = fetchState = serviceView != null && serviceView.size() > 1;
        if (fetchState) {
            return this.mux.getState(target, my_id, timeout);
        }
        return false;
    }

    void fireChannelShunned() {
        this.notifyChannelShunned();
    }

    void fireChannelReconnected(Address address) {
        this.notifyChannelReconnected(address);
    }

    @Override
    public void returnState(byte[] state) {
        this.mux.getChannel().returnState(state, this.id);
    }

    @Override
    public void returnState(byte[] state, String state_id) {
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        this.mux.getChannel().returnState(state, my_id);
    }
}

