/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class VIEW_SYNC
extends Protocol {
    Address local_addr = null;
    final Vector<Address> mbrs = new Vector();
    View my_view = null;
    ViewId my_vid = null;
    long avg_send_interval = 60000L;
    private int num_views_sent = 0;
    private int num_view_requests_sent = 0;
    private int num_view_responses_seen = 0;
    private int num_views_non_local = 0;
    private int num_views_equal = 0;
    private int num_views_less = 0;
    private int num_views_adjusted = 0;
    private long last_view_request_sent = 0L;
    private Future view_send_task_future = null;
    private final Lock view_task_lock = new ReentrantLock();
    TimeScheduler timer = null;
    static final String name = "VIEW_SYNC";

    public String getName() {
        return name;
    }

    public long getAverageSendInterval() {
        return this.avg_send_interval;
    }

    public void setAverageSendInterval(long gossip_interval) {
        this.avg_send_interval = gossip_interval;
    }

    public int getNumViewsSent() {
        return this.num_views_sent;
    }

    public int getNumViewRequestsSent() {
        return this.num_view_requests_sent;
    }

    public int getNumViewResponsesSeen() {
        return this.num_view_requests_sent;
    }

    public int getNumViewsNonLocal() {
        return this.num_views_non_local;
    }

    public int getNumViewsLess() {
        return this.num_views_less;
    }

    public int getNumViewsEqual() {
        return this.num_views_equal;
    }

    public long getLastViewRequestSent() {
        return this.last_view_request_sent;
    }

    public int getNumViewsAdjusted() {
        return this.num_views_adjusted;
    }

    public void resetStats() {
        super.resetStats();
        this.num_views_sent = 0;
        this.num_views_adjusted = 0;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("avg_send_interval");
        if (str != null) {
            this.avg_send_interval = Long.parseLong(str);
            props.remove("avg_send_interval");
        }
        if (!props.isEmpty()) {
            this.log.error("these properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
    }

    public void stop() {
        this.stopViewSender();
    }

    public void sendViewRequest() {
        Message msg = new Message(null);
        msg.setFlag((byte)1);
        ViewSyncHeader hdr = new ViewSyncHeader(2, null);
        msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, msg));
        ++this.num_view_requests_sent;
        this.last_view_request_sent = System.currentTimeMillis();
    }

    public Object up(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 1: {
                Message msg = (Message)evt.getArg();
                ViewSyncHeader hdr = (ViewSyncHeader)msg.getHeader(name);
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 1: {
                        this.handleView(hdr.view, sender);
                        break;
                    }
                    case 2: {
                        if (sender.equals(this.local_addr)) break;
                        this.sendView();
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("ViewSyncHeader type " + hdr.type + " not known");
                    }
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                this.handleViewChange(view);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                this.handleViewChange(v);
            }
        }
        return this.down_prot.down(evt);
    }

    private void handleView(View v, Address sender) {
        ++this.num_view_responses_seen;
        Vector<Address> members = v.getMembers();
        if (!members.contains(this.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("discarding view as I (" + this.local_addr + ") am not member of view (" + v + ")");
            }
            ++this.num_views_non_local;
            return;
        }
        ViewId vid = v.getVid();
        int rc = vid.compareTo(this.my_vid);
        if (rc > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("view from " + sender + " (" + vid + ") is greater than my own view (" + this.my_vid + ");" + " will update my own view");
            }
            Message view_change = new Message(this.local_addr, this.local_addr, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(5, v);
            view_change.putHeader("GMS", hdr);
            this.up_prot.up(new Event(1, view_change));
            ++this.num_views_adjusted;
        } else if (rc == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("view from " + sender + " (" + vid + ") is same as my own view; ignoring");
            }
            ++this.num_views_equal;
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("view from " + sender + " (" + vid + ") is less than my own view (" + this.my_vid + "); ignoring");
            }
            ++this.num_views_less;
        }
    }

    private void handleViewChange(View view) {
        Vector<Address> tmp = view.getMembers();
        if (tmp != null) {
            this.mbrs.clear();
            this.mbrs.addAll(tmp);
        }
        this.my_view = (View)view.clone();
        this.my_vid = this.my_view.getVid();
        if (this.my_view.size() > 1) {
            this.startViewSender();
        } else {
            this.stopViewSender();
        }
    }

    private void sendView() {
        View tmp = (View)(this.my_view != null ? this.my_view.clone() : null);
        if (tmp == null) {
            return;
        }
        Message msg = new Message(null);
        msg.setFlag((byte)1);
        ViewSyncHeader hdr = new ViewSyncHeader(1, tmp);
        msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, msg));
        ++this.num_views_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startViewSender() {
        try {
            this.view_task_lock.lock();
            if (this.view_send_task_future == null || this.view_send_task_future.isDone()) {
                ViewSendTask view_send_task = new ViewSendTask();
                this.view_send_task_future = this.timer.scheduleWithDynamicInterval(view_send_task);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("view send task started");
                }
            }
        }
        finally {
            this.view_task_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopViewSender() {
        try {
            this.view_task_lock.lock();
            if (this.view_send_task_future != null) {
                this.view_send_task_future.cancel(false);
                this.view_send_task_future = null;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("view send task stopped");
                }
            }
        }
        finally {
            this.view_task_lock.unlock();
        }
    }

    private class ViewSendTask
    implements TimeScheduler.Task {
        private ViewSendTask() {
        }

        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        public void run() {
            VIEW_SYNC.this.sendView();
        }

        long computeSleepTime() {
            int num_mbrs = Math.max(VIEW_SYNC.this.mbrs.size(), 1);
            return this.getRandom((long)num_mbrs * VIEW_SYNC.this.avg_send_interval * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }
    }

    public static class ViewSyncHeader
    extends Header
    implements Streamable {
        public static final int VIEW_SYNC = 1;
        public static final int VIEW_SYNC_REQ = 2;
        int type = 0;
        View view = null;

        public ViewSyncHeader() {
        }

        public ViewSyncHeader(int type, View view) {
            this.type = type;
            this.view = view;
        }

        public int getType() {
            return this.type;
        }

        public View getView() {
            return this.view;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return org.jgroups.protocols.VIEW_SYNC.name;
                }
                case 2: {
                    return "VIEW_SYNC_REQ";
                }
            }
            return "<unknown>";
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[").append(ViewSyncHeader.type2String(this.type)).append("]");
            if (this.view != null) {
                sb.append(", view= ").append(this.view);
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.view == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            this.view.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            boolean available = in.readBoolean();
            if (available) {
                this.view = new View();
                this.view.readExternal(in);
            }
        }

        public int size() {
            int retval = 6;
            if (this.view != null) {
                retval += this.view.serializedSize();
            }
            return retval;
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
            byte b = (byte)(this.view == null ? 0 : (this.view instanceof MergeView ? 2 : 1));
            out.writeByte(b);
            Util.writeStreamable(this.view, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
            byte b = in.readByte();
            Class clazz = b == 2 ? MergeView.class : View.class;
            this.view = (View)Util.readStreamable(clazz, in);
        }
    }
}

