/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.TimeScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakReceiverWindow {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    Address local_addr = null;
    private long low = 0L;
    private long highest_delivered = 0L;
    private long highest_received = 0L;
    private final ConcurrentMap<Long, Message> xmit_table = new ConcurrentHashMap<Long, Message>();
    private boolean discard_delivered_msgs = false;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private int max_xmit_buf_size = 0;
    private Retransmitter retransmitter = null;
    private Listener listener = null;
    protected static final Log log = LogFactory.getLog(NakReceiverWindow.class);
    long highest_stability_seqno = 0L;
    private double smoothed_loss_rate = 0.0;

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, long lowest_seqno, TimeScheduler sched) {
        this(null, sender, cmd, highest_delivered_seqno, lowest_seqno, sched);
    }

    public NakReceiverWindow(Address local_addr, Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, long lowest_seqno, TimeScheduler sched) {
        this.local_addr = local_addr;
        this.highest_received = this.highest_delivered = highest_delivered_seqno;
        this.low = Math.min(lowest_seqno, this.highest_delivered);
        if (sched == null) {
            throw new IllegalStateException("timer has to be provided and cannot be null");
        }
        if (cmd != null) {
            this.retransmitter = new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno, TimeScheduler sched) {
        this(sender, cmd, highest_delivered_seqno, 0L, sched);
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long highest_delivered_seqno) {
        this(sender, cmd, highest_delivered_seqno, null);
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public void setRetransmitTimeouts(Interval timeouts) {
        this.retransmitter.setRetransmitTimeouts(timeouts);
    }

    public void setDiscardDeliveredMessages(boolean flag) {
        this.discard_delivered_msgs = flag;
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    public int getPendingXmits() {
        return this.retransmitter != null ? this.retransmitter.size() : 0;
    }

    public double getLossRate() {
        int total_msgs = this.size();
        int pending_xmits = this.getPendingXmits();
        if (pending_xmits == 0 || total_msgs == 0) {
            return 0.0;
        }
        return (double)pending_xmits / (double)total_msgs;
    }

    public double getSmoothedLossRate() {
        return this.smoothed_loss_rate;
    }

    private void setSmoothedLossRate() {
        double new_loss_rate = this.getLossRate();
        this.smoothed_loss_rate = this.smoothed_loss_rate == 0.0 ? new_loss_rate : this.smoothed_loss_rate * 0.3 + new_loss_rate * 0.7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long seqno, Message msg) {
        block19: {
            this.lock.writeLock().lock();
            try {
                long next_to_add;
                long old_next = next_to_add = this.highest_received + 1L;
                if (seqno == next_to_add) {
                    this.xmit_table.put(new Long(seqno), msg);
                    boolean bl = true;
                    return bl;
                }
                if (seqno <= this.highest_delivered) {
                    if (log.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder("seqno ");
                        sb.append(seqno).append(" is smaller than ").append(next_to_add).append("); discarding message");
                        log.trace(sb);
                    }
                    boolean sb = false;
                    return sb;
                }
                if (seqno < next_to_add) {
                    Message tmp = this.xmit_table.putIfAbsent(seqno, msg);
                    if (tmp == null) {
                        int num_xmits = this.retransmitter.remove(seqno);
                        if (log.isTraceEnabled()) {
                            log.trace(new StringBuilder("added missing msg ").append(msg.getSrc()).append('#').append(seqno));
                        }
                        if (this.listener != null && num_xmits > 0) {
                            try {
                                this.listener.missingMessageReceived(seqno, msg.getSrc());
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (seqno <= next_to_add) break block19;
                this.xmit_table.put(seqno, msg);
                this.retransmitter.add(old_next, seqno - 1L);
                if (this.listener != null) {
                    try {
                        this.listener.messageGapDetected(next_to_add, seqno, msg.getSrc());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.highest_received = Math.max(this.highest_received, seqno);
                this.lock.writeLock().unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval = null;
        this.lock.writeLock().lock();
        try {
            long next_to_remove = this.highest_delivered + 1L;
            retval = (Message)this.xmit_table.get(next_to_remove);
            if (retval != null) {
                Address sender;
                if (this.discard_delivered_msgs && !this.local_addr.equals(sender = retval.getSrc())) {
                    this.xmit_table.remove(next_to_remove);
                }
                this.highest_delivered = next_to_remove;
                Message message = retval;
                return message;
            }
            if (this.max_xmit_buf_size > 0 && this.xmit_table.size() > this.max_xmit_buf_size) {
                this.highest_delivered = next_to_remove;
                this.retransmitter.remove(next_to_remove);
            }
            Message message = null;
            return message;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove(AtomicBoolean processing) {
        Message retval = null;
        boolean found = false;
        this.lock.writeLock().lock();
        try {
            long next_to_remove = this.highest_delivered + 1L;
            retval = (Message)this.xmit_table.get(next_to_remove);
            boolean bl = found = retval != null;
            if (retval != null) {
                Address sender;
                if (this.discard_delivered_msgs && !this.local_addr.equals(sender = retval.getSrc())) {
                    this.xmit_table.remove(next_to_remove);
                }
                this.highest_delivered = next_to_remove;
                Message message = retval;
                return message;
            }
            if (this.max_xmit_buf_size > 0 && this.xmit_table.size() > this.max_xmit_buf_size) {
                this.highest_delivered = next_to_remove;
                this.retransmitter.remove(next_to_remove);
            }
            Message message = null;
            return message;
        }
        finally {
            if (!found) {
                processing.set(false);
            }
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> removeMany() {
        LinkedList<Message> retval = null;
        this.lock.writeLock().lock();
        try {
            while (true) {
                long next_to_remove;
                Message msg;
                if ((msg = (Message)this.xmit_table.get(next_to_remove = this.highest_delivered + 1L)) != null) {
                    Address sender;
                    if (this.discard_delivered_msgs && !this.local_addr.equals(sender = msg.getSrc())) {
                        this.xmit_table.remove(next_to_remove);
                    }
                    this.highest_delivered = next_to_remove;
                    if (retval == null) {
                        retval = new LinkedList<Message>();
                    }
                    retval.add(msg);
                    continue;
                }
                if (this.max_xmit_buf_size <= 0 || this.xmit_table.size() <= this.max_xmit_buf_size) break;
                this.highest_delivered = next_to_remove;
                this.retransmitter.remove(next_to_remove);
            }
            LinkedList<Message> linkedList = retval;
            return linkedList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message removeOOBMessage() {
        this.lock.writeLock().lock();
        try {
            Message retval = (Message)this.xmit_table.get(this.highest_delivered + 1L);
            if (retval != null && retval.isFlagSet((byte)1)) {
                Message message = this.remove();
                return message;
            }
            Message message = null;
            return message;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagesToRemove() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.xmit_table.get(this.highest_delivered + 1L) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRegularMessageToRemove() {
        this.lock.readLock().lock();
        try {
            Message msg = (Message)this.xmit_table.get(this.highest_delivered + 1L);
            boolean bl = msg != null && !msg.isFlagSet((byte)1);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        this.lock.writeLock().lock();
        try {
            long i;
            if (seqno > this.highest_delivered) {
                if (log.isErrorEnabled()) {
                    log.error("seqno " + seqno + " is > highest_delivered " + this.highest_delivered + "; ignoring stability message");
                }
                return;
            }
            if (!this.xmit_table.isEmpty()) {
                for (i = this.low; i <= seqno; ++i) {
                    this.xmit_table.remove(i);
                }
            }
            for (i = this.low; i <= seqno; ++i) {
                this.retransmitter.remove(i);
            }
            this.highest_stability_seqno = Math.max(this.highest_stability_seqno, seqno);
            this.low = Math.max(this.low, seqno);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.retransmitter.reset();
            this._reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock().lock();
        try {
            long l = this.low;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock().lock();
        try {
            long l = this.highest_delivered;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock().lock();
        try {
            long l = this.highest_received;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get(long seqno) {
        this.lock.readLock().lock();
        try {
            Message message = (Message)this.xmit_table.get(seqno);
            return message;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.xmit_table.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.printMessages();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    String printMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.low).append(" : ").append(this.highest_delivered).append(" (").append(this.highest_received).append(")");
        if (this.xmit_table != null && !this.xmit_table.isEmpty()) {
            int non_received = 0;
            for (Map.Entry entry : this.xmit_table.entrySet()) {
                if (entry.getValue() != null) continue;
                ++non_received;
            }
            sb.append(" (size=").append(this.xmit_table.size()).append(", missing=").append(non_received).append(", highest stability=").append(this.highest_stability_seqno).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    public String printLossRate() {
        StringBuilder sb = new StringBuilder();
        int num_missing = this.getPendingXmits();
        int num_received = this.size();
        int total = num_missing + num_received;
        sb.append("total=").append(total).append(" (received=").append(num_received).append(", missing=").append(num_missing).append("), loss rate=").append(this.getLossRate()).append(", smoothed loss rate=").append(this.smoothed_loss_rate);
        return sb.toString();
    }

    private void _reset() {
        this.xmit_table.clear();
        this.low = 0L;
        this.highest_delivered = 0L;
        this.highest_received = 0L;
        this.highest_stability_seqno = 0L;
    }

    public static interface Listener {
        public void missingMessageReceived(long var1, Address var3);

        public void messageGapDetected(long var1, long var3, Address var5);
    }
}

