/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.buddyreplication.AddressLocator;
import org.jboss.cache.buddyreplication.BuddyLocator;
import org.jboss.cache.buddyreplication.JGroups26AddressLocator;
import org.jboss.cache.buddyreplication.JGroups28AddressLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jgroups.Address;
import org.jgroups.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class NextMemberBuddyLocator
implements BuddyLocator {
    private final Log log = LogFactory.getLog(NextMemberBuddyLocator.class);
    private NextMemberBuddyLocatorConfig config = new NextMemberBuddyLocatorConfig();
    private AddressLocator addressLocator;
    private Channel channel;

    @Override
    public BuddyReplicationConfig.BuddyLocatorConfig getConfig() {
        return this.config;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void init(BuddyReplicationConfig.BuddyLocatorConfig buddyLocatorConfig) {
        this.config = buddyLocatorConfig instanceof NextMemberBuddyLocatorConfig ? (NextMemberBuddyLocatorConfig)buddyLocatorConfig : (buddyLocatorConfig != null ? new NextMemberBuddyLocatorConfig(buddyLocatorConfig) : new NextMemberBuddyLocatorConfig());
        try {
            this.getClass().getClassLoader().loadClass("org.jgroups.PhysicalAddress");
            this.addressLocator = new JGroups28AddressLocator();
        }
        catch (ClassNotFoundException e) {
            this.addressLocator = new JGroups26AddressLocator();
        }
    }

    @Override
    public List<Address> locateBuddies(Map<Address, String> buddyPoolMap, List<Address> currentMembership, Address dataOwner) {
        int numBuddiesToFind = Math.min(this.config.getNumBuddies(), currentMembership.size());
        ArrayList<Address> buddies = new ArrayList<Address>(numBuddiesToFind);
        int dataOwnerSubscript = currentMembership.indexOf(dataOwner);
        int i = 0;
        boolean ignoreColocatedBuddiesForSession = this.config.isIgnoreColocatedBuddies();
        while (buddies.size() < numBuddiesToFind) {
            int subscript = i + dataOwnerSubscript + 1;
            if (subscript >= currentMembership.size()) {
                subscript -= currentMembership.size();
            }
            if (subscript >= currentMembership.size() && ignoreColocatedBuddiesForSession) {
                ignoreColocatedBuddiesForSession = false;
                i = 0;
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates - trying with colocated buddies as well.");
                continue;
            }
            if (subscript >= currentMembership.size() && buddyPoolMap != null) {
                buddyPoolMap = null;
                ignoreColocatedBuddiesForSession = this.config.isIgnoreColocatedBuddies();
                i = 0;
                if (!this.log.isInfoEnabled()) continue;
                this.log.info("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates - trying again, ignoring buddy pool hints.");
                continue;
            }
            if (subscript >= currentMembership.size()) {
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates!");
                break;
            }
            Address candidate = currentMembership.get(subscript);
            if (!(candidate.equals(dataOwner) || buddies.contains(candidate) || ignoreColocatedBuddiesForSession && this.isColocated(candidate, dataOwner) || !this.isInSameBuddyPool(buddyPoolMap, candidate, dataOwner))) {
                buddies.add(candidate);
            }
            ++i;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Selected buddy group as " + buddies);
        }
        return buddies;
    }

    protected boolean isInSameBuddyPool(Map<Address, String> buddyPoolMap, Address candidate, Address dataOwner) {
        if (buddyPoolMap == null) {
            return true;
        }
        String ownerPoolName = buddyPoolMap.get(dataOwner);
        String candidatePoolName = buddyPoolMap.get(candidate);
        return ownerPoolName != null && candidatePoolName != null && ownerPoolName.equals(candidatePoolName);
    }

    protected boolean isColocated(Address candidate, Address dataOwner) {
        block6: {
            InetAddress inetD;
            InetAddress inetC = this.addressLocator.locate(this.channel, candidate);
            if (inetC.equals(inetD = this.addressLocator.locate(this.channel, dataOwner))) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface i = nics.nextElement();
                    Enumeration<InetAddress> addrs = i.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        if (!addr.equals(inetC)) continue;
                        return true;
                    }
                }
            }
            catch (SocketException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to read NICs on host", e);
                }
                if (!this.log.isWarnEnabled()) break block6;
                this.log.warn("UNable to read all network interfaces on host " + inetD + " to determine colocation of " + inetC + ".  Assuming " + inetC + " is NOT colocated with " + inetD);
            }
        }
        return false;
    }
}

