/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.mvcc.ReadCommittedNode;
import org.jboss.cache.notifications.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 8;
    public static final int VERSIONED_METHOD_ID = 9;
    private boolean recursive = false;
    protected Notifier notifier;
    protected static final Log log = LogFactory.getLog(EvictCommand.class);
    protected static final boolean trace = log.isTraceEnabled();
    private List<Fqn> nodesToEvict;

    public EvictCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    public EvictCommand() {
    }

    public void initialize(Notifier notifier, DataContainer dataContainer) {
        super.initialize(dataContainer);
        this.notifier = notifier;
    }

    public List<Fqn> getNodesToEvict() {
        return this.nodesToEvict;
    }

    public void setNodesToEvict(List<Fqn> nodesToEvict) {
        this.nodesToEvict = nodesToEvict;
    }

    @Override
    public Object perform(InvocationContext ctx) {
        NodeSPI node = this.lookupForEviction(ctx, this.fqn);
        if ((node == null || node.isDeleted() || node.isResident()) && !this.recursiveEvictOnRoot(node)) {
            return true;
        }
        if (this.recursive) {
            Collection<Fqn> nodesToEvict = this.getRecursiveEvictionNodes();
            for (Fqn aFqn : nodesToEvict) {
                this.evictNode(aFqn, ctx, this.lookupForEviction(ctx, aFqn));
            }
            return !nodesToEvict.isEmpty();
        }
        return this.evictNode(this.fqn, ctx, node);
    }

    private boolean recursiveEvictOnRoot(NodeSPI node) {
        return node == null && this.fqn.isRoot() && this.recursive && !this.nodesToEvict.isEmpty();
    }

    protected Collection<Fqn> getRecursiveEvictionNodes() {
        Collections.sort(this.nodesToEvict);
        Collections.reverse(this.nodesToEvict);
        return this.nodesToEvict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evictNode(Fqn fqn, InvocationContext ctx, NodeSPI node) {
        this.notifier.notifyNodeEvicted(fqn, true, ctx);
        try {
            InternalNode parentNode;
            if (node == null) {
                boolean bl = true;
                return bl;
            }
            if (node.hasChildrenDirect() || fqn.isRoot()) {
                if (trace) {
                    log.trace("removing DATA as node has children: evict(" + fqn + ")");
                }
                node.clearDataDirect();
                node.setDataLoaded(false);
                boolean bl = false;
                return bl;
            }
            if (trace) {
                log.trace("removing NODE as it is a leaf: evict(" + fqn + ")");
            }
            if ((parentNode = this.lookupInAllScopes(ctx, fqn.getParent())) != null) {
                parentNode.removeChild(fqn.getLastElement());
                parentNode.setChildrenLoaded(false);
            }
            node.setValid(false, false);
            node.markAsDeleted(true);
            node.setDataLoaded(false);
            node.getDelegationTarget().clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.notifier.notifyNodeEvicted(fqn, false, ctx);
        }
    }

    private InternalNode lookupInAllScopes(InvocationContext ctx, Fqn fqn) {
        ReadCommittedNode nodeSPI = (ReadCommittedNode)this.lookupForEviction(ctx, fqn);
        if (nodeSPI == null) {
            return this.dataContainer.peekInternalNode(fqn, true);
        }
        return nodeSPI.getDelegationTarget();
    }

    protected NodeSPI lookupForEviction(InvocationContext ctx, Fqn fqn) {
        return ctx.lookUpNode(fqn);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEvictFqnCommand(ctx, this);
    }

    @Override
    public int getCommandId() {
        return 8;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public Object[] getParameters() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not meant to be marshalled and replicated!");
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not meant to be marshalled and replicated!");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "fqn=" + this.fqn + ", recursive=" + this.recursive + "}";
    }

    public void rollback() {
    }
}

