/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;

public class InvalidateCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 47;
    private static final Log log = LogFactory.getLog(InvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected CacheSPI spi;
    protected Notifier notifier;

    public InvalidateCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    public InvalidateCommand() {
    }

    public void initialize(CacheSPI cacheSpi, DataContainer dataContainer, Notifier notifier) {
        this.spi = cacheSpi;
        this.dataContainer = dataContainer;
        this.notifier = notifier;
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI node = this.enforceNodeLoading();
        if (trace) {
            log.trace("Invalidating fqn:" + this.fqn);
        }
        if (node == null) {
            return null;
        }
        this.evictNode(this.fqn, ctx);
        this.invalidateNode(node);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evictNode(Fqn fqn, InvocationContext ctx) {
        this.notifier.notifyNodeInvalidated(fqn, true, ctx);
        try {
            boolean bl = this.dataContainer.evict(fqn);
            return bl;
        }
        finally {
            this.notifier.notifyNodeInvalidated(fqn, false, ctx);
        }
    }

    protected NodeSPI enforceNodeLoading() {
        return this.spi.getNode(this.fqn);
    }

    protected void invalidateNode(NodeSPI node) {
        node.setValid(false, true);
        if (this.fqn.isRoot()) {
            node.setValid(true, false);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    public int getCommandId() {
        return 47;
    }

    public String toString() {
        return "InvalidateCommand{fqn=" + this.fqn + '}';
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
    }

    void setFqn(Fqn newFqn) {
        this.fqn = newFqn;
    }
}

