/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.LegacyCacheLoaderInterceptor;
import org.jboss.cache.jmx.annotations.ManagedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyActivationInterceptor
extends LegacyCacheLoaderInterceptor {
    protected TransactionManager txMgr = null;
    private long activations = 0L;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public LegacyActivationInterceptor() {
        this.isActivation = true;
        this.useCacheStore = false;
    }

    @Inject
    public void injectTransactionManager(TransactionManager txMgr) {
        this.txMgr = txMgr;
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Object returnValue = super.visitClearDataCommand(ctx, command);
        if (this.trace) {
            this.log.trace("This is a remove data operation; removing the data from the loader, no activation processing needed.");
        }
        this.loader.removeData(command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        Object returnValue = super.visitRemoveNodeCommand(ctx, command);
        if (this.trace) {
            this.log.trace("This is a remove operation; removing the node from the loader, no activation processing needed.");
        }
        this.loader.remove(command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Object returnValue = super.visitGetChildrenNamesCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        Object returnValue = super.visitGetKeysCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Object returnValue = super.visitGetNodeCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object returnValue = super.visitGetKeyValueCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = super.visitPutKeyValueCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Object returnValue = super.visitPutDataMapCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        Object returnValue = super.visitRemoveKeyCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn(), true);
        return returnValue;
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        Object returnValue = super.visitMoveCommand(ctx, command);
        if (this.trace) {
            this.log.trace("This is a move operation; removing the FROM node from the loader, no activation processing needed.");
        }
        this.loader.remove(command.getFqn());
        this.removeNodeFromCacheLoader(ctx, command.getFqn().getParent(), true);
        this.removeNodeFromCacheLoader(ctx, command.getTo(), true);
        return returnValue;
    }

    private boolean wasLoadedIntoMemory(InvocationContext ctx, Fqn fqn) {
        Set<Fqn> fqnsLoaded = ctx.getFqnsLoaded();
        return fqnsLoaded != null && fqnsLoaded.contains(fqn);
    }

    private void removeNodeFromCacheLoader(InvocationContext ctx, Fqn fqn, boolean checkIfLoaded) throws Throwable {
        if (fqn != null) {
            NodeSPI n;
            boolean remove = false;
            if ((!checkIfLoaded || this.wasLoadedIntoMemory(ctx, fqn)) && (n = this.dataContainer.peek(fqn, true, false)) != null && n.isDataLoaded() && this.loader.exists(fqn)) {
                if (!n.getChildrenDirect().isEmpty()) {
                    boolean result = this.childrenLoaded(n);
                    if (result) {
                        this.log.debug("children all initialized");
                        this.remove(fqn);
                        remove = true;
                    }
                } else if (this.loaderNoChildren(fqn)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("no children " + n);
                    }
                    this.remove(fqn);
                    remove = true;
                }
            }
            if (!fqn.isRoot() && remove) {
                this.removeNodeFromCacheLoader(ctx, fqn.getParent(), false);
            }
        }
    }

    private boolean childrenLoaded(NodeSPI<?, ?> node) throws Exception {
        if (!node.isChildrenLoaded() && this.loader.getChildrenNames(node.getFqn()) != null) {
            return false;
        }
        for (NodeSPI<?, ?> child : node.getChildrenDirect()) {
            if (!child.isDataLoaded()) {
                return false;
            }
            if (!(child.getChildrenDirect().size() > 0 ? !this.childrenLoaded(child) : !this.loaderNoChildren(child.getFqn()))) continue;
            return false;
        }
        return true;
    }

    private void remove(Fqn fqn) throws Exception {
        this.loader.remove(fqn);
        if (this.getStatisticsEnabled()) {
            ++this.activations;
        }
    }

    private boolean loaderNoChildren(Fqn fqn) {
        try {
            Set<?> childrenNames = this.loader.getChildrenNames(fqn);
            return childrenNames == null;
        }
        catch (Exception e) {
            this.log.error("failed getting the children names for " + fqn + " from the cache loader", e);
            return false;
        }
    }

    public long getActivations() {
        return this.activations;
    }

    @Override
    @ManagedOperation
    public void resetStatistics() {
        super.resetStatistics();
        this.activations = 0L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        Map<String, Object> retval = super.dumpStatistics();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("Activations", this.activations);
        return retval;
    }

    @Override
    protected void recordNodeLoaded(InvocationContext ctx, Fqn fqn) {
        ctx.addFqnLoaded(fqn);
    }
}

