/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.VersionedDataCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.legacy.write.CreateNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;

@Deprecated
public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private final Set<GlobalTransaction> broadcastTxs = new ConcurrentHashSet<GlobalTransaction>();
    private CommandsFactory commandsFactory;

    @Inject
    public void initialize(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            GlobalTransaction gtx = this.getGlobalTransaction(ctx);
            TransactionContext transactionContext = ctx.getTransactionContext();
            if (transactionContext.hasLocalModifications()) {
                OptimisticPrepareCommand replicablePrepareCommand = command.copy();
                replicablePrepareCommand.removeModifications(transactionContext.getLocalModifications());
                command = replicablePrepareCommand;
            }
            this.broadcastPrepare(command, gtx, ctx);
        }
        return retval;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        Throwable remoteCommitException = null;
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.contains(gtx)) {
            try {
                if (!this.skipReplicationOfTransactionMethod(ctx)) {
                    this.broadcastCommit(gtx, ctx);
                }
            }
            catch (Throwable t) {
                this.log.error("A problem occurred with remote commit", t);
                remoteCommitException = t;
            }
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (remoteCommitException != null) {
            throw remoteCommitException;
        }
        return retval;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        Throwable remoteRollbackException = null;
        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.contains(gtx)) {
            try {
                if (!this.skipReplicationOfTransactionMethod(ctx)) {
                    this.broadcastRollback(gtx, ctx);
                }
            }
            catch (Throwable t) {
                this.log.error(" a problem occurred with remote rollback", t);
                remoteRollbackException = t;
            }
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (remoteRollbackException != null) {
            throw remoteRollbackException;
        }
        return retval;
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        ctx.getTransactionContext().setForceAsyncReplication(true);
        return this.handleDefault(ctx, command);
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.isLocalModeForced(ctx) && command instanceof WriteCommand) {
            ctx.getTransactionContext().addLocalModification((WriteCommand)command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private GlobalTransaction getGlobalTransaction(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx == null) {
            throw new CacheException("failed to get global transaction");
        }
        return gtx;
    }

    protected void broadcastPrepare(OptimisticPrepareCommand command, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        if (this.rpcManager.getMembers() != null && this.rpcManager.getMembers().size() > 1) {
            DataVersionPopulator populator = new DataVersionPopulator(this.getTransactionWorkspace(ctx), command.getModifications().size());
            populator.visitCollection(null, command.getModifications());
            OptimisticPrepareCommand toBroadcast = this.commandsFactory.buildOptimisticPrepareCommand(gtx, populator.versionedCommands, command.getLocalAddress(), command.isOnePhaseCommit());
            this.broadcastTxs.add(gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("(" + this.rpcManager.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + command.getModificationsCount() + " modifications");
            }
            this.replicateCall(ctx, toBroadcast, this.defaultSynchronous, ctx.getOptionOverrides());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("(" + this.rpcManager.getLocalAddress() + "):not broadcasting prepare as members are " + this.rpcManager.getMembers());
        }
    }

    protected void broadcastCommit(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncCommitPhase();
        if (this.rpcManager.getMembers() != null && this.rpcManager.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                CommitCommand commitCommand = this.commandsFactory.buildCommitCommand(gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("running remote commit for " + gtx + " and coord=" + this.rpcManager.getLocalAddress());
                }
                this.replicateCall(ctx, commitCommand, remoteCallSync, ctx.getOptionOverrides(), false);
            }
            catch (Exception e) {
                this.log.error("Commit failed", e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncRollbackPhase();
        if (this.rpcManager.getMembers() != null && this.rpcManager.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("running remote rollback for " + gtx + " and coord=" + this.rpcManager.getLocalAddress());
                }
                this.replicateCall(ctx, rollbackCommand, remoteCallSync, ctx.getOptionOverrides());
            }
            catch (Exception e) {
                this.log.error("Rollback failed", e);
                throw e;
            }
        }
    }

    protected TransactionWorkspace getTransactionWorkspace(InvocationContext ctx) throws CacheException {
        OptimisticTransactionContext transactionContext = (OptimisticTransactionContext)ctx.getTransactionContext();
        if (transactionContext == null) {
            throw new CacheException("unable to map global transaction " + ctx + " to transaction entry");
        }
        return transactionContext.getTransactionWorkSpace();
    }

    public class DataVersionPopulator
    extends AbstractVisitor {
        final TransactionWorkspace workspace;
        final List<WriteCommand> versionedCommands;

        public DataVersionPopulator(TransactionWorkspace workspace, int numCommands) {
            this.workspace = workspace;
            this.versionedCommands = new ArrayList<WriteCommand>(numCommands);
        }

        private void setDataVersion(VersionedDataCommand clone, Fqn fqn) {
            DataVersion versionToBroadcast = this.getVersionToBroadcast(this.workspace, fqn);
            clone.setDataVersion(versionToBroadcast);
            this.versionedCommands.add(clone);
        }

        public Object visitGravitateDataCommand(InvocationContext ctx, GravitateDataCommand command) throws Throwable {
            return command;
        }

        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            PutDataMapCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildPutDataMapCommand(null, command.getFqn(), command.getData());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            PutKeyValueCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildPutKeyValueCommand(null, command.getFqn(), command.getKey(), command.getValue());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
            PutForExternalReadCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildPutForExternalReadCommand(null, command.getFqn(), command.getKey(), command.getValue());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
            RemoveNodeCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildRemoveNodeCommand(command.getGlobalTransaction(), command.getFqn());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
            RemoveKeyCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildRemoveKeyCommand(null, command.getFqn(), command.getKey());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
            ClearDataCommand clone = OptimisticReplicationInterceptor.this.commandsFactory.buildClearDataCommand(command.getGlobalTransaction(), command.getFqn());
            this.setDataVersion(clone, command.getFqn());
            return null;
        }

        public Object visitCreateNodeCommand(InvocationContext ctx, CreateNodeCommand command) throws Throwable {
            this.versionedCommands.add(command);
            return command;
        }

        public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
            this.versionedCommands.add(command);
            return command;
        }

        public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            throw new CacheException("Not handling " + command + "!");
        }

        private DataVersion getVersionToBroadcast(TransactionWorkspace w, Fqn f) {
            WorkspaceNode n = w.getNode(f);
            if (n == null) {
                if (OptimisticReplicationInterceptor.this.trace) {
                    OptimisticReplicationInterceptor.this.log.trace("Fqn " + f + " not found in workspace; not using a data version.");
                }
                return null;
            }
            if (n.isVersioningImplicit()) {
                DefaultDataVersion v = (DefaultDataVersion)n.getVersion();
                if (OptimisticReplicationInterceptor.this.trace) {
                    OptimisticReplicationInterceptor.this.log.trace("Fqn " + f + " has implicit versioning.  Broadcasting an incremented version.");
                }
                return v.increment();
            }
            if (OptimisticReplicationInterceptor.this.trace) {
                OptimisticReplicationInterceptor.this.log.trace("Fqn " + f + " has explicit versioning.  Broadcasting the version as-is.");
            }
            return n.getVersion();
        }
    }
}

