/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.lock.AbstractLockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.NodeLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class NodeBasedLockManager
extends AbstractLockManager {
    private static final Log log = LogFactory.getLog(NodeBasedLockManager.class);
    private static final boolean trace = log.isTraceEnabled();
    protected DataContainer dataContainer;
    protected NodeSPI rootNode;

    @Inject
    public void inject(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Start
    public void setRootNode() {
        this.rootNode = this.dataContainer.getRoot();
    }

    private NodeLock acquireLock(Fqn fqn, LockType lockType, Object owner, long timeout) {
        return this.acquireLock(this.dataContainer.peek(fqn), lockType, owner, timeout);
    }

    private NodeLock acquireLock(NodeSPI node, LockType lockType, Object owner, long timeout) {
        if (node == null) {
            return null;
        }
        NodeLock lock = node.getLock();
        boolean acquired = false;
        try {
            acquired = lock.acquire(owner, timeout, lockType);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (acquired) {
            return lock;
        }
        return null;
    }

    @Override
    public boolean lock(Fqn fqn, LockType lockType, Object owner) {
        return this.acquireLock(fqn, lockType, owner, this.lockAcquisitionTimeout) != null;
    }

    @Override
    public boolean lock(Fqn fqn, LockType lockType, Object owner, long timeout) {
        return this.acquireLock(fqn, lockType, owner, timeout) != null;
    }

    public boolean lock(NodeSPI node, LockType lockType, Object owner) {
        return this.acquireLock(node, lockType, owner, this.lockAcquisitionTimeout) != null;
    }

    public boolean lock(NodeSPI node, LockType lockType, Object owner, long timeout) {
        return this.acquireLock(node, lockType, owner, timeout) != null;
    }

    @Override
    public boolean lockAndRecord(Fqn fqn, LockType lockType, InvocationContext ctx) {
        return this.lockAndRecord(this.dataContainer.peek(fqn), lockType, ctx);
    }

    public boolean lockAndRecord(NodeSPI node, LockType lockType, InvocationContext ctx) {
        NodeLock lock = this.acquireLock(node, lockType, this.getLockOwner(ctx), ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout));
        if (lock != null) {
            ctx.addLock(lock);
            return true;
        }
        return false;
    }

    @Override
    public void unlock(InvocationContext ctx) {
        List locks = ctx.getLocks();
        if (locks.isEmpty()) {
            return;
        }
        Object owner = this.getLockOwner(ctx);
        ListIterator it = locks.listIterator(locks.size());
        while (it.hasPrevious()) {
            NodeLock l = (NodeLock)it.previous();
            if (trace) {
                log.trace("releasing lock for " + l.getFqn() + " (" + l + "), owner " + owner);
            }
            l.release(owner);
        }
        ctx.clearLocks();
    }

    private void unlock(NodeLock lock, Object owner) {
        if (trace) {
            log.trace("releasing lock for " + lock.getFqn() + " (" + lock + "), owner " + owner);
        }
        lock.release(owner);
    }

    @Override
    public void unlock(Fqn fqn, Object owner) {
        this.unlock(this.dataContainer.peek(fqn).getLock(), owner);
    }

    public void unlock(NodeSPI node, Object owner) {
        if (node == null) {
            return;
        }
        this.unlock(node.getLock(), owner);
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner) {
        return this.lockAll(node, lockType, owner, this.lockAcquisitionTimeout, false);
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner, long timeout) {
        return this.lockAll(node, lockType, owner, timeout, false);
    }

    private List<NodeLock> lockAllNodes(NodeSPI node, LockType lockType, Object owner, long timeout, boolean excludeInternalFqns) {
        if (node == null) {
            return null;
        }
        ArrayList<NodeLock> locks = null;
        try {
            locks = new ArrayList<NodeLock>(node.getLock().acquireAll(owner, timeout, lockType, excludeInternalFqns));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return locks;
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner, long timeout, boolean excludeInternalFqns) {
        return this.lockAllNodes(node, lockType, owner, timeout, excludeInternalFqns) != null;
    }

    @Override
    public boolean lockAllAndRecord(Fqn fqn, LockType lockType, InvocationContext ctx) {
        return this.lockAllAndRecord(this.dataContainer.peek(fqn), lockType, ctx);
    }

    public boolean lockAllAndRecord(NodeSPI node, LockType lockType, InvocationContext ctx) {
        List<NodeLock> locks = this.lockAllNodes(node, lockType, this.getLockOwner(ctx), ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout), false);
        if (locks == null) {
            return false;
        }
        if (locks.size() > 0) {
            ctx.addAllLocks(locks);
        }
        return true;
    }

    public void unlockAll(NodeSPI node, Object owner) {
        node.getLock().releaseAll(owner);
    }

    public void unlockAll(NodeSPI node) {
        node.getLock().releaseAll();
    }

    @Override
    public boolean ownsLock(Fqn fqn, LockType lockType, Object owner) {
        NodeSPI n = this.dataContainer.peek(fqn, true, true);
        if (n == null) {
            return false;
        }
        NodeLock lock = n.getLock();
        switch (lockType) {
            case READ: {
                return lock.isReadLocked() && lock.isOwner(owner);
            }
            case WRITE: {
                return lock.isWriteLocked() && lock.isOwner(owner);
            }
        }
        return false;
    }

    @Override
    public boolean ownsLock(Fqn fqn, Object owner) {
        return this.ownsLock(this.dataContainer.peek(fqn, true, true), owner);
    }

    public boolean ownsLock(NodeSPI node, Object owner) {
        return node != null && node.getLock().isOwner(owner);
    }

    public boolean isLocked(NodeSPI n) {
        return n.getLock().isLocked();
    }

    @Override
    public boolean isLocked(Fqn fqn) {
        return this.isLocked(this.dataContainer.peek(fqn));
    }

    public boolean isLocked(NodeSPI n, LockType type) {
        switch (type) {
            case READ: {
                return n.getLock().isReadLocked();
            }
            case WRITE: {
                return n.getLock().isWriteLocked();
            }
        }
        return false;
    }

    @Override
    public Object getWriteOwner(Fqn f) {
        return this.getWriteOwner(this.dataContainer.peek(f));
    }

    @Override
    public Collection<Object> getReadOwners(Fqn f) {
        return this.getReadOwners(this.dataContainer.peek(f));
    }

    public Object getWriteOwner(NodeSPI node) {
        return node.getLock().getWriterOwner();
    }

    public Collection<Object> getReadOwners(NodeSPI node) {
        return node.getLock().getReaderOwners();
    }

    public String printLockInfo(NodeSPI node) {
        StringBuilder sb = new StringBuilder("\n");
        int indent = 0;
        for (NodeSPI n : node.getChildrenDirect()) {
            n.getLock().printLockInfo(sb, indent);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String printLockInfo() {
        return this.printLockInfo(this.dataContainer.getRoot());
    }
}

