/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.PessimisticUnversionedNode;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeBasedLockManager;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PessimisticNodeBasedLockManager
extends NodeBasedLockManager {
    private static final Log log = LogFactory.getLog(PessimisticNodeBasedLockManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private CommandsFactory commandsFactory;

    @Inject
    void injectCommandsFactory(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    public boolean lockPessimistically(InvocationContext ctx, Fqn fqn, LockType lockType, boolean createIfNotExists, boolean zeroLockTimeout, boolean acquireWriteLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws InterruptedException {
        boolean created;
        if (fqn == null || this.configuration.getIsolationLevel() == IsolationLevel.NONE || ctx.isLockingSuppressed()) {
            return false;
        }
        long timeout = zeroLockTimeout ? 0L : ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout);
        long cutoffTime = System.currentTimeMillis() + timeout;
        boolean firstTry = true;
        do {
            if (!firstTry && System.currentTimeMillis() > cutoffTime) {
                throw new TimeoutException("Unable to acquire lock on Fqn " + fqn + " after " + timeout + " millis");
            }
            created = this.lock(ctx, fqn, lockType, createIfNotExists, timeout, acquireWriteLockOnParent, reverseRemoveCheck, createdNodes, skipNotification);
            firstTry = false;
        } while (createIfNotExists && this.dataContainer.peek(fqn, false, false) == null);
        return created;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean lock(InvocationContext ctx, Fqn fqn, LockType lockType, boolean createIfNotExists, long timeout, boolean acquireWriteLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws TimeoutException, LockingException, InterruptedException {
        Object owner;
        Thread currentThread = Thread.currentThread();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean created = false;
        int createdLevel = -1;
        if (gtx != null) {
            TransactionTable.assertTransactionValid(ctx);
        }
        Object object = owner = gtx != null ? gtx : currentThread;
        if (trace) {
            log.trace("Attempting to lock node " + fqn + " for owner " + owner);
        }
        long expiryTime = System.currentTimeMillis() + timeout;
        NodeSPI currentNode = this.rootNode;
        NodeSPI parent = null;
        Object childName = null;
        int currentIndex = -1;
        int targetFqnSize = fqn.size();
        while (true) {
            boolean skipLockAcquire = false;
            if (currentNode == null) {
                if (!createIfNotExists) {
                    if (!trace) return false;
                    log.trace("failed to find or create child " + childName + " of node " + parent);
                    return false;
                }
                PessimisticUnversionedNode parentInternalNode = (PessimisticUnversionedNode)parent.getDelegationTarget();
                currentNode = parentInternalNode.addChildAndAcquireLock(childName, !skipNotification, new LockAcquirer(ctx, LockType.WRITE, timeout, owner));
                skipLockAcquire = true;
                if (!created) {
                    created = true;
                    createdLevel = currentIndex;
                }
                if (trace) {
                    log.trace("Child node was null, so created child node " + childName);
                }
                if (createdNodes != null) {
                    createdNodes.add(currentNode);
                }
            } else if (!currentNode.isValid() && createIfNotExists) {
                currentNode.setValid(true, false);
            }
            LockType lockTypeRequired = LockType.READ;
            if (created || this.writeLockNeeded(ctx, lockType, currentIndex, acquireWriteLockOnParent, createIfNotExists, fqn, currentNode)) {
                lockTypeRequired = LockType.WRITE;
            }
            Fqn currentNodeFqn = currentNode.getFqn();
            if (!skipLockAcquire) {
                this.acquireNodeLock(ctx, currentNode, owner, lockTypeRequired, timeout);
            }
            LockUtil.manageReverseRemove(ctx, currentNode, reverseRemoveCheck, createdNodes, this.commandsFactory);
            NodeSPI repeek = this.dataContainer.peek(currentNodeFqn, true, true);
            if (currentNode != repeek) {
                if (trace) {
                    log.trace("Was waiting for and obtained a lock on a node that doesn't exist anymore!  Attempting lock acquisition again.");
                }
                currentNode.getLock().releaseAll(owner);
                if (parent == null || this.dataContainer.peek(parent.getFqn(), true, true) == null) {
                    if (trace) {
                        log.trace("Parent has been deleted again.  Go through the lock method all over again.");
                    }
                    currentNode = this.rootNode;
                    currentIndex = -1;
                    parent = null;
                    created = false;
                    createdLevel = -1;
                    continue;
                }
                currentNode = parent;
                if (createdLevel == currentIndex) {
                    created = false;
                    createdLevel = -1;
                }
                --currentIndex;
                parent = null;
                if (System.currentTimeMillis() > expiryTime) {
                    throw new TimeoutException("Unable to acquire lock on child node " + Fqn.fromRelativeElements(currentNode.getFqn(), childName) + " after " + timeout + " millis.");
                }
                if (!trace) continue;
                log.trace("Moving one level up, current node is :" + currentNode);
                continue;
            }
            if (++currentIndex == targetFqnSize) {
                return created;
            }
            if (!fqn.isChildOrEquals(currentNode.getFqn())) {
                String message = "currentNode instance changed the FQN(" + currentNode.getFqn() + ") and do not match the FQN on which we want to acquire lock(" + fqn + ")";
                log.trace(message);
                throw new LockingException(message);
            }
            parent = currentNode;
            childName = fqn.get(currentIndex);
            currentNode = currentNode.getChildDirect(childName);
        }
    }

    private boolean writeLockNeeded(InvocationContext ctx, LockType lockType, int currentNodeIndex, boolean acquireWriteLockOnParent, boolean createIfNotExists, Fqn targetFqn, NodeSPI currentNode) {
        boolean isTargetNode;
        int treeNodeSize = targetFqn.size();
        boolean bl = isTargetNode = currentNodeIndex == treeNodeSize - 1;
        if (isTargetNode && ctx.getOptionOverrides().isForceWriteLock()) {
            return true;
        }
        if (currentNode.isLockForChildInsertRemove()) {
            if (acquireWriteLockOnParent && currentNodeIndex == treeNodeSize - 2) {
                return true;
            }
            if (!isTargetNode && this.dataContainer.peek(targetFqn.getAncestor(currentNodeIndex + 2), false, false) == null) {
                return createIfNotExists;
            }
        }
        return lockType == LockType.WRITE && isTargetNode;
    }

    private void acquireNodeLock(InvocationContext ctx, NodeSPI node, Object owner, LockType lockType, long lockTimeout) throws LockingException, TimeoutException, InterruptedException {
        NodeLock lock = node.getLock();
        boolean acquired = lock.acquire(owner, lockTimeout, lockType);
        if (acquired) {
            ctx.addLock(lock);
        }
    }

    public class LockAcquirer {
        InvocationContext ctx;
        LockType type;
        long timeout;
        Object owner;

        public LockAcquirer(InvocationContext ctx, LockType type, long timeout, Object owner) {
            this.ctx = ctx;
            this.type = type;
            this.timeout = timeout;
            this.owner = owner;
        }

        public void acquire(NodeSPI node) {
            try {
                PessimisticNodeBasedLockManager.this.acquireNodeLock(this.ctx, node, this.owner, this.type, this.timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

