/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.cache.CacheException;
import org.jboss.util.stream.MarshalledValueInputStream;

public class MarshalledValue
implements Externalizable {
    protected Object instance;
    protected byte[] raw;
    private int cachedHashCode = 0;
    private transient boolean equalityPreferenceForInstance = true;

    public MarshalledValue(Object instance) throws NotSerializableException {
        if (instance == null) {
            throw new NullPointerException("Null values cannot be wrapped as MarshalledValues!");
        }
        if (!(instance instanceof Serializable)) {
            throw new NotSerializableException("Marshalled values can only wrap Objects that are serializable!  Instance of " + instance.getClass() + " won't Serialize.");
        }
        this.instance = instance;
    }

    public MarshalledValue() {
    }

    public void setEqualityPreferenceForInstance(boolean equalityPreferenceForInstance) {
        this.equalityPreferenceForInstance = equalityPreferenceForInstance;
    }

    public synchronized void serialize() {
        if (this.raw == null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.instance);
                oos.close();
                baos.close();
                this.raw = baos.toByteArray();
            }
            catch (Exception e) {
                throw new CacheException("Unable to marshall value " + this.instance, e);
            }
        }
    }

    public synchronized void deserialize() {
        if (this.instance == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.raw);
                MarshalledValueInputStream ois = new MarshalledValueInputStream(bais);
                this.instance = ois.readObject();
                ois.close();
                bais.close();
            }
            catch (Exception e) {
                throw new CacheException("Unable to unmarshall value", e);
            }
        }
    }

    public void compact(boolean preferSerializedRepresentation, boolean force) {
        this.equalityPreferenceForInstance = true;
        if (force) {
            if (preferSerializedRepresentation && this.raw == null) {
                this.serialize();
            } else if (!preferSerializedRepresentation && this.instance == null) {
                this.deserialize();
            }
        }
        if (this.instance != null && this.raw != null) {
            if (preferSerializedRepresentation) {
                this.instance = null;
            } else {
                this.raw = null;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.raw == null) {
            this.serialize();
        }
        out.writeInt(this.raw.length);
        out.write(this.raw);
        out.writeInt(this.hashCode());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.raw = new byte[size];
        this.cachedHashCode = 0;
        in.readFully(this.raw);
        this.cachedHashCode = in.readInt();
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.instance == null) {
            this.deserialize();
        }
        return this.instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledValue that = (MarshalledValue)o;
        if (this.raw != null && that.raw != null) {
            return Arrays.equals(this.raw, that.raw);
        }
        if (this.instance != null && that.instance != null) {
            return this.instance.equals(that.instance);
        }
        if (this.equalityPreferenceForInstance) {
            if (this.instance == null) {
                this.deserialize();
            }
            if (that.instance == null) {
                that.deserialize();
            }
            return this.instance.equals(that.instance);
        }
        if (this.raw == null) {
            this.serialize();
        }
        if (that.raw == null) {
            that.serialize();
        }
        return Arrays.equals(this.raw, that.raw);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            if (this.instance == null) {
                this.deserialize();
            }
            this.cachedHashCode = this.instance.hashCode();
            if (this.cachedHashCode == 0) {
                this.cachedHashCode = 65261;
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "MarshalledValue(cachedHashCode=" + this.cachedHashCode + "; serialized=" + (this.raw != null) + ")";
    }
}

