/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WorkspaceNodeImpl<K, V>
extends AbstractNode<K, V>
implements WorkspaceNode<K, V> {
    private static final Log log = LogFactory.getLog(WorkspaceNodeImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private NodeSPI<K, V> node;
    private TransactionWorkspace workspace;
    private DataVersion version = DefaultDataVersion.ZERO;
    private Map<Object, NodeSPI<K, V>> optimisticChildNodeMap;
    private Set<Fqn> childrenAdded;
    private Set<Fqn> childrenRemoved;
    private Map<K, V> optimisticDataMap;
    private NodeFactory<K, V> nodeFactory;

    public WorkspaceNodeImpl(NodeSPI<K, V> node, TransactionWorkspace workspace, NodeFactory<K, V> nodeFactory) {
        NodeInvocationDelegate delegate = (NodeInvocationDelegate)node;
        if (!(delegate.getDelegationTarget() instanceof VersionedNode)) {
            throw new IllegalArgumentException("node " + delegate.getDelegationTarget() + " not VersionedNode");
        }
        this.node = node;
        this.workspace = workspace;
        Map<K, V> nodeData = node.getDataDirect();
        if (!nodeData.isEmpty()) {
            this.optimisticDataMap = new HashMap<K, V>(nodeData);
        }
        this.version = node.getVersion();
        if (this.version == null) {
            throw new IllegalStateException("VersionedNode version null");
        }
        this.initFlags();
        this.nodeFactory = nodeFactory;
    }

    protected void initFlags() {
        this.setFlag(AbstractNode.NodeFlags.VERSIONING_IMPLICIT);
    }

    protected Set<Fqn> getChildrenAddedSet() {
        if (this.childrenAdded == null) {
            this.childrenAdded = new HashSet<Fqn>();
        }
        return this.childrenAdded;
    }

    protected Set<Fqn> getChildrenRemovedSet() {
        if (this.childrenRemoved == null) {
            this.childrenRemoved = new HashSet<Fqn>();
        }
        return this.childrenRemoved;
    }

    @Override
    public boolean isChildrenModified() {
        return this.isFlagSet(AbstractNode.NodeFlags.CHILDREN_MODIFIED_IN_WORKSPACE);
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.optimisticChildNodeMap != null;
    }

    @Override
    public boolean isResurrected() {
        return this.isFlagSet(AbstractNode.NodeFlags.RESURRECTED_IN_WORKSPACE);
    }

    @Override
    public void markAsResurrected(boolean resurrected) {
        this.setFlag(AbstractNode.NodeFlags.RESURRECTED_IN_WORKSPACE, resurrected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRemoved(boolean marker, boolean recursive) {
        this.setFlag(AbstractNode.NodeFlags.REMOVED, marker);
        if (recursive && this.children != null) {
            WorkspaceNodeImpl workspaceNodeImpl = this;
            synchronized (workspaceNodeImpl) {
                for (Object child : this.children.values()) {
                    ((NodeSPI)child).markAsDeleted(marker, true);
                }
            }
        }
        if (marker) {
            if (this.childrenAdded != null) {
                this.childrenAdded.clear();
            }
            if (this.childrenRemoved != null) {
                this.childrenRemoved.clear();
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.isFlagSet(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
    }

    @Override
    public boolean isDirty() {
        return this.isModified() || this.isCreated() || this.isRemoved();
    }

    @Override
    public Fqn getFqn() {
        return this.node.getFqn();
    }

    @Override
    public void putAll(Map<K, V> data) {
        this.realPut(data, false);
        this.setFlag(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
    }

    public void replaceAll(Map<K, V> data) {
        this.clearData();
        this.putAll(data);
    }

    @Override
    public V put(K key, V value) {
        this.setFlag(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
        if (this.optimisticDataMap == null) {
            this.optimisticDataMap = new HashMap();
        }
        return this.optimisticDataMap.put(key, value);
    }

    @Override
    public V remove(K key) {
        this.setFlag(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
        if (this.optimisticDataMap == null) {
            return null;
        }
        return this.optimisticDataMap.remove(key);
    }

    @Override
    public V get(K key) {
        return this.optimisticDataMap == null ? null : (V)this.optimisticDataMap.get(key);
    }

    @Override
    public Set<K> getKeys() {
        if (this.optimisticDataMap == null) {
            return Collections.emptySet();
        }
        return this.optimisticDataMap.keySet();
    }

    @Override
    public Set<Object> getChildrenNames() {
        if (this.optimisticChildNodeMap == null) {
            this.initialiseChildMap();
        }
        HashSet<Object> names = new HashSet<Object>(this.optimisticChildNodeMap.keySet());
        if (this.childrenAdded != null) {
            for (Fqn child : this.childrenAdded) {
                names.add(child.getLastElement());
            }
        }
        if (this.childrenRemoved != null) {
            for (Fqn child : this.childrenRemoved) {
                names.remove(child.getLastElement());
            }
        }
        return names;
    }

    private void initialiseChildMap() {
        Map<Object, Node<K, V>> childrenMap = this.node.getChildrenMapDirect();
        this.optimisticChildNodeMap = new HashMap<Object, Node<Object, NodeSPI<K, V>>>(childrenMap);
    }

    private void realPut(Map<K, V> data, boolean eraseData) {
        this.realPut(data, eraseData, true);
    }

    private void realPut(Map<K, V> data, boolean eraseData, boolean forceDirtyFlag) {
        if (forceDirtyFlag) {
            this.setFlag(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
        }
        if (eraseData && this.optimisticDataMap != null) {
            this.optimisticDataMap.clear();
        }
        if (data != null) {
            if (this.optimisticDataMap == null) {
                this.optimisticDataMap = new HashMap();
            }
            this.optimisticDataMap.putAll(data);
        }
    }

    public Node<K, V> getParent() {
        return this.node.getParent();
    }

    @Override
    public NodeSPI<K, V> createChild(Object childName, NodeSPI<K, V> parent, CacheSPI<K, V> cache, DataVersion version) {
        if (childName == null) {
            return null;
        }
        NodeSPI<K, V> child = this.nodeFactory.createNode(childName, parent);
        this.getChildrenAddedSet().add(child.getFqn());
        if (this.childrenRemoved != null) {
            this.childrenRemoved.remove(child.getFqn());
        }
        this.setFlag(AbstractNode.NodeFlags.CHILDREN_MODIFIED_IN_WORKSPACE);
        return child;
    }

    @Override
    public boolean isVersioningImplicit() {
        return this.isFlagSet(AbstractNode.NodeFlags.VERSIONING_IMPLICIT);
    }

    @Override
    public void setVersioningImplicit(boolean versioningImplicit) {
        this.setFlag(AbstractNode.NodeFlags.VERSIONING_IMPLICIT, versioningImplicit);
    }

    @Override
    public NodeSPI<K, V> getNode() {
        return this.node;
    }

    @Override
    public DataVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(DataVersion version) {
        this.version = version;
    }

    @Override
    public List<Set<Fqn>> getMergedChildren() {
        ArrayList<Set<Fqn>> l = new ArrayList<Set<Fqn>>(2);
        if (this.childrenAdded != null) {
            l.add(this.childrenAdded);
        } else {
            l.add(Collections.emptySet());
        }
        if (this.childrenRemoved != null) {
            l.add(this.childrenRemoved);
        } else {
            l.add(Collections.emptySet());
        }
        return l;
    }

    @Override
    public Map<K, V> getMergedData() {
        if (this.optimisticDataMap == null) {
            return Collections.emptyMap();
        }
        return this.optimisticDataMap;
    }

    @Override
    public TransactionWorkspace getTransactionWorkspace() {
        return this.workspace;
    }

    @Override
    public boolean isCreated() {
        return this.isFlagSet(AbstractNode.NodeFlags.CREATED_IN_WORKSPACE);
    }

    @Override
    public void markAsCreated() {
        this.setFlag(AbstractNode.NodeFlags.CREATED_IN_WORKSPACE);
    }

    @Override
    public Map<K, V> getData() {
        if (this.optimisticDataMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.optimisticDataMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRemoved()) {
            sb.append("del ");
        }
        if (this.isModified()) {
            sb.append("modified ");
        }
        if (this.isCreated()) {
            sb.append("new ");
        }
        return this.getClass().getSimpleName() + " [ fqn=" + this.getFqn() + " " + sb + "ver=" + this.version + " " + (this.isVersioningImplicit() ? "implicit" : "explicit") + "]";
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn f) {
        CacheSPI<K, V> cache = this.getCache();
        NodeSPI<K, V> newNode = null;
        GlobalTransaction gtx = cache.getInvocationContext().getGlobalTransaction();
        if (f.size() == 1) {
            newNode = this.createChild(f.get(0), this.node, this.getCache(), this.version);
        } else {
            NodeSPI<K, V> currentParent = this.getNode();
            for (Object o : f.peekElements()) {
                newNode = currentParent instanceof WorkspaceNode ? ((WorkspaceNode)((Object)currentParent)).getNode().getOrCreateChild(o, gtx) : (currentParent instanceof WorkspaceNode ? ((WorkspaceNode)((Object)currentParent)).getNode().getOrCreateChild(o, gtx) : currentParent.getOrCreateChild(o, gtx));
                currentParent = newNode;
            }
        }
        return newNode;
    }

    @Override
    public void addChild(WorkspaceNode<K, V> child) {
        this.getChildrenAddedSet().add(child.getFqn());
        if (this.childrenRemoved != null) {
            this.childrenRemoved.remove(child.getFqn());
        }
        if (trace) {
            log.trace("Adding child " + child.getFqn());
        }
    }

    @Override
    public void clearData() {
        if (this.optimisticDataMap != null) {
            this.optimisticDataMap.clear();
            this.setFlag(AbstractNode.NodeFlags.MODIFIED_IN_WORKSPACE);
        }
    }

    public int dataSize() {
        return this.optimisticDataMap == null ? 0 : this.optimisticDataMap.size();
    }

    public boolean hasChild(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isLockForChildInsertRemove() {
        throw new UnsupportedOperationException();
    }

    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        throw new UnsupportedOperationException();
    }

    public void releaseObjectReferences(boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Fqn f) {
        if (f.size() > 1) {
            throw new UnsupportedOperationException("Workspace node does not support fetching indirect children");
        }
        return this.getChildDirect(f.getLastElement());
    }

    @Override
    public Set getChildren() {
        throw new UnsupportedOperationException();
    }

    public boolean hasChild(Fqn f) {
        throw new UnsupportedOperationException();
    }

    public NodeSPI<K, V> getNodeSPI() {
        throw new UnsupportedOperationException("WorkspaceNode has no access to a NodeSPI");
    }

    public V putIfAbsent(K k, V v) {
        throw new UnsupportedOperationException();
    }

    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    public boolean removeChild(Fqn f) {
        if (f.size() > 1) {
            throw new UnsupportedOperationException("Workspace nodes can only remove direct children!");
        }
        Object key = f.getLastElement();
        return this.removeChild(key);
    }

    @Override
    public boolean removeChild(Object childName) {
        Fqn<Object> childFqn = Fqn.fromRelativeElements(this.getFqn(), childName);
        this.getChildrenRemovedSet().add(childFqn);
        if (this.childrenAdded != null) {
            this.childrenAdded.remove(childFqn);
        }
        this.setFlag(AbstractNode.NodeFlags.CHILDREN_MODIFIED_IN_WORKSPACE);
        return this.node.getChildDirect(childName) != null;
    }

    protected CacheSPI<K, V> getCache() {
        return this.node.getCache();
    }
}

