/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.Node;
import org.jboss.cache.RPCManager;
import org.jboss.cache.RPCManagerImpl;
import org.jboss.cache.Version;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.statetransfer.StateProviderBusyException;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.transaction.TransactionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStateTransferGenerator
implements StateTransferGenerator {
    public static final short STATE_TRANSFER_VERSION = Version.getVersionShort("2.0.0.GA");
    private static final Log log = LogFactory.getLog(DefaultStateTransferGenerator.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheSPI cache;
    private RPCManager rpcManager;
    private Set<Fqn> internalFqns;
    private boolean nonBlocking;
    private long flushTimeout;
    private int maxNonProgressingLogWrites = 5;
    private TransactionLog txLog;

    @Inject
    public void inject(CacheSPI cache, RPCManager rpcManager, Configuration configuration, TransactionLog txLog) {
        this.cache = cache;
        this.nonBlocking = true;
        this.flushTimeout = configuration.getStateRetrievalTimeout();
        this.nonBlocking = configuration.isNonBlockingStateTransfer();
        this.txLog = txLog;
        this.rpcManager = rpcManager;
    }

    @Start(priority=14)
    void start() {
        this.internalFqns = this.cache.getInternalFqns();
    }

    @Override
    public void generateState(ObjectOutputStream out, Object rootNode, boolean generateTransient, boolean generatePersistent, boolean suppressErrors) throws Exception {
        Fqn fqn = this.getFqn(rootNode);
        boolean activated = false;
        CacheLoader cacheLoader = this.cache.getCacheLoaderManager() == null ? null : this.cache.getCacheLoaderManager().getCacheLoader();
        boolean needToGeneratePersistentState = generatePersistent && cacheLoader != null;
        try {
            this.cache.getMarshaller().objectToObjectStream(STATE_TRANSFER_VERSION, out);
            if (this.nonBlocking && (generateTransient || needToGeneratePersistentState)) {
                activated = this.txLog.activate();
                if (!activated) {
                    throw new StateProviderBusyException("Busy performing state transfer for someone else");
                }
                if (trace) {
                    log.trace("Transaction log activated!");
                }
            }
            if (generateTransient) {
                if (trace) {
                    log.trace("writing transient state for " + fqn);
                }
                this.marshallTransientState((InternalNode)rootNode, out);
                if (trace) {
                    log.trace("transient state succesfully written");
                }
                if (trace) {
                    log.trace("writing associated state");
                }
                this.delimitStream(out);
                if (trace) {
                    log.trace("associated state succesfully written");
                }
            } else {
                this.delimitStream(out);
                this.delimitStream(out);
            }
            if (needToGeneratePersistentState) {
                this.writePersistentData(out, fqn, cacheLoader);
            }
            this.delimitStream(out);
            if (this.nonBlocking && generateTransient) {
                this.writeTxLog(out);
            }
        }
        catch (Exception e) {
            this.cache.getMarshaller().objectToObjectStream(new NodeDataExceptionMarker(e, this.cache.getLocalAddress()), out);
            throw e;
        }
        finally {
            if (activated) {
                this.txLog.deactivate();
            }
        }
    }

    private void writePersistentData(ObjectOutputStream out, Fqn fqn, CacheLoader cacheLoader) throws Exception {
        if (trace) {
            log.trace("writing persistent state for " + fqn + ", using " + this.cache.getCacheLoaderManager().getCacheLoader().getClass());
        }
        if (fqn.isRoot()) {
            cacheLoader.loadEntireState(out);
        } else {
            cacheLoader.loadState(fqn, out);
        }
        if (trace) {
            log.trace("persistent state succesfully written");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTxLog(ObjectOutputStream out) throws Exception {
        RPCManagerImpl.FlushTracker flushTracker = this.rpcManager.getFlushTracker();
        try {
            if (trace) {
                log.trace("Transaction log size is " + this.txLog.size());
            }
            int nonProgress = 0;
            int size = this.txLog.size();
            while (size > 0) {
                if (trace) {
                    log.trace("Tx Log remaining entries = " + size);
                }
                this.txLog.writeCommitLog(this.cache.getMarshaller(), out);
                int newSize = this.txLog.size();
                if (newSize >= size && ++nonProgress >= this.maxNonProgressingLogWrites) break;
                size = newSize;
            }
            flushTracker.lockSuspendProcessingLock();
            this.delimitStream(out);
            out.flush();
            if (trace) {
                log.trace("Waiting for a FLUSH");
            }
            flushTracker.waitForFlushStart(this.flushTimeout);
            if (trace) {
                log.trace("FLUSH received, proceeding with writing commit log");
            }
            this.txLog.writeCommitLog(this.cache.getMarshaller(), out);
            this.delimitStream(out);
            this.txLog.writePendingPrepares(this.cache.getMarshaller(), out);
            this.delimitStream(out);
            out.flush();
        }
        finally {
            flushTracker.unlockSuspendProcessingLock();
        }
    }

    private Fqn getFqn(Object o) {
        if (o instanceof Node) {
            return ((Node)o).getFqn();
        }
        if (o instanceof InternalNode) {
            return ((InternalNode)o).getFqn();
        }
        throw new IllegalArgumentException();
    }

    protected void delimitStream(ObjectOutputStream out) throws Exception {
        this.cache.getMarshaller().objectToObjectStream(DefaultStateTransferManager.STREAMING_DELIMITER_NODE, out);
    }

    protected void marshallTransientState(InternalNode node, ObjectOutputStream out) throws Exception {
        LinkedList<NodeData> nodeData = new LinkedList<NodeData>();
        this.generateNodeDataList(node, nodeData);
        this.cache.getMarshaller().objectToObjectStream(nodeData, out, node.getFqn());
    }

    protected void generateNodeDataList(InternalNode<?, ?> node, List<NodeData> list) throws Exception {
        if (this.internalFqns.contains(node.getFqn())) {
            return;
        }
        Map attrs = node.getInternalState(false);
        NodeData nd = attrs.size() == 0 ? new NodeData(node.getFqn()) : new NodeData(node.getFqn(), attrs, true);
        list.add(nd);
        for (InternalNode<?, ?> child : node.getChildren()) {
            this.generateNodeDataList(child, list);
        }
    }
}

