/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.ChannelException;
import org.jgroups.conf.PlainConfigurator;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

public class ConfiguratorFactory {
    public static final String JAXP_MISSING_ERROR_MSG = "JAXP Error: the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.";
    static final String FORCE_CONFIGURATION = "force.properties";
    static final Log log = LogFactory.getLog(ConfiguratorFactory.class);
    static String propertiesOverride = null;

    protected ConfiguratorFactory() {
    }

    public static ProtocolStackConfigurator getStackConfigurator(File file) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            try {
                ConfiguratorFactory.checkJAXPAvailability();
                InputStream input = ConfiguratorFactory.getConfigStream(file);
                returnValue = XmlConfigurator.getInstance(input);
            }
            catch (Exception ex) {
                throw ConfiguratorFactory.createChannelConfigurationException(ex);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(URL url) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(url);
            ConfiguratorFactory.checkJAXPAvailability();
            try {
                returnValue = XmlConfigurator.getInstance(url);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(Element element) throws ChannelException {
        ProtocolStackConfigurator returnValue;
        if (propertiesOverride != null) {
            returnValue = ConfiguratorFactory.getStackConfigurator(propertiesOverride);
        } else {
            ConfiguratorFactory.checkForNullConfiguration(element);
            try {
                returnValue = XmlConfigurator.getInstance(element);
            }
            catch (IOException ioe) {
                throw ConfiguratorFactory.createChannelConfigurationException(ioe);
            }
        }
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(String properties) throws ChannelException {
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "udp.xml";
        }
        ConfiguratorFactory.checkForNullConfiguration(properties);
        XmlConfigurator configurator = null;
        try {
            configurator = ConfiguratorFactory.getXmlConfigurator(properties);
        }
        catch (IOException ioe) {
            throw ConfiguratorFactory.createChannelConfigurationException(ioe);
        }
        ProtocolStackConfigurator returnValue = configurator != null ? configurator : new PlainConfigurator(properties);
        return returnValue;
    }

    public static ProtocolStackConfigurator getStackConfigurator(Object properties) throws IOException {
        InputStream input = null;
        if (propertiesOverride != null) {
            properties = propertiesOverride;
        }
        if (properties == null) {
            properties = "udp.xml";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (input == null && properties instanceof String) {
            try {
                input = new URL((String)properties).openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (input == null && ((String)properties).endsWith("xml")) {
                try {
                    input = Util.getResourceAsStream((String)properties, ConfiguratorFactory.class);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (input == null) {
                try {
                    input = new FileInputStream((String)properties);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return XmlConfigurator.getInstance(input);
        }
        if (properties instanceof Element) {
            return XmlConfigurator.getInstance((Element)properties);
        }
        return new PlainConfigurator((String)properties);
    }

    public static InputStream getConfigStream(File file) throws Exception {
        if (propertiesOverride != null) {
            return ConfiguratorFactory.getConfigStream(propertiesOverride);
        }
        ConfiguratorFactory.checkForNullConfiguration(file);
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw ConfiguratorFactory.createChannelConfigurationException(ioe);
        }
    }

    public static InputStream getConfigStream(URL url) throws Exception {
        if (propertiesOverride != null) {
            return ConfiguratorFactory.getConfigStream(propertiesOverride);
        }
        try {
            ConfiguratorFactory.checkJAXPAvailability();
            return url.openStream();
        }
        catch (Exception ex) {
            throw ConfiguratorFactory.createChannelConfigurationException(ex);
        }
    }

    public static InputStream getConfigStream(String properties) throws IOException {
        InputStream configStream = null;
        if (propertiesOverride != null) {
            return ConfiguratorFactory.getConfigStream(propertiesOverride);
        }
        try {
            configStream = new FileInputStream(properties);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (AccessControlException access_ex) {
            // empty catch block
        }
        if (configStream == null) {
            try {
                configStream = new URL(properties).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (configStream == null && properties.endsWith("xml")) {
            configStream = Util.getResourceAsStream(properties, ConfiguratorFactory.class);
        }
        return configStream;
    }

    public static InputStream getConfigStream(Object properties) throws IOException {
        InputStream input = null;
        if (propertiesOverride != null) {
            return ConfiguratorFactory.getConfigStream(propertiesOverride);
        }
        if (properties == null) {
            properties = "udp.xml";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (input == null && properties instanceof String) {
            input = ConfiguratorFactory.getConfigStream((String)properties);
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return input;
        }
        if (properties instanceof Element) {
            return ConfiguratorFactory.getConfigStream((Element)properties);
        }
        return new ByteArrayInputStream(((String)properties).getBytes());
    }

    static XmlConfigurator getXmlConfigurator(String properties) throws IOException {
        XmlConfigurator returnValue = null;
        InputStream configStream = ConfiguratorFactory.getConfigStream(properties);
        if (configStream != null) {
            ConfiguratorFactory.checkJAXPAvailability();
            returnValue = XmlConfigurator.getInstance(configStream);
        }
        return returnValue;
    }

    static ChannelException createChannelConfigurationException(Throwable cause) {
        return new ChannelException("unable to load the protocol stack", cause);
    }

    static void checkForNullConfiguration(Object properties) {
        if (properties == null) {
            throw new NullPointerException("the specifed protocol stack configuration was null");
        }
    }

    static void checkJAXPAvailability() {
        try {
            XmlConfigurator.class.getName();
        }
        catch (NoClassDefFoundError error) {
            NoClassDefFoundError tmp = new NoClassDefFoundError(JAXP_MISSING_ERROR_MSG);
            tmp.initCause(error);
            throw tmp;
        }
    }

    public static void substituteVariables(ProtocolStackConfigurator configurator) {
        ProtocolData[] protocols;
        try {
            protocols = configurator.getProtocolStack();
        }
        catch (Exception e) {
            protocols = null;
        }
        if (protocols == null) {
            return;
        }
        for (int i = 0; i < protocols.length; ++i) {
            ProtocolData protocol = protocols[i];
            if (protocol == null) continue;
            HashMap parms = protocol.getParameters();
            for (Map.Entry entry : parms.entrySet()) {
                ProtocolParameter parm = (ProtocolParameter)entry.getValue();
                String val = parm.getValue();
                String replacement = Util.substituteVariable(val);
                if (replacement.equals(val)) continue;
                parm.setValue(replacement);
            }
        }
    }

    static {
        try {
            Properties properties = System.getProperties();
            propertiesOverride = properties.getProperty(FORCE_CONFIGURATION);
        }
        catch (SecurityException e) {
            propertiesOverride = null;
        }
        if (propertiesOverride != null && log.isDebugEnabled()) {
            log.debug("using properties override: " + propertiesOverride);
        }
    }
}

