/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

public class GossipRouterTest
extends TestCase {
    String props = null;
    GossipRouter router;
    String router_host = null;
    int router_port = 0;
    JChannel c1;
    JChannel c2;

    protected void setUp() throws Exception {
        super.setUp();
        this.router_host = System.getProperty("jgroups.tunnel.router_host", "127.0.0.1");
        this.router_port = Integer.parseInt(System.getProperty("jgroups.tunnel.router_port", "12001"));
        this.props = this.getTUNNELProps(this.router_host, this.router_port);
    }

    protected void tearDown() throws Exception {
        if (this.router != null) {
            this.stopRouter();
        }
        if (this.c2 != null) {
            this.c2.close();
        }
        if (this.c1 != null) {
            this.c1.close();
        }
        super.tearDown();
    }

    private String getTUNNELProps(String routerHost, int routerPort) {
        return "TUNNEL(router_port=" + this.router_port + ";router_host=" + this.router_host + ";loopback=true):" + "PING(timeout=2000;num_initial_members=2;gossip_refresh=10000;gossip_host=" + this.router_host + ";gossip_port=" + this.router_port + ";num_ping_requests=1):" + "MERGE2(min_interval=5000;max_interval=20000):" + "FD(timeout=2000;max_tries=3;shun=true):" + "VERIFY_SUSPECT(timeout=1500):" + "pbcast.NAKACK(use_mcast_xmit=false;gc_lag=0;retransmit_timeout=300,600,1200,2400,4800;discard_delivered_msgs=true):" + "UNICAST(timeout=300,600,1200,2400,3600):" + "pbcast.STABLE(stability_delay=1000;desired_avg_gossip=5000;max_bytes=400000):" + "pbcast.GMS(join_timeout=3000;join_retry_timeout=2000;print_local_addr=true;shun=false;view_bundling=true;view_ack_collection_timeout=5000):" + "FC(max_credits=2000000;min_threshold=0.10):" + "FRAG2(frag_size=60000):" + "pbcast.STATE_TRANSFER:" + "pbcast.FLUSH(timeout=0)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLateStart() throws Exception {
        ReentrantLock lock = new ReentrantLock();
        Condition cond = lock.newCondition();
        AtomicBoolean done = new AtomicBoolean(false);
        System.out.println("-- starting first channel");
        this.c1 = new JChannel(this.props);
        GossipRouterTest.changeMergeInterval(this.c1);
        GossipRouterTest.setReconnectInterval(this.c1);
        GossipRouterTest.setRefreshInterval(this.c1);
        this.c1.setReceiver(new MyReceiver("c1", done, lock, cond));
        this.c1.connect("demo");
        System.out.println("-- starting second channel");
        this.c2 = new JChannel(this.props);
        GossipRouterTest.changeMergeInterval(this.c2);
        GossipRouterTest.setReconnectInterval(this.c2);
        GossipRouterTest.setRefreshInterval(this.c2);
        this.c2.setReceiver(new MyReceiver("c2", done, lock, cond));
        this.c2.connect("demo");
        System.out.println("-- starting GossipRouter");
        this.startRouter(this.router_host, this.router_port);
        System.out.println("-- waiting for merge to happen --");
        long target_time = System.currentTimeMillis() + 40000L;
        lock.lock();
        try {
            while (System.currentTimeMillis() < target_time && !done.get()) {
                cond.await(1000L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            lock.unlock();
        }
        Util.sleep(500L);
        View view = this.c1.getView();
        System.out.println("view=" + view);
        GossipRouterTest.assertEquals((int)2, (int)view.size());
        this.c2.close();
        this.c1.close();
    }

    private static void changeMergeInterval(JChannel c1) {
        MERGE2 merge = (MERGE2)c1.getProtocolStack().findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(1000L);
            merge.setMaxInterval(3000L);
        }
    }

    private static void setReconnectInterval(JChannel channel) {
        TUNNEL tunnel = (TUNNEL)channel.getProtocolStack().getTransport();
        if (tunnel != null) {
            tunnel.setReconnectInterval(2000L);
        }
    }

    private static void setRefreshInterval(JChannel channel) {
        PING ping = (PING)channel.getProtocolStack().findProtocol(PING.class);
        if (ping != null) {
            ping.setGossipRefresh(1000L);
        }
    }

    private void startRouter(String router_host, int router_port) throws Exception {
        this.router = new GossipRouter(router_port, router_host);
        this.router.start();
    }

    private void stopRouter() {
        this.router.stop();
        this.router = null;
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final String name;
        private final Lock lock;
        private final AtomicBoolean done;
        private final Condition cond;

        public MyReceiver(String name, AtomicBoolean done, Lock lock, Condition cond) {
            this.name = name;
            this.done = done;
            this.lock = lock;
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            if (new_view.size() == 2) {
                System.out.println("[" + this.name + "]: view=" + new_view);
                this.lock.lock();
                try {
                    this.done.set(true);
                    this.cond.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

