/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class StateTransferTest
extends ChannelTestBase {
    private static final int MSG_SEND_COUNT = 10000;
    private static final int APP_COUNT = 2;

    public StateTransferTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStateTransferFromSelfWithRegularChannel() throws Exception {
        JChannel ch = this.createChannel();
        ((Channel)ch).connect("test");
        try {
            boolean rc = ((Channel)ch).getState(null, 2000L);
            StateTransferTest.assertFalse((String)"getState() on singleton should return false", (boolean)rc);
        }
        finally {
            ((Channel)ch).close();
        }
    }

    public void testStateTransferWhileSending() throws Exception {
        int i;
        ChannelTestBase.ChannelRetrievable[] apps = new StateTransferApplication[2];
        Semaphore semaphore = new Semaphore(2);
        semaphore.acquire(2);
        int from = 0;
        int to = 10000;
        String[] names = this.createApplicationNames(2);
        for (i = 0; i < apps.length; ++i) {
            apps[i] = new StateTransferApplication(semaphore, names[i], from, to);
            from += 10000;
            to += 10000;
        }
        for (i = 0; i < apps.length; ++i) {
            StateTransferApplication app = apps[i];
            app.start();
            semaphore.release();
            Util.sleep(4000L);
        }
        StateTransferTest.blockUntilViewsReceived(apps, 60000L);
        Util.sleep(1000L);
        boolean acquired = semaphore.tryAcquire(apps.length, 30L, TimeUnit.SECONDS);
        if (!acquired) {
            this.log.warn("Most likely a bug, analyse the stack below:");
            this.log.warn(Util.dumpThreads());
        }
        for (int i2 = 0; i2 < apps.length; ++i2) {
            ChannelTestBase.ChannelRetrievable w = apps[i2];
            Map m = ((StateTransferApplication)w).getMap();
            this.log.info("map has " + m.size() + " elements");
            StateTransferTest.assertEquals((int)20000, (int)m.size());
        }
        Set keys = ((StateTransferApplication)apps[0]).getMap().keySet();
        for (int i3 = 0; i3 < apps.length; ++i3) {
            ChannelTestBase.ChannelRetrievable app = apps[i3];
            Map m = ((StateTransferApplication)app).getMap();
            Set s = m.keySet();
            StateTransferTest.assertEquals(keys, s);
        }
        for (ChannelTestBase.ChannelRetrievable app : apps) {
            ((ChannelTestBase.ChannelApplication)app).cleanup();
        }
    }

    public static Test suite() {
        return new TestSuite(StateTransferTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StateTransferTest.suite());
    }

    protected class StateTransferApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final ReentrantLock mapLock;
        private Map map;
        private int from;
        private int to;

        public StateTransferApplication(Semaphore semaphore, String name, int from, int to) throws Exception {
            super(name, semaphore);
            this.mapLock = new ReentrantLock();
            this.map = new HashMap(20000);
            this.from = from;
            this.to = to;
        }

        public Map getMap() {
            Map result = null;
            this.mapLock.lock();
            result = Collections.unmodifiableMap(this.map);
            this.mapLock.unlock();
            return result;
        }

        public void receive(Message msg) {
            Object[] data = (Object[])msg.getObject();
            this.mapLock.lock();
            this.map.put(data[0], data[1]);
            int num_received = this.map.size();
            this.mapLock.unlock();
            if (num_received % 1000 == 0) {
                StateTransferTest.this.log.info("received " + num_received);
            }
            if (num_received >= 20000) {
                this.semaphore.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            byte[] result = null;
            this.mapLock.lock();
            try {
                result = Util.objectToByteBuffer(this.map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mapLock.unlock();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            this.mapLock.lock();
            try {
                this.map = (Map)Util.objectFromByteBuffer(state);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mapLock.unlock();
            }
            StateTransferTest.this.log.info("received state, map has " + this.map.size() + " elements");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            this.mapLock.lock();
            try {
                ObjectOutputStream out = new ObjectOutputStream(ostream);
                out.writeObject(this.map);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.mapLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            this.mapLock.lock();
            try {
                ObjectInputStream in = new ObjectInputStream(istream);
                this.map = (Map)in.readObject();
                StateTransferTest.this.log.info("received state, map has " + this.map.size() + " elements");
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                this.mapLock.unlock();
            }
        }

        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                StateTransferTest.this.log.error(this.name + ": " + e.getLocalizedMessage(), e);
                this.exception = e;
            }
        }

        protected void useChannel() throws Exception {
            this.channel.connect("test", null, null, 10000L);
            Object[] data = new Object[2];
            for (int i = this.from; i < this.to; ++i) {
                data[0] = new Integer(i);
                data[1] = "Value #" + i;
                try {
                    this.channel.send(null, null, (Serializable)data);
                    if (i % 100 == 0) {
                        Util.sleep(50L);
                    }
                    if (i % 1000 != 0) continue;
                    StateTransferTest.this.log.info("sent " + i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}

