/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.util.UUID;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.modeshape.connector.jbosscache.JBossCacheNode;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.MapWorkspace;

public class JBossCacheWorkspace
extends MapWorkspace<JBossCacheNode> {
    private Cache<UUID, JBossCacheNode> workspaceCache;
    private Node<UUID, JBossCacheNode> workspaceNode;

    protected static Node<UUID, JBossCacheNode> findOrCreateWorkspaceRoot(String workspaceName, Cache<UUID, JBossCacheNode> workspaceCache, UUID rootNodeUuid) {
        JBossCacheNode rootNode;
        assert (workspaceName != null);
        assert (workspaceCache != null);
        assert (rootNodeUuid != null);
        Node<UUID, JBossCacheNode> workspace = workspaceCache.getRoot().getChild(Fqn.fromElements(workspaceName));
        if (workspace == null) {
            workspace = workspaceCache.getRoot().addChild(Fqn.fromElements(workspaceName));
        }
        if ((rootNode = workspace.get(rootNodeUuid)) == null) {
            rootNode = new JBossCacheNode(rootNodeUuid);
            workspace.put(rootNodeUuid, rootNode);
        }
        return workspace;
    }

    public JBossCacheWorkspace(String name, Cache<UUID, JBossCacheNode> workspaceCache, JBossCacheNode rootNode) {
        super(name, (MapNode)rootNode);
        this.workspaceCache = workspaceCache;
        this.workspaceNode = JBossCacheWorkspace.findOrCreateWorkspaceRoot(this.name, this.workspaceCache, this.rootNodeUuid);
    }

    public JBossCacheWorkspace(String name, Cache<UUID, JBossCacheNode> workspaceCache, JBossCacheWorkspace originalToClone) {
        super(name, (MapWorkspace)originalToClone);
        this.workspaceCache = workspaceCache;
        this.workspaceNode = JBossCacheWorkspace.findOrCreateWorkspaceRoot(this.name, this.workspaceCache, this.rootNodeUuid);
    }

    public JBossCacheNode getNode(UUID uuid) {
        assert (uuid != null);
        return this.workspaceNode.get(uuid);
    }

    public JBossCacheNode putNode(JBossCacheNode node) {
        assert (node != null);
        JBossCacheNode result = this.workspaceNode.put(node.getUuid(), node);
        this.workspaceNode = JBossCacheWorkspace.findOrCreateWorkspaceRoot(this.name, this.workspaceCache, this.rootNodeUuid);
        return result;
    }

    public JBossCacheNode removeNode(UUID uuid) {
        assert (uuid != null);
        JBossCacheNode result = this.workspaceNode.remove(uuid);
        this.workspaceNode = JBossCacheWorkspace.findOrCreateWorkspaceRoot(this.name, this.workspaceCache, this.rootNodeUuid);
        return result;
    }

    public void removeAll() {
        this.workspaceNode.clearData();
        this.workspaceNode = JBossCacheWorkspace.findOrCreateWorkspaceRoot(this.name, this.workspaceCache, this.rootNodeUuid);
    }

    public void shutdown() {
        this.workspaceCache.stop();
    }
}

