/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.connector.jcr.JcrConnectorI18n;
import org.modeshape.connector.jcr.JcrRepositoryConnection;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;

@ThreadSafe
public class JcrRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String REPOSITORY_JNDI_NAME = "repositoryJndiName";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String CREDENTIALS = "credentials";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String RETRY_LIMIT = "retryLimit";
    public static final int DEFAULT_RETRY_LIMIT = 0;
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = true;
    protected static final boolean SUPPORTS_UPDATES = true;
    protected static final boolean SUPPORTS_CREATING_WORKSPACES = false;
    protected static final boolean SUPPORTS_REFERENCES = false;
    private volatile String name;
    private volatile String repositoryJndiName;
    private volatile String username;
    private volatile String password;
    private volatile Credentials credentials;
    private volatile CachePolicy defaultCachePolicy;
    private volatile int retryLimit = 0;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, true, false, false);
    private transient Repository repository;
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        this.name = name;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean getUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public String getRepositoryJndiName() {
        return this.repositoryJndiName;
    }

    public void setRepositoryJndiName(String repositoryJndiName) {
        if (repositoryJndiName != null && repositoryJndiName.trim().length() == 0) {
            repositoryJndiName = null;
        }
        this.repositoryJndiName = repositoryJndiName;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        if (this.defaultCachePolicy == defaultCachePolicy || this.defaultCachePolicy != null && this.defaultCachePolicy.equals(defaultCachePolicy)) {
            return;
        }
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public synchronized void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    protected RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    protected synchronized Repository getRepository() {
        return this.repository;
    }

    protected synchronized void setRepository(Repository repository) {
        this.repository = repository;
    }

    protected synchronized Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public synchronized Reference getReference() {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos;
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(REPOSITORY_JNDI_NAME, this.getRepositoryJndiName()));
        ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        if (this.getCredentials() != null) {
            baos = new ByteArrayOutputStream();
            Credentials credentials = this.getCredentials();
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(credentials);
                ref.add(new BinaryRefAddr(CREDENTIALS, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = JcrConnectorI18n.errorSerializingObjectUsedInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{credentials.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        if (this.getDefaultCachePolicy() != null) {
            baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = JcrConnectorI18n.errorSerializingObjectUsedInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String repositoryJndiName = (String)values.get(REPOSITORY_JNDI_NAME);
            String username = (String)values.get(USERNAME);
            String password = (String)values.get(PASSWORD);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            Object credentials = values.get(CREDENTIALS);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY);
            JcrRepositorySource source = new JcrRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (repositoryJndiName != null) {
                source.setRepositoryJndiName(repositoryJndiName);
            }
            if (username != null) {
                source.setUsername(username);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (credentials instanceof Credentials) {
                source.setCredentials((Credentials)credentials);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            return source;
        }
        return null;
    }

    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.name == null || this.name.trim().length() == 0) {
            I18n msg = JcrConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.name, msg.text(new Object[]{"name"}));
        }
        if (this.repositoryJndiName == null || this.repositoryJndiName.trim().length() == 0) {
            I18n msg = JcrConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{REPOSITORY_JNDI_NAME}));
        }
        if (this.repository == null) {
            Context context = this.getContext();
            if (context == null) {
                try {
                    context = new InitialContext();
                }
                catch (NamingException err) {
                    throw new RepositorySourceException(this.name, (Throwable)err);
                }
            }
            Repository repository = null;
            Object object = null;
            try {
                object = context.lookup(this.repositoryJndiName);
                if (object != null) {
                    repository = (Repository)object;
                }
            }
            catch (ClassCastException err) {
                I18n msg = JcrConnectorI18n.objectFoundInJndiWasNotRepository;
                String className = object != null ? object.getClass().getName() : "null";
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{this.repositoryJndiName, this.getName(), className}), (Throwable)err);
            }
            catch (Throwable err) {
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                throw new RepositorySourceException(this.getName(), err);
            }
            if (repository == null) {
                I18n msg = JcrConnectorI18n.repositoryObjectNotFoundInJndi;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{this.repositoryJndiName}));
            }
            this.repository = repository;
        }
        assert (this.repository != null);
        Credentials credentials = this.getCredentials();
        if (credentials == null || this.username != null || this.password != null) {
            char[] passwd = this.password != null ? this.password.toCharArray() : new char[]{};
            credentials = new SimpleCredentials(this.username, passwd);
        }
        return new JcrRepositoryConnection(this, this.repository, credentials);
    }

    public void close() {
        this.repositoryContext = null;
        this.repository = null;
    }
}

