/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jcr;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.collection.Collections;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.BasicNamespace;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

public class JcrNamespaceRegistry
implements NamespaceRegistry {
    private final String sourceName;
    private final String defaultNamespaceUri;
    private final NamespaceRegistry cache;
    private final Session session;
    private final javax.jcr.NamespaceRegistry jcrRegistry;
    private final NamespaceRegistry connectorRegistry;

    JcrNamespaceRegistry(String sourceName, Session session, NamespaceRegistry connectorRegistry) throws RepositoryException {
        this.sourceName = sourceName;
        this.session = session;
        this.jcrRegistry = this.session.getWorkspace().getNamespaceRegistry();
        this.connectorRegistry = connectorRegistry;
        this.cache = new SimpleNamespaceRegistry();
        assert (this.session != null);
        assert (this.cache != null);
        assert (this.jcrRegistry != null);
        assert (this.sourceName != null);
        this.defaultNamespaceUri = this.getNamespaceForPrefix("");
    }

    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    public String getNamespaceForPrefix(String prefix) {
        String uri = this.cache.getNamespaceForPrefix(prefix);
        if (uri == null) {
            try {
                uri = this.jcrRegistry.getURI(prefix);
                this.ensureRegisteredInConnector(prefix, uri);
            }
            catch (NamespaceException e) {
            }
            catch (RepositoryException e) {
                throw new RepositorySourceException(this.sourceName, (Throwable)e);
            }
        }
        return uri;
    }

    protected void ensureRegisteredInConnector(String prefix, String uri) {
        if (!this.connectorRegistry.isRegisteredNamespaceUri(uri)) {
            int index = 0;
            while (this.connectorRegistry.getNamespaceForPrefix(prefix) != null) {
                prefix = prefix + ++index;
            }
            this.connectorRegistry.register(prefix, uri);
        }
    }

    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        HashSet<NamespaceRegistry.Namespace> namespaces = new HashSet<NamespaceRegistry.Namespace>();
        try {
            for (String prefix : this.jcrRegistry.getPrefixes()) {
                String uri = this.jcrRegistry.getURI(prefix);
                namespaces.add((NamespaceRegistry.Namespace)new BasicNamespace(prefix, uri));
            }
        }
        catch (RepositoryException e) {
            throw new RepositorySourceException(this.sourceName, (Throwable)e);
        }
        return namespaces;
    }

    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        String prefix = this.cache.getPrefixForNamespaceUri(namespaceUri, false);
        if (prefix == null) {
            try {
                prefix = this.jcrRegistry.getPrefix(namespaceUri);
                this.ensureRegisteredInConnector(prefix, namespaceUri);
            }
            catch (NamespaceException e) {
            }
            catch (RepositoryException e) {
                throw new RepositorySourceException(this.sourceName, (Throwable)e);
            }
        }
        return prefix;
    }

    public Set<String> getRegisteredNamespaceUris() {
        try {
            return Collections.unmodifiableSet((Object[])this.jcrRegistry.getURIs());
        }
        catch (RepositoryException e) {
            throw new RepositorySourceException(this.sourceName, (Throwable)e);
        }
    }

    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        try {
            this.jcrRegistry.getPrefix(namespaceUri);
            return true;
        }
        catch (NamespaceException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new RepositorySourceException(this.sourceName, (Throwable)e);
        }
    }

    public String register(String prefix, String namespaceUri) {
        throw new UnsupportedOperationException();
    }

    public boolean unregister(String namespaceUri) {
        throw new UnsupportedOperationException();
    }
}

