/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jcr;

import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.jcr.JcrRepositorySource;
import org.modeshape.connector.jcr.JcrRequestProcessor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.Request;

public class JcrRepositoryConnection
implements RepositoryConnection {
    private final JcrRepositorySource source;
    private final Repository repository;
    private final Credentials credentials;

    public JcrRepositoryConnection(JcrRepositorySource source, Repository repository, Credentials credentials) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
        this.credentials = credentials;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        RepositoryContext repositoryContext;
        Logger logger = context.getLogger(this.getClass());
        Stopwatch sw = null;
        if (logger.isTraceEnabled()) {
            sw = new Stopwatch();
            sw.start();
        }
        Observer observer = (repositoryContext = this.source.getRepositoryContext()) != null ? repositoryContext.getObserver() : null;
        JcrRequestProcessor processor = new JcrRequestProcessor(this.source.getName(), context, this.repository, observer, this.credentials, this.source.getDefaultCachePolicy());
        boolean commit = true;
        try {
            processor.process(request);
            if (request.hasError() && !request.isReadOnly()) {
                commit = false;
            }
        }
        catch (Throwable error) {
            commit = false;
        }
        finally {
            try {
                if (commit) {
                    processor.commit();
                } else {
                    processor.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError() && !request.isFrozen()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            finally {
                try {
                    processor.close();
                }
                finally {
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                }
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace("JcrRepositoryConnection.execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

