/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.meta.jdbc.JdbcMetadataCollector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataI18n;
import org.modeshape.connector.meta.jdbc.JdbcMetadataRepository;
import org.modeshape.connector.meta.jdbc.MetadataCollector;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.AbstractPathRepositorySource;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositoryConnection;
import org.modeshape.graph.connector.path.PathRepositorySource;

@ThreadSafe
public class JdbcMetadataSource
extends AbstractPathRepositorySource
implements ObjectFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JdbcMetadataSource.class);
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String DATA_SOURCE_JNDI_NAME = "dataSourceJndiName";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String URL = "url";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String DRIVER_CLASSLOADER_NAME = "driverClassloaderName";
    protected static final String MAXIMUM_CONNECTIONS_IN_POOL = "maximumConnectionsInPool";
    protected static final String MINIMUM_CONNECTIONS_IN_POOL = "minimumConnectionsInPool";
    protected static final String MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS = "maximumConnectionIdleTimeInSeconds";
    protected static final String MAXIMUM_SIZE_OF_STATEMENT_CACHE = "maximumSizeOfStatementCache";
    protected static final String NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED = "numberOfConnectionsToBeAcquiredAsNeeded";
    protected static final String IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS = "idleTimeInSecondsBeforeTestingConnections";
    protected static final String CACHE_TIME_TO_LIVE_IN_MILLISECONDS = "cacheTimeToLiveInMilliseconds";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String DEFAULT_CATALOG_NAME = "defaultCatalogName";
    protected static final String DEFAULT_SCHEMA_NAME = "defaultSchemaName";
    protected static final String METADATA_COLLECTOR_CLASS_NAME = "metadataCollectorClassName";
    protected static final boolean SUPPORTS_EVENTS = false;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = true;
    protected static final boolean SUPPORTS_REFERENCES = false;
    public static final boolean SUPPORTS_UPDATES = false;
    public static final boolean SUPPORTS_CREATING_WORKSPACES = false;
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    public static final String DEFAULT_NAME_OF_DEFAULT_CATALOG = "default";
    public static final String DEFAULT_NAME_OF_DEFAULT_SCHEMA = "default";
    private static final int DEFAULT_MAXIMUM_CONNECTIONS_IN_POOL = 5;
    private static final int DEFAULT_MINIMUM_CONNECTIONS_IN_POOL = 0;
    private static final int DEFAULT_MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS = 600;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_STATEMENTS_TO_CACHE = 100;
    private static final int DEFAULT_NUMBER_OF_CONNECTIONS_TO_ACQUIRE_AS_NEEDED = 1;
    private static final int DEFAULT_IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS = 180;
    private static final MetadataCollector DEFAULT_METADATA_COLLECTOR = new JdbcMetadataCollector();
    private volatile String dataSourceJndiName;
    private volatile String username;
    private volatile String password;
    private volatile String url;
    private volatile String driverClassName;
    private volatile String driverClassloaderName;
    private volatile int maximumConnectionsInPool = 5;
    private volatile int minimumConnectionsInPool = 0;
    private volatile int maximumConnectionIdleTimeInSeconds = 600;
    private volatile int maximumSizeOfStatementCache = 100;
    private volatile int numberOfConnectionsToAcquireAsNeeded = 1;
    private volatile int idleTimeInSecondsBeforeTestingConnections = 180;
    private volatile String defaultWorkspace = "default";
    private volatile String defaultCatalogName = "default";
    private volatile String defaultSchemaName = "default";
    private volatile String metadataCollectorClassName = DEFAULT_METADATA_COLLECTOR.getClass().getName();
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, false, false, false, false);
    private transient DataSource dataSource;
    private transient JdbcMetadataRepository repository;
    private transient MetadataCollector metadataCollector = DEFAULT_METADATA_COLLECTOR;

    final JdbcMetadataRepository repository() {
        return this.repository;
    }

    public void close() {
        if (this.dataSource instanceof ComboPooledDataSource) {
            ((ComboPooledDataSource)this.dataSource).close();
        }
    }

    DataSource getDataSource() {
        if (this.dataSource == null) {
            this.loadDataSource();
        }
        return this.dataSource;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    private synchronized void loadDataSource() throws RepositorySourceException {
        InitialContext context;
        if (this.dataSource == null && this.dataSourceJndiName != null) {
            try {
                context = new InitialContext();
                this.dataSource = (DataSource)context.lookup(this.dataSourceJndiName);
            }
            catch (Throwable t) {
                LOGGER.error(t, JdbcMetadataI18n.errorFindingDataSourceInJndi, new Object[]{this.name, this.dataSourceJndiName});
            }
        }
        if (this.dataSource == null) {
            if (this.repositoryContext != null && this.driverClassloaderName != null) {
                try {
                    context = this.repositoryContext.getExecutionContext();
                    ClassLoader loader = context.getClassLoader(new String[]{this.driverClassloaderName});
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
                catch (Throwable t) {
                    I18n msg = JdbcMetadataI18n.errorSettingContextClassLoader;
                    LOGGER.error(t, msg, new Object[]{this.name, this.driverClassloaderName});
                }
            }
            if (this.driverClassName == null || this.url == null) {
                throw new RepositorySourceException(JdbcMetadataI18n.driverClassNameAndUrlAreRequired.text(new Object[]{this.driverClassName, this.url}));
            }
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            try {
                cpds.setDriverClass(this.driverClassName);
                cpds.setJdbcUrl(this.url);
                cpds.setUser(this.username);
                cpds.setPassword(this.password);
                cpds.setMaxStatements(this.maximumSizeOfStatementCache);
                cpds.setAcquireRetryAttempts(this.retryLimit);
                cpds.setMaxIdleTime(this.maximumConnectionIdleTimeInSeconds);
                cpds.setMinPoolSize(this.minimumConnectionsInPool);
                cpds.setMaxPoolSize(this.maximumConnectionsInPool);
                cpds.setAcquireIncrement(this.numberOfConnectionsToAcquireAsNeeded);
                cpds.setIdleConnectionTestPeriod(this.idleTimeInSecondsBeforeTestingConnections);
            }
            catch (PropertyVetoException pve) {
                throw new IllegalStateException(JdbcMetadataI18n.couldNotSetDriverProperties.text(new Object[0]), pve);
            }
            this.dataSource = cpds;
        }
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new RepositorySourceException(JdbcMetadataI18n.repositorySourceMustHaveName.text(new Object[0]));
        }
        if (this.repository == null) {
            this.repository = new JdbcMetadataRepository(this);
        }
        return new PathRepositoryConnection((PathRepositorySource)this, (PathRepository)this.repository);
    }

    public Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid().toString()));
        ref.add(new StringRefAddr(DATA_SOURCE_JNDI_NAME, this.getDataSourceJndiName()));
        ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        ref.add(new StringRefAddr(URL, this.getUrl()));
        ref.add(new StringRefAddr(DRIVER_CLASS_NAME, this.getDriverClassName()));
        ref.add(new StringRefAddr(DRIVER_CLASSLOADER_NAME, this.getDriverClassloaderName()));
        ref.add(new StringRefAddr(MAXIMUM_CONNECTIONS_IN_POOL, Integer.toString(this.getMaximumConnectionsInPool())));
        ref.add(new StringRefAddr(MINIMUM_CONNECTIONS_IN_POOL, Integer.toString(this.getMinimumConnectionsInPool())));
        ref.add(new StringRefAddr(MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS, Integer.toString(this.getMaximumConnectionIdleTimeInSeconds())));
        ref.add(new StringRefAddr(MAXIMUM_SIZE_OF_STATEMENT_CACHE, Integer.toString(this.getMaximumSizeOfStatementCache())));
        ref.add(new StringRefAddr(NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED, Integer.toString(this.getNumberOfConnectionsToAcquireAsNeeded())));
        ref.add(new StringRefAddr(IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS, Integer.toString(this.getIdleTimeInSecondsBeforeTestingConnections())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(DEFAULT_CATALOG_NAME, this.getDefaultCatalogName()));
        ref.add(new StringRefAddr(DEFAULT_SCHEMA_NAME, this.getDefaultSchemaName()));
        ref.add(new StringRefAddr(METADATA_COLLECTOR_CLASS_NAME, this.getMetadataCollectorClassName()));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Map values = this.valuesFrom((Reference)obj);
        String sourceName = (String)values.get(SOURCE_NAME);
        String rootNodeUuid = (String)values.get(ROOT_NODE_UUID);
        String dataSourceJndiName = (String)values.get(DATA_SOURCE_JNDI_NAME);
        String username = (String)values.get(USERNAME);
        String password = (String)values.get(PASSWORD);
        String url = (String)values.get(URL);
        String driverClassName = (String)values.get(DRIVER_CLASS_NAME);
        String driverClassloaderName = (String)values.get(DRIVER_CLASSLOADER_NAME);
        String maxConnectionsInPool = (String)values.get(MAXIMUM_CONNECTIONS_IN_POOL);
        String minConnectionsInPool = (String)values.get(MINIMUM_CONNECTIONS_IN_POOL);
        String maxConnectionIdleTimeInSec = (String)values.get(MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS);
        String maxSizeOfStatementCache = (String)values.get(MAXIMUM_SIZE_OF_STATEMENT_CACHE);
        String acquisitionIncrement = (String)values.get(NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED);
        String idleTimeInSeconds = (String)values.get(IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS);
        String retryLimit = (String)values.get(RETRY_LIMIT);
        String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
        String defaultCatalogName = (String)values.get(DEFAULT_CATALOG_NAME);
        String defaultSchemaName = (String)values.get(DEFAULT_SCHEMA_NAME);
        String metadataCollectorClassName = (String)values.get(METADATA_COLLECTOR_CLASS_NAME);
        JdbcMetadataSource source = new JdbcMetadataSource();
        if (sourceName != null) {
            source.setName(sourceName);
        }
        if (rootNodeUuid != null) {
            source.setRootNodeUuid(rootNodeUuid);
        }
        if (dataSourceJndiName != null) {
            source.setDataSourceJndiName(dataSourceJndiName);
        }
        if (username != null) {
            source.setUsername(username);
        }
        if (password != null) {
            source.setPassword(password);
        }
        if (url != null) {
            source.setUrl(url);
        }
        if (driverClassName != null) {
            source.setDriverClassName(driverClassName);
        }
        if (driverClassloaderName != null) {
            source.setDriverClassloaderName(driverClassloaderName);
        }
        if (maxConnectionsInPool != null) {
            source.setMaximumConnectionsInPool(Integer.parseInt(maxConnectionsInPool));
        }
        if (minConnectionsInPool != null) {
            source.setMinimumConnectionsInPool(Integer.parseInt(minConnectionsInPool));
        }
        if (maxConnectionIdleTimeInSec != null) {
            source.setMaximumConnectionIdleTimeInSeconds(Integer.parseInt(maxConnectionIdleTimeInSec));
        }
        if (maxSizeOfStatementCache != null) {
            source.setMaximumSizeOfStatementCache(Integer.parseInt(maxSizeOfStatementCache));
        }
        if (acquisitionIncrement != null) {
            source.setNumberOfConnectionsToAcquireAsNeeded(Integer.parseInt(acquisitionIncrement));
        }
        if (idleTimeInSeconds != null) {
            source.setIdleTimeInSecondsBeforeTestingConnections(Integer.parseInt(idleTimeInSeconds));
        }
        if (retryLimit != null) {
            source.setRetryLimit(Integer.parseInt(retryLimit));
        }
        if (defaultWorkspace != null) {
            source.setDefaultWorkspaceName(defaultWorkspace);
        }
        if (defaultCatalogName != null) {
            source.setDefaultCatalogName(defaultCatalogName);
        }
        if (defaultSchemaName != null) {
            source.setDefaultCatalogName(defaultSchemaName);
        }
        if (metadataCollectorClassName != null) {
            source.setMetadataCollectorClassName(metadataCollectorClassName);
        }
        return source;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        if (dataSourceJndiName != null && dataSourceJndiName.trim().length() == 0) {
            dataSourceJndiName = null;
        }
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        if (driverClassName != null && driverClassName.trim().length() == 0) {
            driverClassName = null;
        }
        this.driverClassName = driverClassName;
    }

    public String getDriverClassloaderName() {
        return this.driverClassloaderName;
    }

    public synchronized void setDriverClassloaderName(String driverClassloaderName) {
        if (driverClassloaderName != null && driverClassloaderName.trim().length() == 0) {
            driverClassloaderName = null;
        }
        this.driverClassloaderName = driverClassloaderName;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        if (url != null && url.trim().length() == 0) {
            url = null;
        }
        this.url = url;
    }

    public int getMaximumConnectionsInPool() {
        return this.maximumConnectionsInPool;
    }

    public synchronized void setMaximumConnectionsInPool(int maximumConnectionsInPool) {
        if (maximumConnectionsInPool < 0) {
            maximumConnectionsInPool = 5;
        }
        this.maximumConnectionsInPool = maximumConnectionsInPool;
    }

    public int getMinimumConnectionsInPool() {
        return this.minimumConnectionsInPool;
    }

    public synchronized void setMinimumConnectionsInPool(int minimumConnectionsInPool) {
        if (minimumConnectionsInPool < 0) {
            minimumConnectionsInPool = 0;
        }
        this.minimumConnectionsInPool = minimumConnectionsInPool;
    }

    public int getMaximumConnectionIdleTimeInSeconds() {
        return this.maximumConnectionIdleTimeInSeconds;
    }

    public synchronized void setMaximumConnectionIdleTimeInSeconds(int maximumConnectionIdleTimeInSeconds) {
        if (maximumConnectionIdleTimeInSeconds < 0) {
            maximumConnectionIdleTimeInSeconds = 600;
        }
        this.maximumConnectionIdleTimeInSeconds = maximumConnectionIdleTimeInSeconds;
    }

    public int getMaximumSizeOfStatementCache() {
        return this.maximumSizeOfStatementCache;
    }

    public synchronized void setMaximumSizeOfStatementCache(int maximumSizeOfStatementCache) {
        if (maximumSizeOfStatementCache < 0) {
            maximumSizeOfStatementCache = 100;
        }
        this.maximumSizeOfStatementCache = maximumSizeOfStatementCache;
    }

    public int getNumberOfConnectionsToAcquireAsNeeded() {
        return this.numberOfConnectionsToAcquireAsNeeded;
    }

    public synchronized void setNumberOfConnectionsToAcquireAsNeeded(int numberOfConnectionsToAcquireAsNeeded) {
        if (numberOfConnectionsToAcquireAsNeeded < 0) {
            numberOfConnectionsToAcquireAsNeeded = 1;
        }
        this.numberOfConnectionsToAcquireAsNeeded = numberOfConnectionsToAcquireAsNeeded;
    }

    public int getIdleTimeInSecondsBeforeTestingConnections() {
        return this.idleTimeInSecondsBeforeTestingConnections;
    }

    public synchronized void setIdleTimeInSecondsBeforeTestingConnections(int idleTimeInSecondsBeforeTestingConnections) {
        if (idleTimeInSecondsBeforeTestingConnections < 0) {
            idleTimeInSecondsBeforeTestingConnections = 180;
        }
        this.idleTimeInSecondsBeforeTestingConnections = idleTimeInSecondsBeforeTestingConnections;
    }

    synchronized void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspace = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : "default";
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = defaultCatalogName == null ? "default" : defaultCatalogName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName == null ? "default" : defaultSchemaName;
    }

    public String getMetadataCollectorClassName() {
        return this.metadataCollectorClassName;
    }

    public synchronized void setMetadataCollectorClassName(String metadataCollectorClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (metadataCollectorClassName == null) {
            this.metadataCollectorClassName = DEFAULT_METADATA_COLLECTOR.getClass().getName();
            this.metadataCollector = DEFAULT_METADATA_COLLECTOR;
        } else {
            Class<?> newCollectorClass = Class.forName(metadataCollectorClassName);
            this.metadataCollector = (MetadataCollector)newCollectorClass.newInstance();
            this.metadataCollectorClassName = metadataCollectorClassName;
        }
    }

    public synchronized MetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    public void setUpdatesAllowed(boolean updatesAllowed) {
        if (!updatesAllowed) {
            throw new RepositorySourceException(JdbcMetadataI18n.sourceIsReadOnly.text(new Object[]{this.name}));
        }
    }
}

