/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;

public class TestEnvironment {
    static Properties propertiesFor(Object testCase) {
        Properties properties = new Properties();
        ClassLoader loader = testCase instanceof Class ? ((Class)testCase).getClassLoader() : testCase.getClass().getClassLoader();
        try {
            properties.load(loader.getResourceAsStream("database.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public static JdbcMetadataSource configureJdbcMetadataSource(String sourceName, Object testCase) throws Exception {
        Properties properties = TestEnvironment.propertiesFor(testCase);
        JdbcMetadataSource source = new JdbcMetadataSource();
        source.setName(sourceName);
        source.setDriverClassName(properties.getProperty("jpaSource.driverClassName"));
        source.setUsername(properties.getProperty("jpaSource.username"));
        source.setPassword(properties.getProperty("jpaSource.password"));
        source.setUrl(properties.getProperty("jpaSource.url"));
        String value = properties.getProperty("jpaSource.maximumConnectionsInPool");
        if (TestEnvironment.isValue(value)) {
            source.setMaximumConnectionsInPool(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.minimumConnectionsInPool"))) {
            source.setMinimumConnectionsInPool(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.maximumSizeOfStatementCache"))) {
            source.setMaximumSizeOfStatementCache(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.maximumConnectionIdleTimeInSeconds"))) {
            source.setMaximumConnectionIdleTimeInSeconds(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.defaultWorkspaceName"))) {
            source.setDefaultWorkspaceName(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.numberOfConnectionsToAcquireAsNeeded"))) {
            source.setNumberOfConnectionsToAcquireAsNeeded(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.retryLimit"))) {
            source.setRetryLimit(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.rootNodeUuid"))) {
            source.setRootNodeUuidObject(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("metadata.collectorClassName"))) {
            source.setMetadataCollectorClassName(value);
        }
        return source;
    }

    protected static boolean isValue(String value) {
        return value != null && value.trim().length() != 0;
    }

    protected static String[] splitValues(String value) {
        String[] results = value.split(", ");
        for (int i = 0; i != results.length; ++i) {
            results[i] = results[i].trim();
            results[i] = results[i].replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "").trim();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(DataSource dataSource, String fileName, Object testCase) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        InputStream is = null;
        BufferedReader reader = null;
        try {
            String line;
            Properties properties = TestEnvironment.propertiesFor(testCase);
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            is = TestEnvironment.class.getResourceAsStream("/" + properties.getProperty("database") + "/" + fileName);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("--")) continue;
                stmt.execute(line);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ignore) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
    }
}

