/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;
import org.modeshape.connector.meta.jdbc.TestEnvironment;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceException;

public class JdbcMetadataSourceTest {
    private JdbcMetadataSource source;
    private RepositoryConnection connection;
    @Mock
    private RepositoryContext repositoryContext;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)new ExecutionContext());
        this.source = TestEnvironment.configureJdbcMetadataSource("Test Repository", this);
        this.source.initialize(this.repositoryContext);
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoName() {
        this.source.setName(null);
        this.source.getConnection();
    }

    @Test
    public void shouldCreateConnection() throws Exception {
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowMultipleConnectionsToBeOpenAtTheSameTime() throws Exception {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>();
        try {
            for (int i = 0; i != 10; ++i) {
                RepositoryConnection conn = this.source.getConnection();
                Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                connections.add(conn);
            }
        }
        finally {
            for (RepositoryConnection conn : connections) {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

