/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.JdbcMetadataRepository;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;
import org.modeshape.connector.meta.jdbc.JdbcMetadataWorkspace;
import org.modeshape.connector.meta.jdbc.TestEnvironment;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.request.InvalidWorkspaceException;

public class JdbcMetadataRepositoryTest {
    private JdbcMetadataSource source;
    @Mock
    private RepositoryContext repositoryContext;
    private ExecutionContext context;
    private JdbcMetadataRepository repository;
    private JdbcMetadataWorkspace workspace;
    private JdbcMetadataRepository.JdbcMetadataTransaction txn;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private ValueFactory<Long> longFactory;
    private ValueFactory<String> stringFactory;
    private String loadedCatalogName;
    private String loadedSchemaName;
    private String nullSafeCatalogName;
    private String nullSafeSchemaName;
    private boolean upperCaseIdentifiers;
    private boolean lowerCaseIdentifiers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.longFactory = this.context.getValueFactories().getLongFactory();
        this.stringFactory = this.context.getValueFactories().getStringFactory();
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = TestEnvironment.configureJdbcMetadataSource("Test Repository", this);
        this.source.initialize(this.repositoryContext);
        this.source.getConnection().close();
        this.repository = this.source.repository();
        this.txn = this.repository.startTransaction(this.context, true);
        this.workspace = this.txn.getWorkspace(this.source.getDefaultWorkspaceName(), null);
        Assert.assertThat((Object)this.workspace, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            TestEnvironment.executeDdl(this.source.getDataSource(), "create.ddl", this);
        }
        catch (SQLException se) {
            // empty catch block
        }
        DataSource dataSource = this.source.getDataSource();
        Connection conn = dataSource.getConnection();
        DatabaseMetaData dmd = conn.getMetaData();
        this.upperCaseIdentifiers = dmd.storesUpperCaseIdentifiers();
        this.lowerCaseIdentifiers = dmd.storesLowerCaseIdentifiers();
        ResultSet rs = dmd.getTables(null, null, this.identifier("district"), null);
        try {
            if (!rs.next()) {
                throw new IllegalStateException("Table creation failed -- Can't determine which catalog and schema to use");
            }
            this.loadedCatalogName = rs.getString("TABLE_CAT");
            if (rs.wasNull()) {
                this.loadedCatalogName = null;
            }
            this.loadedSchemaName = rs.getString("TABLE_SCHEM");
            if (rs.wasNull()) {
                this.loadedSchemaName = null;
            }
            if (rs.next()) {
                throw new IllegalStateException("There is more than one table named DISTRICT in this database -- Can't determine which catalog and schema to use");
            }
            this.nullSafeCatalogName = this.loadedCatalogName == null ? this.source.getDefaultCatalogName() : this.loadedCatalogName;
            this.nullSafeSchemaName = this.loadedSchemaName == null ? this.source.getDefaultSchemaName() : this.loadedSchemaName;
        }
        finally {
            rs.close();
            conn.close();
        }
    }

    @After
    public void afterEach() throws Exception {
        TestEnvironment.executeDdl(this.source.getDataSource(), "drop.ddl", this);
        this.source.close();
    }

    @Test
    public void shouldOnlyHaveDefaultWorkspace() {
        Set workspaceNames = this.repository.getWorkspaceNames();
        Assert.assertThat((Object)workspaceNames, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)workspaceNames.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(workspaceNames.iterator().next(), (Matcher)Is.is((Object)this.source.getDefaultWorkspaceName()));
    }

    @Test(expected=InvalidWorkspaceException.class)
    public void shouldNotReturnInvalidWorkspace() {
        JdbcMetadataRepository.JdbcMetadataTransaction txn = this.repository.startTransaction(this.context, true);
        this.workspace = txn.getWorkspace(this.source.getDefaultWorkspaceName() + "Invalid", null);
    }

    @Test
    public void shouldReturnRootNode() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.txn.getNode((PathWorkspace)this.workspace, Location.create((Path)rootPath));
        Map properties = rootNode.getProperties();
        Assert.assertThat((Object)this.pathFor(rootNode), (Matcher)Is.is((Object)rootPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)ModeShapeLexicon.ROOT));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.DATABASE_ROOT));
        Assert.assertThat(properties.get(JdbcMetadataLexicon.DATABASE_PRODUCT_NAME), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat(properties.get(JdbcMetadataLexicon.DATABASE_PRODUCT_VERSION), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat(properties.get(JdbcMetadataLexicon.DATABASE_MAJOR_VERSION), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat(properties.get(JdbcMetadataLexicon.DATABASE_MINOR_VERSION), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)rootNode.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnCatalogNode() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.workspace.getNode(rootPath);
        Path.Segment catalogSegment = (Path.Segment)rootNode.getChildren().get(0);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Map properties = catalogNode.getProperties();
        Assert.assertThat((Object)this.pathFor(catalogNode), (Matcher)Is.is((Object)catalogPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.CATALOG));
        Assert.assertThat((Object)rootNode.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotReturnInvalidCatalogNode() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.workspace.getNode(rootPath);
        Path.Segment catalogSegment = (Path.Segment)rootNode.getChildren().get(0);
        Name invalidCatalogName = (Name)this.nameFactory.create(catalogSegment.getName().getLocalName() + "-InvalidCatalog");
        Path catalogPath = this.pathFactory.createAbsolutePath(new Name[]{invalidCatalogName});
        Assert.assertThat((Object)this.workspace.getNode(catalogPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnSchemaNode() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.workspace.getNode(rootPath);
        Path.Segment catalogSegment = (Path.Segment)rootNode.getChildren().get(0);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Path schemaPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment, schemaSegment});
        PathNode schemaNode = this.workspace.getNode(schemaPath);
        Map properties = schemaNode.getProperties();
        Assert.assertThat((Object)this.pathFor(schemaNode), (Matcher)Is.is((Object)schemaPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.SCHEMA));
        Assert.assertThat((Object)rootNode.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotReturnInvalidSchemaNode() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.workspace.getNode(rootPath);
        Path.Segment catalogSegment = (Path.Segment)rootNode.getChildren().get(0);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Name invalidSchemaName = (Name)this.nameFactory.create(schemaSegment.getName().getLocalName() + "-InvalidSchema");
        Path invalidSchemaPath = this.pathFactory.createAbsolutePath(new Name[]{catalogSegment.getName(), invalidSchemaName});
        Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnTablesNode() {
        Path tablesPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(this.nullSafeCatalogName), this.pathFactory.createSegment(this.nullSafeSchemaName), this.pathFactory.createSegment("tables")});
        PathNode tablesNode = this.workspace.getNode(tablesPath);
        Map properties = tablesNode.getProperties();
        Assert.assertThat((Object)this.pathFor(tablesNode), (Matcher)Is.is((Object)tablesPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.TABLES));
        Assert.assertThat((Object)tablesNode.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotReturnTablesNodeForInvalidSchema() {
        Path.Segment catalogSegment = this.pathFactory.createSegment(this.nullSafeCatalogName);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Name invalidSchemaName = (Name)this.nameFactory.create(schemaSegment.getName().getLocalName() + "-InvalidSchema");
        Path invalidSchemaPath = this.pathFactory.createAbsolutePath(new Name[]{catalogSegment.getName(), invalidSchemaName, (Name)this.nameFactory.create("tables")});
        Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnTableNode() {
        String nullSafeCatalogName = this.loadedCatalogName == null ? this.source.getDefaultCatalogName() : this.loadedCatalogName;
        String nullSafeSchemaName = this.loadedSchemaName == null ? this.source.getDefaultSchemaName() : this.loadedSchemaName;
        Path tablePath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(nullSafeCatalogName), this.pathFactory.createSegment(nullSafeSchemaName), this.pathFactory.createSegment("tables"), this.pathFactory.createSegment(this.identifier("sales"))});
        PathNode tableNode = this.workspace.getNode(tablePath);
        Map properties = tableNode.getProperties();
        Assert.assertThat((Object)this.pathFor(tableNode), (Matcher)Is.is((Object)tablePath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)(properties.size() >= 2 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(properties.size() <= 9 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.TABLE));
        Assert.assertThat((Object)tableNode.getChildren().size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldNotReturnTableNodeForInvalidSchema() {
        Path.Segment catalogSegment = this.pathFactory.createSegment(this.nullSafeCatalogName);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Name invalidSchemaName = (Name)this.nameFactory.create(schemaSegment.getName().getLocalName() + "-InvalidSchema");
        Path invalidSchemaPath = this.pathFactory.createAbsolutePath(new Name[]{catalogSegment.getName(), invalidSchemaName, (Name)this.nameFactory.create("tables"), (Name)this.nameFactory.create(this.identifier("sales"))});
        if (this.ignoresSchemaPatterns()) {
            Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        } else {
            Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void shouldNotReturnInvalidTableNode() {
        String nullSafeCatalogName = this.loadedCatalogName == null ? this.source.getDefaultCatalogName() : this.loadedCatalogName;
        String nullSafeSchemaName = this.loadedSchemaName == null ? this.source.getDefaultSchemaName() : this.loadedSchemaName;
        Path invalidTablePath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(nullSafeCatalogName), this.pathFactory.createSegment(nullSafeSchemaName), this.pathFactory.createSegment("tables"), this.pathFactory.createSegment("NOT_A_VALID_TABLE")});
        Assert.assertThat((Object)this.workspace.getNode(invalidTablePath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnColumnNode() {
        String nullSafeCatalogName = this.loadedCatalogName == null ? this.source.getDefaultCatalogName() : this.loadedCatalogName;
        String nullSafeSchemaName = this.loadedSchemaName == null ? this.source.getDefaultSchemaName() : this.loadedSchemaName;
        Path columnPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(nullSafeCatalogName), this.pathFactory.createSegment(nullSafeSchemaName), this.pathFactory.createSegment("tables"), this.pathFactory.createSegment(this.identifier("sales")), this.pathFactory.createSegment(this.identifier("amount"))});
        PathNode columnNode = this.workspace.getNode(columnPath);
        Map properties = columnNode.getProperties();
        Assert.assertThat((Object)this.pathFor(columnNode), (Matcher)Is.is((Object)columnPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)(properties.size() >= 9 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(properties.size() <= 16 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.COLUMN));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.JDBC_DATA_TYPE)), (Matcher)AnyOf.anyOf((Matcher[])new Matcher[]{Is.is((Object)4L), Is.is((Object)3L)}));
        Assert.assertThat((Object)this.stringFor((Property)properties.get(JdbcMetadataLexicon.TYPE_NAME)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.COLUMN_SIZE)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.DECIMAL_DIGITS)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.RADIX)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.LENGTH)), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.longFor((Property)properties.get(JdbcMetadataLexicon.ORDINAL_POSITION)), (Matcher)Is.is((Object)4L));
    }

    @Test
    public void shouldNotReturnColumnNodeForInvalidSchema() {
        Path.Segment catalogSegment = this.pathFactory.createSegment(this.nullSafeCatalogName);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Name invalidSchemaName = (Name)this.nameFactory.create(schemaSegment.getName().getLocalName() + "-InvalidSchema");
        Path invalidSchemaPath = this.pathFactory.createAbsolutePath(new Name[]{catalogSegment.getName(), invalidSchemaName, (Name)this.nameFactory.create("tables"), (Name)this.nameFactory.create(this.identifier("sales")), (Name)this.nameFactory.create(this.identifier("amount"))});
        if (this.ignoresSchemaPatterns()) {
            Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        } else {
            Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void shouldNotReturnColumnNodeForInvalidTable() {
        Path invalidTablePath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(this.nullSafeCatalogName), this.pathFactory.createSegment(this.nullSafeSchemaName), this.pathFactory.createSegment("tables"), this.pathFactory.createSegment("INVALID_TABLE_NAME"), this.pathFactory.createSegment(this.identifier("id"))});
        Assert.assertThat((Object)this.workspace.getNode(invalidTablePath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotReturnInvalidColumnNode() {
        Path invalidColumnPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(this.nullSafeCatalogName), this.pathFactory.createSegment(this.nullSafeSchemaName), this.pathFactory.createSegment("tables"), this.pathFactory.createSegment(this.identifier("sales")), this.pathFactory.createSegment("INVALID_COLUMN_NAME")});
        Assert.assertThat((Object)this.workspace.getNode(invalidColumnPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnProceduresNode() {
        Path proceduresPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{this.pathFactory.createSegment(this.nullSafeCatalogName), this.pathFactory.createSegment(this.nullSafeSchemaName), this.pathFactory.createSegment("procedures")});
        PathNode proceduresNode = this.workspace.getNode(proceduresPath);
        Map properties = proceduresNode.getProperties();
        Assert.assertThat((Object)this.pathFor(proceduresNode), (Matcher)Is.is((Object)proceduresPath));
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.PRIMARY_TYPE)), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        Assert.assertThat((Object)this.nameFor((Property)properties.get(JcrLexicon.MIXIN_TYPES)), (Matcher)Is.is((Object)JdbcMetadataLexicon.PROCEDURES));
    }

    @Test
    public void shouldNotReturnProceduresNodeForInvalidSchema() {
        Path rootPath = this.pathFactory.createRootPath();
        PathNode rootNode = this.workspace.getNode(rootPath);
        Path.Segment catalogSegment = (Path.Segment)rootNode.getChildren().get(0);
        Path catalogPath = this.pathFactory.createAbsolutePath(new Path.Segment[]{catalogSegment});
        PathNode catalogNode = this.workspace.getNode(catalogPath);
        Path.Segment schemaSegment = (Path.Segment)catalogNode.getChildren().get(0);
        Name invalidSchemaName = (Name)this.nameFactory.create(schemaSegment.getName().getLocalName() + "-InvalidSchema");
        Path invalidSchemaPath = this.pathFactory.createAbsolutePath(new Name[]{catalogSegment.getName(), invalidSchemaName, (Name)this.nameFactory.create("procedures")});
        Assert.assertThat((Object)this.workspace.getNode(invalidSchemaPath), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    protected boolean ignoresSchemaPatterns() {
        return this.source.getDriverClassName().toLowerCase().contains("mysql");
    }

    private Path pathFor(PathNode node) {
        if (node == null) {
            return null;
        }
        if (node.getParent() == null) {
            return this.pathFactory.createRootPath();
        }
        return this.pathFactory.create(node.getParent(), new Path.Segment[]{node.getName()});
    }

    private Name nameFor(Property property) {
        if (property == null) {
            return null;
        }
        if (property.isEmpty()) {
            return null;
        }
        return (Name)this.nameFactory.create(property.getFirstValue());
    }

    private Long longFor(Property property) {
        if (property == null) {
            return null;
        }
        if (property.isEmpty()) {
            return null;
        }
        return (Long)this.longFactory.create(property.getFirstValue());
    }

    private String stringFor(Property property) {
        if (property == null) {
            return null;
        }
        if (property.isEmpty()) {
            return null;
        }
        return (String)this.stringFactory.create(property.getFirstValue());
    }

    private String identifier(String rawIdentifier) {
        if (this.upperCaseIdentifiers) {
            return rawIdentifier.toUpperCase();
        }
        if (this.lowerCaseIdentifiers) {
            return rawIdentifier.toLowerCase();
        }
        return rawIdentifier;
    }
}

