/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.InstantiationException;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.repackage.cglib.reflect.FastClass;

public class InstantiationOptimizerAdapter
implements ReflectionOptimizer.InstantiationOptimizer,
Serializable {
    private FastClass fastClass;

    public InstantiationOptimizerAdapter(FastClass fastClass) {
        this.fastClass = fastClass;
    }

    public Object newInstance() {
        try {
            return this.fastClass.newInstance();
        }
        catch (Throwable t) {
            throw new InstantiationException("Could not instantiate entity with CGLIB optimizer: ", this.fastClass.getJavaClass(), t);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.fastClass.getJavaClass());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class beanClass = (Class)in.readObject();
        this.fastClass = FastClass.create((Class)beanClass);
    }
}

