/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.hql.classic.FromPathExpressionParser;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.hql.classic.PathExpressionParser;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.persister.entity.Queryable;

public class FromParser
implements Parser {
    private final PathExpressionParser peParser = new FromPathExpressionParser();
    private String entityName;
    private String alias;
    private boolean afterIn;
    private boolean afterAs;
    private boolean afterClass;
    private boolean expectingJoin;
    private boolean expectingIn;
    private boolean expectingAs;
    private boolean afterJoinType;
    private int joinType;
    private boolean afterFetch;
    private static final int NONE = -666;
    private static final Map JOIN_TYPES = new HashMap();

    public void token(String token, QueryTranslatorImpl q) throws QueryException {
        String lcToken = token.toLowerCase();
        if (lcToken.equals(",")) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: ,");
            }
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (lcToken.equals("join")) {
            if (!this.afterJoinType) {
                if (!(this.expectingJoin | this.expectingAs)) {
                    throw new QueryException("unexpected token: join");
                }
                this.joinType = 0;
                this.expectingJoin = false;
                this.expectingAs = false;
            } else {
                this.afterJoinType = false;
            }
        } else if (lcToken.equals("fetch")) {
            if (q.isShallowQuery()) {
                throw new QueryException("fetch may not be used with scroll() or iterate()");
            }
            if (this.joinType == -666) {
                throw new QueryException("unexpected token: fetch");
            }
            if (this.joinType == 4 || this.joinType == 2) {
                throw new QueryException("fetch may only be used with inner join or left outer join");
            }
            this.afterFetch = true;
        } else if (lcToken.equals("outer")) {
            if (!this.afterJoinType || this.joinType != 1 && this.joinType != 2) {
                throw new QueryException("unexpected token: outer");
            }
        } else if (JOIN_TYPES.containsKey(lcToken)) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: " + token);
            }
            this.joinType = (Integer)JOIN_TYPES.get(lcToken);
            this.afterJoinType = true;
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (lcToken.equals("class")) {
            if (!this.afterIn) {
                throw new QueryException("unexpected token: class");
            }
            if (this.joinType != -666) {
                throw new QueryException("outer or full join must be followed by path expression");
            }
            this.afterClass = true;
        } else if (lcToken.equals("in")) {
            if (!this.expectingIn) {
                throw new QueryException("unexpected token: in");
            }
            this.afterIn = true;
            this.expectingIn = false;
        } else if (lcToken.equals("as")) {
            if (!this.expectingAs) {
                throw new QueryException("unexpected token: as");
            }
            this.afterAs = true;
            this.expectingAs = false;
        } else {
            if (this.afterJoinType) {
                throw new QueryException("join expected: " + token);
            }
            if (this.expectingJoin) {
                throw new QueryException("unexpected token: " + token);
            }
            if (this.expectingIn) {
                throw new QueryException("in expected: " + token);
            }
            if (this.afterAs || this.expectingAs) {
                if (this.entityName == null) {
                    throw new QueryException("unexpected: as " + token);
                }
                q.setAliasName(token, this.entityName);
                this.afterAs = false;
                this.expectingJoin = true;
                this.expectingAs = false;
                this.entityName = null;
            } else if (this.afterIn) {
                if (this.alias == null) {
                    throw new QueryException("alias not specified for: " + token);
                }
                if (this.joinType != -666) {
                    throw new QueryException("outer or full join must be followed by path expression");
                }
                if (this.afterClass) {
                    Queryable p = q.getEntityPersisterUsingImports(token);
                    if (p == null) {
                        throw new QueryException("persister not found: " + token);
                    }
                    q.addFromClass(this.alias, p);
                } else {
                    this.peParser.setJoinType(0);
                    this.peParser.setUseThetaStyleJoin(true);
                    ParserHelper.parse(this.peParser, q.unalias(token), ".", q);
                    if (!this.peParser.isCollectionValued()) {
                        throw new QueryException("path expression did not resolve to collection: " + token);
                    }
                    String nm = this.peParser.addFromCollection(q);
                    q.setAliasName(this.alias, nm);
                }
                this.alias = null;
                this.afterIn = false;
                this.afterClass = false;
                this.expectingJoin = true;
            } else {
                Queryable p = q.getEntityPersisterUsingImports(token);
                if (p != null) {
                    if (this.joinType != -666) {
                        throw new QueryException("outer or full join must be followed by path expression");
                    }
                    this.entityName = q.createNameFor(p.getEntityName());
                    q.addFromClass(this.entityName, p);
                    this.expectingAs = true;
                } else if (token.indexOf(46) < 0) {
                    this.alias = token;
                    this.expectingIn = true;
                } else {
                    if (this.joinType != -666) {
                        this.peParser.setJoinType(this.joinType);
                    } else {
                        this.peParser.setJoinType(0);
                    }
                    this.peParser.setUseThetaStyleJoin(q.isSubquery());
                    ParserHelper.parse(this.peParser, q.unalias(token), ".", q);
                    this.entityName = this.peParser.addFromAssociation(q);
                    this.joinType = -666;
                    this.peParser.setJoinType(0);
                    if (this.afterFetch) {
                        this.peParser.fetch(q, this.entityName);
                        this.afterFetch = false;
                    }
                    this.expectingAs = true;
                }
            }
        }
    }

    public void start(QueryTranslatorImpl q) {
        this.entityName = null;
        this.alias = null;
        this.afterIn = false;
        this.afterAs = false;
        this.afterClass = false;
        this.expectingJoin = false;
        this.expectingIn = false;
        this.expectingAs = false;
        this.joinType = -666;
    }

    public void end(QueryTranslatorImpl q) {
    }

    static {
        JOIN_TYPES.put("left", new Integer(1));
        JOIN_TYPES.put("right", new Integer(2));
        JOIN_TYPES.put("full", new Integer(4));
        JOIN_TYPES.put("inner", new Integer(0));
    }
}

