/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PutMapCommand
extends AbstractFlagAffectedCommand
implements WriteCommand {
    public static final byte COMMAND_ID = 9;
    Map<Object, Object> map;
    CacheNotifier notifier;
    long lifespanMillis = -1L;
    long maxIdleTimeMillis = -1L;
    boolean isForwarded = false;

    public PutMapCommand() {
    }

    public PutMapCommand(Map<?, ?> map, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        this.map = map;
        this.notifier = notifier;
        this.lifespanMillis = lifespanMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
        this.flags = flags;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    private MVCCEntry lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            Object key = e.getKey();
            MVCCEntry me = this.lookupMvccEntry(ctx, key);
            if (me == null) continue;
            this.notifier.notifyCacheEntryModified(key, me.getValue(), true, ctx);
            me.setValue(e.getValue());
            me.setLifespan(this.lifespanMillis);
            me.setMaxIdle(this.maxIdleTimeMillis);
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.map, this.lifespanMillis, this.maxIdleTimeMillis, this.isForwarded, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.map = (Map)parameters[0];
        this.lifespanMillis = (Long)parameters[1];
        this.maxIdleTimeMillis = (Long)parameters[2];
        this.isForwarded = (Boolean)parameters[3];
        if (parameters.length > 4) {
            this.flags = (Set)parameters[4];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        if (this.lifespanMillis != that.lifespanMillis) {
            return false;
        }
        if (this.maxIdleTimeMillis != that.maxIdleTimeMillis) {
            return false;
        }
        return !(this.map != null ? !this.map.equals(that.map) : that.map != null);
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (int)(this.lifespanMillis ^ this.lifespanMillis >>> 32);
        result = 31 * result + (int)(this.maxIdleTimeMillis ^ this.maxIdleTimeMillis >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(e.getKey()).append('=').append(e.getValue());
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.flags).append(", lifespanMillis=").append(this.lifespanMillis).append(", maxIdleTimeMillis=").append(this.maxIdleTimeMillis).append(", isForwarded=").append(this.isForwarded).append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public long getLifespanMillis() {
        return this.lifespanMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }
}

