/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.aggregator.association;

import java.io.IOException;
import org.apache.lucene.facet.enhancements.association.AssociationsPayloadIterator;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.index.IndexReader;

public class AssociationIntSumAggregator
implements Aggregator {
    protected final String field;
    protected final int[] sumArray;
    protected final AssociationsPayloadIterator associationsPayloadIterator;

    public AssociationIntSumAggregator(IndexReader reader, int[] sumArray) throws IOException {
        this(CategoryListParams.DEFAULT_TERM.field(), reader, sumArray);
    }

    public AssociationIntSumAggregator(String field, IndexReader reader, int[] sumArray) throws IOException {
        this.field = field;
        this.associationsPayloadIterator = new AssociationsPayloadIterator(reader, field);
        this.sumArray = sumArray;
    }

    public void aggregate(int ordinal) {
        long association = this.associationsPayloadIterator.getAssociation(ordinal);
        if (association != Integer.MIN_VALUE) {
            int n = ordinal;
            this.sumArray[n] = (int)((long)this.sumArray[n] + association);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AssociationIntSumAggregator that = (AssociationIntSumAggregator)obj;
        return that.field.equals(this.field) && that.sumArray == this.sumArray;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public void setNextDoc(int docid, float score) throws IOException {
        this.associationsPayloadIterator.setNextDoc(docid);
    }
}

