/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;

public class ArrayBridge
implements FieldBridge {
    private final FieldBridge bridge;

    public ArrayBridge(FieldBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            this.indexNotNullArray(name, value, document, luceneOptions);
        }
    }

    void indexNotNullArray(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Object[] collection;
        for (Object entry : collection = (Object[])value) {
            this.indexEntry(name, entry, document, luceneOptions);
        }
    }

    private void indexEntry(String fieldName, Object entry, Document document, LuceneOptions luceneOptions) {
        this.bridge.set(fieldName, entry, document, luceneOptions);
    }
}

