/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.sandbox.standalone;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.hibernate.search.backend.TransactionContext;

public class InstanceTransactionContext
implements TransactionContext {
    private State transactionState = State.NO_TRANSACTION;
    private final List<Synchronization> synchronizations = new ArrayList<Synchronization>(5);

    public void beginTransaction() {
        if (this.transactionState != State.NO_TRANSACTION) {
            throw new IllegalStateException("Transaction context already started: " + (Object)((Object)this.transactionState));
        }
        this.transactionState = State.IN_TRANSACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.transactionState != State.IN_TRANSACTION) {
            throw new IllegalStateException("Transaction context not in active state: " + (Object)((Object)this.transactionState));
        }
        try {
            for (Synchronization sync : this.synchronizations) {
                sync.beforeCompletion();
            }
            for (Synchronization sync : this.synchronizations) {
                sync.afterCompletion(3);
            }
        }
        finally {
            this.synchronizations.clear();
            this.transactionState = State.TRANSACTION_CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.transactionState != State.IN_TRANSACTION) {
            throw new IllegalStateException("Transaction context not in active state: " + (Object)((Object)this.transactionState));
        }
        try {
            for (Synchronization sync : this.synchronizations) {
                sync.beforeCompletion();
            }
            for (Synchronization sync : this.synchronizations) {
                sync.afterCompletion(4);
            }
        }
        finally {
            this.synchronizations.clear();
            this.transactionState = State.TRANSACTION_CLOSED;
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.transactionState == State.IN_TRANSACTION;
    }

    @Override
    public Object getTransactionIdentifier() {
        return this;
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizations.add(synchronization);
    }

    private static enum State {
        NO_TRANSACTION,
        IN_TRANSACTION,
        TRANSACTION_CLOSED;

    }
}

