/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.jcr.store.DataSourceConfig;

public class DatasourceHelper {
    private static final DataSourceConfig DATA_SOURCE_CONFIG = new DataSourceConfig();
    private static ComboPooledDataSource dataSource;
    private static boolean print;

    public static void setPrint(boolean print) {
        DatasourceHelper.print = print;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(String fileName) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        InputStream istream = null;
        BufferedReader reader = null;
        try {
            String line;
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            String filePath = "/" + DATA_SOURCE_CONFIG.getDatabase() + "/" + fileName;
            istream = DatasourceHelper.class.getResourceAsStream(filePath);
            Assert.assertThat((String)(filePath + " cannot be found"), (Object)istream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            reader = new BufferedReader(new InputStreamReader(istream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("--")) continue;
                if (print) {
                    System.out.println("Executing: " + line);
                }
                stmt.execute(line);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ignore) {}
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public static DataSource getDataSource() {
        if (dataSource == null) {
            dataSource = new ComboPooledDataSource();
            try {
                dataSource.setDriverClass(DATA_SOURCE_CONFIG.getDriverClassName());
                dataSource.setJdbcUrl(DATA_SOURCE_CONFIG.getUrl());
                dataSource.setUser(DATA_SOURCE_CONFIG.getUsername());
                dataSource.setPassword(DATA_SOURCE_CONFIG.getPassword());
                dataSource.setMaxStatements(DATA_SOURCE_CONFIG.getMaximumSizeOfStatementsCache().intValue());
                dataSource.setAcquireRetryAttempts(DATA_SOURCE_CONFIG.getRetryLimit().intValue());
                dataSource.setMaxIdleTime(DATA_SOURCE_CONFIG.getMaximumConnectionIdleTimeInSeconds().intValue());
                dataSource.setAcquireIncrement(DATA_SOURCE_CONFIG.getNumberOfConnectionsToAcquireAsNeeded().intValue());
                dataSource.setMinPoolSize(DATA_SOURCE_CONFIG.getMinimumConnectionsInPool().intValue());
                dataSource.setMaxPoolSize(DATA_SOURCE_CONFIG.getMaximumConnectionsInPool().intValue());
            }
            catch (PropertyVetoException pve) {
                throw new RuntimeException(pve);
            }
        }
        return dataSource;
    }

    public static void bindInJNDI(String name) throws NamingException {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        InitialContext ic = new InitialContext();
        ic.createSubcontext("java:");
        ic.bind("java:/" + name, (Object)dataSource);
    }

    public static void closeDataSource() {
        dataSource.close();
    }

    static {
        print = false;
    }
}

