/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmExtractor;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CHMDocumentInformation {
    private ChmExtractor chmExtractor = null;

    public static CHMDocumentInformation load(InputStream is) throws TikaException, IOException {
        CHMDocumentInformation document = new CHMDocumentInformation();
        document.setChmExtractor(new ChmExtractor(is));
        return document;
    }

    private String getContent() {
        StringBuilder sb = new StringBuilder();
        Iterator<DirectoryListingEntry> it = this.getChmExtractor().getChmDirList().getDirectoryListingEntryList().iterator();
        while (it.hasNext()) {
            try {
                byte[][] tmp;
                DirectoryListingEntry entry = it.next();
                if (!this.isRightEntry(entry) || (tmp = this.getChmExtractor().extractChmEntry(entry)) == null) continue;
                sb.append(this.extract(tmp));
            }
            catch (TikaException e) {}
        }
        return sb.toString();
    }

    private boolean isRightEntry(DirectoryListingEntry entry) {
        return entry.getName().endsWith(".html") || entry.getName().endsWith(".htm");
    }

    private ChmExtractor getChmExtractor() {
        return this.chmExtractor;
    }

    private void setChmExtractor(ChmExtractor chmExtractor) {
        this.chmExtractor = chmExtractor;
    }

    public void getCHMDocInformation(Metadata metadata) throws TikaException, IOException {
        if (this.getChmExtractor() != null) {
            metadata.add("Content-Type", "application/x-chm");
        } else {
            metadata.add("Content-Type", "unknown");
        }
    }

    public String getText() throws TikaException {
        return this.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extract(byte[][] byteObject) {
        StringBuilder wBuf = new StringBuilder();
        ByteArrayInputStream stream = null;
        Metadata metadata = new Metadata();
        HtmlParser htmlParser = new HtmlParser();
        BodyContentHandler handler = new BodyContentHandler(-1);
        ParseContext parser = new ParseContext();
        try {
            for (int i = 0; i < byteObject.length; ++i) {
                stream = new ByteArrayInputStream(byteObject[i]);
                try {
                    htmlParser.parse(stream, (ContentHandler)handler, metadata, parser);
                    continue;
                }
                catch (TikaException e) {
                    wBuf.append(new String(byteObject[i]));
                    continue;
                }
                finally {
                    wBuf.append(handler.toString() + System.getProperty("line.separator"));
                    ((InputStream)stream).close();
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            // empty catch block
        }
        return wBuf.toString();
    }

    public static void main(String[] args) {
    }
}

