/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.ColumnMetadata;
import org.modeshape.connector.meta.jdbc.ColumnRetriever;
import org.modeshape.connector.meta.jdbc.ForeignKeyMetadata;
import org.modeshape.connector.meta.jdbc.ForeignKeyRetriever;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.SchemaRetriever;
import org.modeshape.connector.meta.jdbc.TableMetadata;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.spi.federation.DocumentWriter;

public class TableRetriever
extends AbstractMetadataRetriever {
    private static final Pattern TABLE_PATH_PATTERN = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)/tables/([^/]+)");
    private static final String TABLE_PREFIX = "table";
    private static final Pattern TABLE_ID_PATTERN = Pattern.compile("([^@]+)@([^@]+)@([^@]+)@table@([^@]+)");
    static final Pattern FKS_PATH_PATTERN = Pattern.compile(TABLE_PATH_PATTERN.pattern() + "/foreignKeys");
    private static final String FKS_CONTAINER = "foreignKeys";
    private static final Pattern FKS_ID_PATTERN = Pattern.compile(TABLE_ID_PATTERN.pattern() + "@" + "foreignKeys");

    protected TableRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        String tableId = this.tableIdFrom(id, TABLE_ID_PATTERN);
        if (tableId != null) {
            return this.createDocumentForTable(id, writer, connection, tableId);
        }
        tableId = this.tableIdFrom(id, FKS_ID_PATTERN);
        if (tableId != null) {
            return this.createDocumentForFks(id, writer, connection, tableId);
        }
        return null;
    }

    private Document createDocumentForFks(String id, DocumentWriter writer, Connection connection, String tableId) {
        String schemaId;
        String schema;
        String catalogId;
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.FOREIGN_KEYS);
        String catalog = catalogId = this.catalogIdFrom(id, FKS_ID_PATTERN);
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = (schemaId = this.schemaIdFrom(id, FKS_ID_PATTERN))).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        writer.setParent(TableRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, false));
        List<ForeignKeyMetadata> fks = this.connector.getMetadataCollector().getForeignKeys(connection, catalog, schema, tableId, null);
        for (ForeignKeyMetadata fk : fks) {
            String foreignKeyColumnName = fk.getForeignKeyColumnName();
            String fkId = ForeignKeyRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, foreignKeyColumnName);
            writer.addChild(fkId, foreignKeyColumnName);
        }
        return writer.document();
    }

    private Document createDocumentForTable(String id, DocumentWriter writer, Connection connection, String tableId) {
        String schemaId;
        String schema;
        String catalogId;
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.TABLE);
        String catalog = catalogId = this.catalogIdFrom(id, TABLE_ID_PATTERN);
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = (schemaId = this.schemaIdFrom(id, TABLE_ID_PATTERN))).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        writer.setParent(SchemaRetriever.documentId("databaseRoot", catalogId, schemaId, true, false));
        List<TableMetadata> metadata = this.connector.getMetadataCollector().getTables(connection, catalog, schema, tableId);
        if (!metadata.isEmpty()) {
            TableMetadata tableMetadata = metadata.get(0);
            writer.addProperty(JdbcMetadataLexicon.TABLE_TYPE, (Object)tableMetadata.getType());
            writer.addProperty(JdbcMetadataLexicon.DESCRIPTION, (Object)tableMetadata.getDescription());
            writer.addProperty(JdbcMetadataLexicon.TYPE_CATALOG_NAME, (Object)tableMetadata.getTypeCatalogName());
            writer.addProperty(JdbcMetadataLexicon.TYPE_SCHEMA_NAME, (Object)tableMetadata.getTypeSchemaName());
            writer.addProperty(JdbcMetadataLexicon.TYPE_NAME, (Object)tableMetadata.getTypeName());
            writer.addProperty(JdbcMetadataLexicon.SELF_REFERENCING_COLUMN_NAME, (Object)tableMetadata.getSelfReferencingColumnName());
            writer.addProperty(JdbcMetadataLexicon.REFERENCE_GENERATION_STRATEGY_NAME, (Object)tableMetadata.getReferenceGenerationStrategyName());
        }
        List<ColumnMetadata> columns = this.connector.getMetadataCollector().getColumns(connection, catalog, schema, tableId, null);
        for (ColumnMetadata column : columns) {
            String columnId = ColumnRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, column.getName());
            writer.addChild(columnId, column.getName());
        }
        String foreignKeysId = TableRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, true);
        writer.addChild(foreignKeysId, FKS_CONTAINER);
        return writer.document();
    }

    private String tableIdFrom(String id, Pattern pattern) {
        Matcher matcher = pattern.matcher(id);
        return matcher.matches() ? matcher.group(4) : null;
    }

    private String schemaIdFrom(String id, Pattern pattern) {
        Matcher matcher = pattern.matcher(id);
        return matcher.matches() ? matcher.group(3) : null;
    }

    private String catalogIdFrom(String id, Pattern pattern) {
        Matcher matcher = pattern.matcher(id);
        return matcher.matches() ? matcher.group(2) : null;
    }

    @Override
    protected String idFrom(String path) {
        Matcher tableMatcher = TABLE_PATH_PATTERN.matcher(path);
        if (tableMatcher.matches() && !SchemaRetriever.PROCEDURES_PATH_PATTERN.matcher(path).matches() && !SchemaRetriever.TABLES_PATH_PATTERN.matcher(path).matches()) {
            String tableName = tableMatcher.group(4);
            return TableRetriever.documentId(tableMatcher.group(1), tableMatcher.group(2), tableMatcher.group(3), tableName, false);
        }
        Matcher fksMatcher = FKS_PATH_PATTERN.matcher(path);
        if (fksMatcher.matches()) {
            return TableRetriever.documentId(fksMatcher.group(1), fksMatcher.group(2), fksMatcher.group(3), fksMatcher.group(4), true);
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return TABLE_ID_PATTERN.matcher(id).matches() || FKS_ID_PATTERN.matcher(id).matches();
    }

    static String documentId(String databaseId, String catalogId, String schemaId, String tableId, boolean onlyFks) {
        String baseId = TableRetriever.generateId(databaseId, catalogId, schemaId, TABLE_PREFIX, tableId);
        if (onlyFks) {
            return TableRetriever.generateId(baseId, FKS_CONTAINER);
        }
        return baseId;
    }
}

