/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.jcip.annotations.ThreadSafe;
import org.hibernate.ejb.Ejb3Configuration;

@ThreadSafe
public class EntityManagers {
    private final Ejb3Configuration configuration;
    private final Map<EntityManager, AtomicInteger> referenceCounts = new HashMap<EntityManager, AtomicInteger>();
    private EntityManagerFactory factory;
    private boolean canClose;

    EntityManagers(Ejb3Configuration configuration) {
        this.configuration = configuration;
    }

    public synchronized EntityManager checkout() {
        EntityManager manager;
        if (this.factory == null) {
            this.factory = this.configuration.buildEntityManagerFactory();
            assert (this.referenceCounts.isEmpty());
            this.canClose = false;
        }
        if (this.referenceCounts.containsKey(manager = this.factory.createEntityManager())) {
            this.referenceCounts.get(manager).incrementAndGet();
        } else {
            this.referenceCounts.put(manager, new AtomicInteger(1));
        }
        return manager;
    }

    public synchronized void checkin(EntityManager manager) {
        if (manager == null) {
            return;
        }
        AtomicInteger count = this.referenceCounts.get(manager);
        assert (count != null);
        count.decrementAndGet();
        assert (count.get() >= 0);
        if (count.get() == 0 && this.referenceCounts.remove(manager) != null) {
            manager.close();
        }
        this.closeFactoryIfNoManagersCheckedOut();
    }

    public synchronized void close() {
        this.canClose = true;
        this.closeFactoryIfNoManagersCheckedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeNow() {
        this.canClose = true;
        try {
            for (EntityManager manager : this.referenceCounts.keySet()) {
                manager.close();
            }
            this.referenceCounts.clear();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.factory.close();
                Object var6_7 = null;
                this.factory = null;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.factory = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.factory.close();
            Object var6_5 = null;
            this.factory = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.factory = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFactoryIfNoManagersCheckedOut() {
        if (this.referenceCounts.isEmpty() && this.canClose && this.factory != null) {
            try {
                this.factory.close();
                Object var2_1 = null;
                this.factory = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.factory = null;
                throw throwable;
            }
        }
    }
}

