/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.store.jpa.EntityManagers;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.model.basic.BasicRequestProcessor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.Request;

class BasicJpaConnection
implements RepositoryConnection {
    private final String name;
    private final CachePolicy cachePolicy;
    private final EntityManagers entityManagers;
    private final UUID rootNodeUuid;
    private final String nameOfDefaultWorkspace;
    private final String[] predefinedWorkspaceNames;
    private final boolean creatingWorkspacesAllowed;
    private final long largeValueMinimumSizeInBytes;
    private final boolean compressData;
    private final boolean enforceReferentialIntegrity;
    private final Observer observer;

    public BasicJpaConnection(String sourceName, Observer observer, CachePolicy cachePolicy, EntityManagers entityManagers, UUID rootNodeUuid, String nameOfDefaultWorkspace, String[] predefinedWorkspaceNames, long largeValueMinimumSizeInBytes, boolean creatingWorkspacesAllowed, boolean compressData, boolean enforceReferentialIntegrity) {
        assert (sourceName != null);
        assert (entityManagers != null);
        assert (rootNodeUuid != null);
        this.observer = observer;
        this.name = sourceName;
        this.cachePolicy = cachePolicy;
        this.entityManagers = entityManagers;
        this.rootNodeUuid = rootNodeUuid;
        this.largeValueMinimumSizeInBytes = largeValueMinimumSizeInBytes;
        this.compressData = compressData;
        this.enforceReferentialIntegrity = enforceReferentialIntegrity;
        this.nameOfDefaultWorkspace = nameOfDefaultWorkspace;
        this.predefinedWorkspaceNames = predefinedWorkspaceNames != null ? predefinedWorkspaceNames : new String[]{};
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
    }

    public String getSourceName() {
        return this.name;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.cachePolicy;
    }

    public XAResource getXAResource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(long time, TimeUnit unit) {
        EntityManager entityManager = this.entityManagers.checkout();
        try {
            boolean bl = entityManager != null ? entityManager.isOpen() : false;
            return bl;
        }
        finally {
            this.entityManagers.checkin(entityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        EntityManager entityManager;
        Stopwatch sw;
        Logger logger;
        block39: {
            logger = context.getLogger(this.getClass());
            sw = null;
            if (logger.isTraceEnabled()) {
                sw = new Stopwatch();
                sw.start();
            }
            BasicRequestProcessor processor = null;
            entityManager = null;
            boolean commit = true;
            try {
                entityManager = this.entityManagers.checkout();
                if (entityManager == null) {
                    throw new RepositorySourceException(JpaConnectorI18n.connectionIsNoLongerOpen.text(new Object[]{this.name}));
                }
                processor = new BasicRequestProcessor(this.name, context, this.observer, entityManager, this.rootNodeUuid, this.nameOfDefaultWorkspace, this.predefinedWorkspaceNames, this.largeValueMinimumSizeInBytes, this.creatingWorkspacesAllowed, this.compressData, this.enforceReferentialIntegrity);
                processor.process(request);
                if (request.hasError() && !request.isReadOnly()) {
                    commit = false;
                }
                Object var9_8 = null;
                if (processor == null) break block39;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (processor != null) {
                    try {
                        processor.close();
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_13 = null;
                        try {
                            EntityTransaction txn = entityManager.getTransaction();
                            if (txn != null) {
                                if (commit) {
                                    txn.commit();
                                } else {
                                    txn.rollback();
                                }
                            }
                        }
                        catch (Throwable commitOrRollbackError) {
                            if (commit && !request.hasError()) {
                                request.setError(commitOrRollbackError);
                            }
                            commit = false;
                        }
                        if (commit) {
                            processor.notifyObserverOfChanges();
                        }
                        throw throwable2;
                    }
                    try {
                        EntityTransaction txn = entityManager.getTransaction();
                        if (txn != null) {
                            if (commit) {
                                txn.commit();
                            } else {
                                txn.rollback();
                            }
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        if (commit && !request.hasError()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                }
                try {
                    this.entityManagers.checkin(entityManager);
                    Object var14_26 = null;
                    entityManager = null;
                }
                catch (Throwable throwable3) {
                    Object var14_27 = null;
                    entityManager = null;
                    throw throwable3;
                }
                throw throwable;
            }
            try {
                processor.close();
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    EntityTransaction txn = entityManager.getTransaction();
                    if (txn != null) {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
            try {
                EntityTransaction txn = entityManager.getTransaction();
                if (txn != null) {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
        }
        try {
            this.entityManagers.checkin(entityManager);
            Object var14_24 = null;
            entityManager = null;
        }
        catch (Throwable throwable) {
            Object var14_25 = null;
            entityManager = null;
            throw throwable;
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace(this.getClass().getSimpleName() + ".execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public void close() {
    }
}

