/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.model.basic.ChildEntity;
import org.modeshape.connector.store.jpa.model.basic.ChildId;
import org.modeshape.connector.store.jpa.model.basic.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.basic.LargeValueId;
import org.modeshape.connector.store.jpa.model.basic.NodeId;
import org.modeshape.connector.store.jpa.model.basic.PropertiesEntity;
import org.modeshape.connector.store.jpa.model.basic.ReferenceEntity;
import org.modeshape.connector.store.jpa.model.basic.ReferenceId;
import org.modeshape.connector.store.jpa.model.basic.SubgraphQuery;
import org.modeshape.connector.store.jpa.model.common.NamespaceEntity;
import org.modeshape.connector.store.jpa.model.common.WorkspaceEntity;
import org.modeshape.connector.store.jpa.util.Namespaces;
import org.modeshape.connector.store.jpa.util.RequestProcessorCache;
import org.modeshape.connector.store.jpa.util.Serializer;
import org.modeshape.connector.store.jpa.util.Workspaces;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ReferentialIntegrityException;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class BasicRequestProcessor
extends RequestProcessor {
    protected final EntityManager entities;
    protected final ValueFactory<String> stringFactory;
    protected final PathFactory pathFactory;
    protected final PropertyFactory propertyFactory;
    protected final NameFactory nameFactory;
    protected final UuidFactory uuidFactory;
    protected final Namespaces namespaces;
    protected final Workspaces workspaces;
    protected final UUID rootNodeUuid;
    protected final String rootNodeUuidString;
    protected final String nameOfDefaultWorkspace;
    protected final String[] predefinedWorkspaceNames;
    protected final boolean creatingWorkspacesAllowed;
    protected final Serializer serializer;
    protected final long largeValueMinimumSizeInBytes;
    protected final boolean compressData;
    protected final Logger logger;
    protected final RequestProcessorCache cache;
    protected final boolean enforceReferentialIntegrity;
    private final Set<Long> workspaceIdsWithChangedReferences = new HashSet<Long>();

    public BasicRequestProcessor(String sourceName, ExecutionContext context, Observer observer, EntityManager entityManager, UUID rootNodeUuid, String nameOfDefaultWorkspace, String[] predefinedWorkspaceNames, long largeValueMinimumSizeInBytes, boolean creatingWorkspacesAllowed, boolean compressData, boolean enforceReferentialIntegrity) {
        super(sourceName, context, observer);
        assert (entityManager != null);
        assert (rootNodeUuid != null);
        assert (predefinedWorkspaceNames != null);
        this.entities = entityManager;
        ValueFactories valuesFactory = context.getValueFactories();
        this.stringFactory = valuesFactory.getStringFactory();
        this.pathFactory = valuesFactory.getPathFactory();
        this.propertyFactory = context.getPropertyFactory();
        this.nameFactory = valuesFactory.getNameFactory();
        this.uuidFactory = valuesFactory.getUuidFactory();
        this.namespaces = new Namespaces(entityManager);
        this.workspaces = new Workspaces(entityManager);
        this.rootNodeUuid = rootNodeUuid;
        this.rootNodeUuidString = this.rootNodeUuid.toString();
        this.nameOfDefaultWorkspace = nameOfDefaultWorkspace;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.largeValueMinimumSizeInBytes = largeValueMinimumSizeInBytes;
        this.compressData = compressData;
        this.enforceReferentialIntegrity = enforceReferentialIntegrity;
        this.serializer = new Serializer(context, true);
        this.logger = this.getExecutionContext().getLogger(((Object)((Object)this)).getClass());
        this.cache = new RequestProcessorCache(this.pathFactory);
        this.predefinedWorkspaceNames = predefinedWorkspaceNames;
        this.entities.getTransaction().begin();
    }

    public void process(CreateNodeRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location parentLocation = request.under();
            ActualLocation actual = this.getActualLocation(workspace, parentLocation);
            String parentUuidString = actual.uuid;
            assert (parentUuidString != null);
            String uuidString = null;
            UUID uuid = null;
            for (Property property : request.properties()) {
                if (!property.getName().equals(ModeShapeLexicon.UUID)) continue;
                uuid = (UUID)this.uuidFactory.create(property.getFirstValue());
                uuidString = (String)this.stringFactory.create(property.getFirstValue());
                break;
            }
            if (uuid == null) {
                for (Property property : request.properties()) {
                    if (!property.getName().equals(JcrLexicon.UUID)) continue;
                    uuid = (UUID)this.uuidFactory.create(property.getFirstValue());
                    uuidString = (String)this.stringFactory.create(property.getFirstValue());
                    break;
                }
            }
            switch (request.conflictBehavior()) {
                case DO_NOT_REPLACE: 
                case UPDATE: {
                    ActualLocation existing;
                    if (uuid != null && (existing = this.getActualLocation(workspace, Location.create(uuid))) != null) {
                        if (NodeConflictBehavior.UPDATE.equals((Object)request.conflictBehavior())) {
                            this.createProperties(workspace, uuidString, request.properties());
                        }
                        request.setActualLocationOfNode(existing.location);
                        return;
                    }
                    Name newName = request.named();
                    for (Location childLocation : this.getAllChildren(workspaceId, actual)) {
                        if (!newName.equals(childLocation.getPath().getLastSegment().getName())) continue;
                        if (NodeConflictBehavior.UPDATE.equals((Object)request.conflictBehavior())) {
                            this.createProperties(workspace, uuidString, request.properties());
                        }
                        request.setActualLocationOfNode(childLocation);
                        this.recordChange((ChangeRequest)request);
                        return;
                    }
                    break;
                }
                case REPLACE: {
                    ActualLocation existing;
                    if (uuid == null || (existing = this.getActualLocation(workspace, Location.create(uuid))) == null) break;
                    this.delete((Request)request, existing.location, workspace.getName(), true);
                    break;
                }
            }
            if (uuidString == null) {
                uuidString = UUID.randomUUID().toString();
            }
            assert (uuidString != null);
            this.createProperties(workspace, uuidString, request.properties());
            Name childName = request.named();
            String childNsUri = childName.getNamespaceUri();
            NamespaceEntity ns = this.namespaces.get(childNsUri, true);
            assert (ns != null);
            Path parentPath = actual.location.getPath();
            assert (parentPath != null);
            actualLocation = this.addNewChild((Long)workspaceId, (ActualLocation)actual, (String)uuidString, (Name)childName, (boolean)true).location;
            this.cache.setAllChildren(workspace.getId(), actualLocation.getPath(), new LinkedList<Location>());
        }
        catch (Throwable e) {
            request.setError(e);
            this.logger.trace(e, "Problem " + request, new Object[0]);
            return;
        }
        request.setActualLocationOfNode(actualLocation);
        this.recordChange((ChangeRequest)request);
    }

    protected ActualLocation addNewChild(Long workspaceId, ActualLocation parent, String childUuid, Name childName, boolean allowSameNameChildrenInNewNode) {
        int nextSnsIndex = 1;
        int nextIndexInParent = 0;
        String childNsUri = childName.getNamespaceUri();
        NamespaceEntity ns = this.namespaces.get(childNsUri, true);
        assert (ns != null);
        Path parentPath = null;
        String parentUuid = null;
        ChildEntity parentEntity = null;
        if (parent == null) {
            return new ActualLocation(Location.create((Path)this.pathFactory.createRootPath(), (UUID)UUID.fromString(childUuid)), childUuid, null);
        }
        parentPath = parent.location.getPath();
        parentUuid = parent.uuid;
        parentEntity = parent.childEntity;
        assert (workspaceId != null);
        ChildId id = new ChildId(workspaceId, childUuid);
        ChildEntity entity = null;
        LinkedList<Location> childrenOfParent = this.cache.getAllChildren(workspaceId, parentPath);
        if (parentEntity == null || parentEntity.getAllowsSameNameChildren()) {
            if (childrenOfParent != null) {
                nextIndexInParent = childrenOfParent.size();
                if (nextIndexInParent > 0) {
                    ListIterator<Location> iter = childrenOfParent.listIterator(childrenOfParent.size());
                    while (iter.hasPrevious()) {
                        Location existing = iter.previous();
                        Path.Segment segment = existing.getPath().getLastSegment();
                        if (!segment.getName().equals(childName)) continue;
                        nextSnsIndex = segment.getIndex() + 1;
                        break;
                    }
                }
            } else {
                Integer result;
                String childLocalName = childName.getLocalName();
                Query query = this.entities.createNamedQuery("ChildEntity.findMaximumSnsIndex");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("parentUuid", (Object)parentUuid);
                query.setParameter("ns", (Object)ns.getId());
                query.setParameter("childName", (Object)childLocalName);
                try {
                    result = (Integer)query.getSingleResult();
                    nextSnsIndex = result != null ? result + 1 : 1;
                }
                catch (NoResultException e) {
                    // empty catch block
                }
                query = this.entities.createNamedQuery("ChildEntity.findMaximumChildIndex");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("parentUuid", (Object)parentUuid);
                try {
                    result = (Integer)query.getSingleResult();
                    nextIndexInParent = result != null ? result + 1 : 0;
                }
                catch (NoResultException e) {
                    // empty catch block
                }
            }
            entity = new ChildEntity(id, parentUuid, nextIndexInParent, ns, childName.getLocalName(), nextSnsIndex);
        } else {
            if (childrenOfParent != null) {
                nextIndexInParent = childrenOfParent.size();
            } else {
                Query query = this.entities.createNamedQuery("ChildEntity.findMaximumChildIndex");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("parentUuid", (Object)parentUuid);
                try {
                    Integer result = (Integer)query.getSingleResult();
                    nextIndexInParent = result != null ? result + 1 : 0;
                }
                catch (NoResultException e) {
                    // empty catch block
                }
            }
            entity = new ChildEntity(id, parentUuid, nextIndexInParent, ns, childName.getLocalName(), 1);
        }
        entity.setAllowsSameNameChildren(allowSameNameChildrenInNewNode);
        this.entities.persist((Object)entity);
        Path path = this.pathFactory.create(parentPath, childName, nextSnsIndex);
        Location actualLocation = Location.create((Path)path, (UUID)UUID.fromString(childUuid));
        if (childrenOfParent != null) {
            childrenOfParent.add(actualLocation);
        } else {
            this.cache.setAllChildren(workspaceId, parentPath, null);
        }
        return new ActualLocation(actualLocation, entity.getId().getChildUuidString(), entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ReadNodeRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        try {
            ActualLocation actual;
            Long workspaceId;
            block13: {
                WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
                if (workspace == null) {
                    return;
                }
                workspaceId = workspace.getId();
                assert (workspaceId != null);
                Location location = request.at();
                actual = this.getActualLocation(workspace, location);
                String parentUuidString = actual.uuid;
                actualLocation = actual.location;
                request.addProperty(this.propertyFactory.create(ModeShapeLexicon.UUID, new Object[]{UUID.fromString(parentUuidString)}));
                Query query = this.entities.createNamedQuery("PropertiesEntity.findByUuid");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("uuid", (Object)parentUuidString);
                try {
                    PropertiesEntity entity = (PropertiesEntity)query.getSingleResult();
                    boolean compressed = entity.isCompressed();
                    LinkedList<Property> properties = new LinkedList<Property>();
                    byte[] data = entity.getData();
                    if (data == null) break block13;
                    LargeValueSerializer largeValues = new LargeValueSerializer(entity);
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                    ObjectInputStream ois = new ObjectInputStream(is);
                    try {
                        this.serializer.deserializeAllProperties(ois, properties, largeValues);
                        for (Property property : properties) {
                            request.addProperty(property);
                        }
                    }
                    finally {
                        ois.close();
                    }
                }
                catch (NoResultException e) {
                    // empty catch block
                }
            }
            for (Location childLocation : this.getAllChildren(workspaceId, actual)) {
                request.addChild(childLocation);
            }
        }
        catch (NoResultException e) {
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location location = request.of();
            ActualLocation actual = this.getActualLocation(workspace, location);
            actualLocation = actual.location;
            for (Location childLocation : this.getAllChildren(workspaceId, actual)) {
                request.addChild(childLocation);
            }
        }
        catch (NoResultException e) {
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    protected LinkedList<Location> getAllChildren(Long workspaceId, ActualLocation parent) {
        assert (parent != null);
        Path parentPath = parent.location.getPath();
        assert (parentPath != null);
        LinkedList<Location> cachedChildren = this.cache.getAllChildren(workspaceId, parentPath);
        if (cachedChildren != null) {
            return cachedChildren;
        }
        Query query = this.entities.createNamedQuery("ChildEntity.findAllUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)parent.uuid);
        LinkedList<Location> childLocations = new LinkedList<Location>();
        List children = query.getResultList();
        for (ChildEntity child : children) {
            String namespaceUri = child.getChildNamespace().getUri();
            String localName = child.getChildName();
            Name childName = this.nameFactory.create(namespaceUri, localName);
            int sns = child.getSameNameSiblingIndex();
            Path childPath = this.pathFactory.create(parentPath, childName, sns);
            String childUuidString = child.getId().getChildUuidString();
            Location childLocation = Location.create((Path)childPath, (UUID)UUID.fromString(childUuidString));
            childLocations.add(childLocation);
        }
        this.cache.setAllChildren(workspaceId, parentPath, childLocations);
        return childLocations;
    }

    public void process(ReadBlockOfChildrenRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        int startingIndex = request.startingAtIndex();
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location parentLocation = request.of();
            ActualLocation actualParent = this.getActualLocation(workspace, parentLocation);
            actualLocation = actualParent.location;
            Path parentPath = actualParent.location.getPath();
            assert (parentPath != null);
            LinkedList<Location> cachedChildren = this.cache.getAllChildren(workspaceId, parentPath);
            if (cachedChildren != null) {
                if (startingIndex < cachedChildren.size()) {
                    ListIterator<Location> iter = cachedChildren.listIterator(startingIndex);
                    for (int i = 0; i != request.count() && iter.hasNext(); ++i) {
                        Location child = iter.next();
                        request.addChild(child);
                    }
                }
            } else {
                Query query = this.entities.createNamedQuery("ChildEntity.findRangeUnderParent");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("parentUuidString", (Object)actualParent.uuid);
                query.setParameter("firstIndex", (Object)startingIndex);
                query.setParameter("afterIndex", (Object)(startingIndex + request.count()));
                List children = query.getResultList();
                for (ChildEntity child : children) {
                    String namespaceUri = child.getChildNamespace().getUri();
                    String localName = child.getChildName();
                    Name childName = this.nameFactory.create(namespaceUri, localName);
                    int sns = child.getSameNameSiblingIndex();
                    Path childPath = this.pathFactory.create(parentPath, childName, sns);
                    String childUuidString = child.getId().getChildUuidString();
                    Location childLocation = Location.create((Path)childPath, (UUID)UUID.fromString(childUuidString));
                    request.addChild(childLocation);
                }
            }
        }
        catch (NoResultException e) {
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        Location actualLocation;
        block15: {
            this.logger.trace(request.toString(), new Object[0]);
            actualLocation = null;
            Location previousSibling = request.startingAfter();
            int count = request.count();
            try {
                WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
                if (workspace == null) {
                    return;
                }
                Long workspaceId = workspace.getId();
                assert (workspaceId != null);
                ActualLocation actualSibling = this.getActualLocation(workspace, previousSibling);
                actualLocation = actualSibling.location;
                if (actualLocation.getPath().isRoot()) break block15;
                Path parentPath = actualSibling.location.getPath().getParent();
                assert (parentPath != null);
                LinkedList<Location> cachedChildren = this.cache.getAllChildren(workspaceId, parentPath);
                if (cachedChildren != null) {
                    boolean accumulate = false;
                    int counter = 0;
                    for (Location child : cachedChildren) {
                        if (accumulate) {
                            request.addChild(child);
                            if (++counter <= count) {
                                continue;
                            }
                            break block15;
                        }
                        if (!child.isSame(previousSibling)) continue;
                        accumulate = true;
                    }
                    break block15;
                }
                ChildEntity previousChild = actualSibling.childEntity;
                if (previousChild == null) {
                    Query query = this.entities.createNamedQuery("ChildEntity.findByChildUuid");
                    query.setParameter("workspaceId", (Object)workspaceId);
                    query.setParameter("childUuidString", (Object)actualSibling.uuid);
                    previousChild = (ChildEntity)query.getSingleResult();
                }
                int startingIndex = previousChild.getIndexInParent() + 1;
                String parentUuid = previousChild.getParentUuidString();
                Query query = this.entities.createNamedQuery("ChildEntity.findRangeUnderParent");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("parentUuidString", (Object)parentUuid);
                query.setParameter("firstIndex", (Object)startingIndex);
                query.setParameter("afterIndex", (Object)(startingIndex + request.count()));
                List children = query.getResultList();
                LinkedList<Location> allChildren = null;
                if (startingIndex == 1 && children.size() < request.count()) {
                    allChildren = new LinkedList<Location>();
                    allChildren.add(actualSibling.location);
                }
                for (ChildEntity child : children) {
                    String namespaceUri = child.getChildNamespace().getUri();
                    String localName = child.getChildName();
                    Name childName = this.nameFactory.create(namespaceUri, localName);
                    int sns = child.getSameNameSiblingIndex();
                    Path childPath = this.pathFactory.create(parentPath, childName, sns);
                    String childUuidString = child.getId().getChildUuidString();
                    Location childLocation = Location.create((Path)childPath, (UUID)UUID.fromString(childUuidString));
                    request.addChild(childLocation);
                    if (allChildren == null) continue;
                    allChildren.add(childLocation);
                }
                if (allChildren != null) {
                    this.cache.setAllChildren(workspaceId, parentPath, allChildren);
                }
            }
            catch (NoResultException e) {
            }
            catch (Throwable e) {
                request.setError(e);
                return;
            }
        }
        if (actualLocation != null) {
            request.setActualLocationOfStartingAfterNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ReadAllPropertiesRequest request) {
        Location actualLocation;
        block10: {
            this.logger.trace(request.toString(), new Object[0]);
            actualLocation = null;
            try {
                WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
                if (workspace == null) {
                    return;
                }
                Long workspaceId = workspace.getId();
                assert (workspaceId != null);
                Location location = request.at();
                ActualLocation actual = this.getActualLocation(workspace, location);
                String uuidString = actual.uuid;
                actualLocation = actual.location;
                request.addProperty(actualLocation.getIdProperty(ModeShapeLexicon.UUID));
                Query query = this.entities.createNamedQuery("PropertiesEntity.findByUuid");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("uuid", (Object)uuidString);
                PropertiesEntity entity = (PropertiesEntity)query.getSingleResult();
                boolean compressed = entity.isCompressed();
                int propertyCount = entity.getPropertyCount();
                ArrayList<Property> properties = new ArrayList<Property>(propertyCount);
                byte[] data = entity.getData();
                if (data == null) break block10;
                LargeValueSerializer largeValues = new LargeValueSerializer(entity);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                ObjectInputStream ois = new ObjectInputStream(is);
                try {
                    this.serializer.deserializeAllProperties(ois, properties, largeValues);
                    for (Property property : properties) {
                        request.addProperty(property);
                    }
                }
                finally {
                    ois.close();
                }
            }
            catch (NoResultException e) {
            }
            catch (Throwable e) {
                request.setError(e);
                return;
            }
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ReadPropertyRequest request) {
        Location actualLocation;
        block13: {
            this.logger.trace(request.toString(), new Object[0]);
            actualLocation = null;
            try {
                WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
                if (workspace == null) {
                    return;
                }
                Long workspaceId = workspace.getId();
                assert (workspaceId != null);
                Name propertyName = request.named();
                if (ModeShapeLexicon.UUID.equals(propertyName) || JcrLexicon.UUID.equals(propertyName)) {
                    try {
                        Location location = request.on();
                        ActualLocation actual = this.getActualLocation(workspace, location);
                        UUID uuid = actual.location.getUuid();
                        Property uuidProperty = this.getExecutionContext().getPropertyFactory().create(propertyName, new Object[]{uuid});
                        request.setProperty(uuidProperty);
                        request.setActualLocationOfNode(actual.location);
                        this.setCacheableInfo((CacheableRequest)request);
                    }
                    catch (Throwable e) {
                        request.setError(e);
                    }
                    return;
                }
                Location location = request.on();
                ActualLocation actual = this.getActualLocation(workspace, location);
                String uuidString = actual.uuid;
                actualLocation = actual.location;
                Query query = this.entities.createNamedQuery("PropertiesEntity.findByUuid");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("uuid", (Object)uuidString);
                PropertiesEntity entity = (PropertiesEntity)query.getSingleResult();
                boolean compressed = entity.isCompressed();
                int propertyCount = entity.getPropertyCount();
                ArrayList<Property> properties = new ArrayList<Property>(propertyCount);
                byte[] data = entity.getData();
                if (data == null) break block13;
                LargeValueSerializer largeValues = new LargeValueSerializer(entity);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                ObjectInputStream ois = new ObjectInputStream(is);
                try {
                    Serializer.LargeValues skippedLargeValues = Serializer.NO_LARGE_VALUES;
                    this.serializer.deserializeSomeProperties(ois, properties, largeValues, skippedLargeValues, propertyName);
                    for (Property property : properties) {
                        request.setProperty(property);
                    }
                }
                finally {
                    ois.close();
                }
            }
            catch (NoResultException e) {
            }
            catch (Throwable e) {
                request.setError(e);
                return;
            }
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        this.setCacheableInfo((CacheableRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(UpdatePropertiesRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        Set<Name> createdProperties = null;
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location location = request.on();
            ActualLocation actual = this.getActualLocation(workspace, location);
            actualLocation = actual.location;
            Query query = this.entities.createNamedQuery("PropertiesEntity.findByUuid");
            query.setParameter("workspaceId", (Object)workspaceId);
            query.setParameter("uuid", (Object)actual.uuid);
            PropertiesEntity entity = null;
            try {
                References refs;
                ObjectOutputStream oos;
                entity = (PropertiesEntity)query.getSingleResult();
                boolean compressed = entity.isCompressed();
                byte[] originalData = entity.getData();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = null;
                if (compressed) {
                    gos = new GZIPOutputStream(baos);
                    oos = new ObjectOutputStream(gos);
                } else {
                    oos = new ObjectOutputStream(baos);
                }
                int numProps = 0;
                LargeValueSerializer largeValues = null;
                Map props = request.properties();
                References references = refs = this.enforceReferentialIntegrity ? new References() : null;
                if (originalData == null) {
                    largeValues = new LargeValueSerializer(entity);
                    numProps = props.size();
                    createdProperties = props.keySet();
                    this.serializer.serializeProperties(oos, numProps, props.values(), largeValues, refs);
                    if (gos != null) {
                        gos.finish();
                    }
                } else {
                    boolean hadLargeValues = !entity.getLargeValues().isEmpty();
                    HashSet<String> largeValueHashesWritten = hadLargeValues ? new HashSet<String>() : null;
                    largeValues = new LargeValueSerializer(entity, largeValueHashesWritten);
                    ByteArrayInputStream bais = new ByteArrayInputStream(originalData);
                    InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                    ObjectInputStream ois = new ObjectInputStream(is);
                    SkippedLargeValues removedValues = new SkippedLargeValues(largeValues);
                    createdProperties = new HashSet();
                    try {
                        Serializer.ReferenceValues refValues = refs != null ? refs : Serializer.NO_REFERENCES_VALUES;
                        numProps = this.serializer.reserializeProperties(ois, oos, props, largeValues, removedValues, createdProperties, refValues);
                        if (gos != null) {
                            gos.finish();
                        }
                    }
                    finally {
                        try {
                            ois.close();
                        }
                        finally {
                            oos.close();
                        }
                    }
                    if (hadLargeValues) {
                        removedValues.skippedKeys.removeAll(largeValueHashesWritten);
                        for (String oldHexKey : removedValues.skippedKeys) {
                            LargeValueId id = new LargeValueId(oldHexKey);
                            entity.getLargeValues().remove(id);
                        }
                    }
                    if (refs != null && refs.hasRemoved()) {
                        for (Reference reference : refs.getRemoved()) {
                            ReferenceId id;
                            ReferenceEntity refEntity;
                            String toUuid = this.resolveToUuid(workspace, reference);
                            if (toUuid == null || (refEntity = (ReferenceEntity)this.entities.find(ReferenceEntity.class, (Object)(id = new ReferenceId(workspaceId, actual.uuid, toUuid)))) == null) continue;
                            this.entities.remove((Object)refEntity);
                            this.workspaceIdsWithChangedReferences.add(workspaceId);
                        }
                    }
                }
                entity.setPropertyCount(numProps);
                entity.setData(baos.toByteArray());
                entity.setCompressed(this.compressData);
                if (refs != null && refs.hasWritten()) {
                    Set<Reference> newReferences = refs.getWritten();
                    newReferences.removeAll(refs.getRead());
                    if (newReferences.size() != 0) {
                        for (Reference reference : newReferences) {
                            String toUuid = this.resolveToUuid(workspace, reference);
                            if (toUuid == null) continue;
                            ReferenceId id = new ReferenceId(workspaceId, actual.uuid, toUuid);
                            ReferenceEntity refEntity = new ReferenceEntity(id);
                            this.entities.persist((Object)refEntity);
                            this.workspaceIdsWithChangedReferences.add(workspaceId);
                        }
                    }
                }
            }
            catch (NoResultException e) {
                this.createProperties(workspace, actual.uuid, request.properties().values());
                createdProperties = request.properties().keySet();
            }
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        if (actualLocation != null) {
            request.setActualLocationOfNode(actualLocation);
        }
        request.setNewProperties(createdProperties);
        this.recordChange((ChangeRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ReadBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualLocation = null;
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location location = request.at();
            ActualLocation actual = this.getActualLocation(workspace, location);
            actualLocation = actual.location;
            Path path = actualLocation.getPath();
            HashMap<String, Location> locationsByUuid = new HashMap<String, Location>();
            locationsByUuid.put(actual.uuid, location);
            int maxDepth = request.maximumDepth();
            SubgraphQuery query = SubgraphQuery.create(this.getExecutionContext(), this.entities, workspaceId, actualLocation.getUuid(), path, maxDepth);
            try {
                Path parent = path;
                String parentUuid = actual.uuid;
                Location parentLocation = actualLocation;
                List<Location> children = new LinkedList();
                HashMap childrenByParentLocation = new HashMap();
                childrenByParentLocation.put(parentLocation, children);
                boolean includeChildrenOfNodesAtMaxDepth = true;
                for (ChildEntity childEntity : query.getNodes(false, includeChildrenOfNodesAtMaxDepth)) {
                    String namespaceUri = childEntity.getChildNamespace().getUri();
                    String localName = childEntity.getChildName();
                    Name childName = this.nameFactory.create(namespaceUri, localName);
                    int sns = childEntity.getSameNameSiblingIndex();
                    String childParentUuid = childEntity.getParentUuidString();
                    if (!parentUuid.equals(childParentUuid)) {
                        parentLocation = (Location)locationsByUuid.get(childParentUuid);
                        parent = parentLocation.getPath();
                        parentUuid = childParentUuid;
                        children = (List)childrenByParentLocation.get(parentLocation);
                        if (children == null) {
                            children = new LinkedList();
                            childrenByParentLocation.put(parentLocation, children);
                        }
                    }
                    assert (children != null);
                    Path childPath = this.pathFactory.create(parent, childName, sns);
                    String childUuidString = childEntity.getId().getChildUuidString();
                    Location childLocation = Location.create((Path)childPath, (UUID)UUID.fromString(childUuidString));
                    locationsByUuid.put(childUuidString, childLocation);
                    children.add(childLocation);
                }
                for (Map.Entry entry : childrenByParentLocation.entrySet()) {
                    if (((List)entry.getValue()).isEmpty()) continue;
                    request.setChildren((Location)entry.getKey(), (List)entry.getValue());
                }
                includeChildrenOfNodesAtMaxDepth = false;
                for (PropertiesEntity propertiesEntity : query.getProperties(true, includeChildrenOfNodesAtMaxDepth)) {
                    boolean compressed = propertiesEntity.isCompressed();
                    int propertyCount = propertiesEntity.getPropertyCount();
                    ArrayList<Property> properties = new ArrayList<Property>(propertyCount);
                    Location nodeLocation = (Location)locationsByUuid.get(propertiesEntity.getId().getUuidString());
                    assert (nodeLocation != null);
                    properties.add(actualLocation.getIdProperty(ModeShapeLexicon.UUID));
                    byte[] data = propertiesEntity.getData();
                    if (data == null) continue;
                    LargeValueSerializer largeValues = new LargeValueSerializer(propertiesEntity);
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                    ObjectInputStream ois = new ObjectInputStream(is);
                    try {
                        this.serializer.deserializeAllProperties(ois, properties, largeValues);
                        request.setProperties(nodeLocation, properties);
                    }
                    finally {
                        ois.close();
                    }
                }
            }
            finally {
                query.close();
            }
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo((CacheableRequest)request);
    }

    private ActualLocation copyNode(EntityManager entities, WorkspaceEntity fromWorkspace, WorkspaceEntity intoWorkspace, ChildEntity original, ActualLocation actualNewParent, UuidConflictBehavior uuidConflictBehavior, Name desiredName, Path.Segment desiredSegment, Map<String, String> oldUuidsToNewUuids, Map<Location, ChildEntity> addedLocations, Map<String, Location> deletedLocations) {
        assert (fromWorkspace != null);
        assert (intoWorkspace != null);
        assert (original != null);
        assert (desiredName == null ? desiredSegment != null : desiredSegment == null) : "Either desiredName or desiredSegment must not be null";
        assert (oldUuidsToNewUuids != null);
        String newUuid = original.getId().getChildUuidString();
        ActualLocation newLocation = null;
        ActualLocation existingLocation = null;
        UUID oldUuid = UUID.fromString(original.getId().getChildUuidString());
        switch (uuidConflictBehavior) {
            case ALWAYS_CREATE_NEW_UUID: {
                newUuid = UUID.randomUUID().toString();
                break;
            }
            case THROW_EXCEPTION: {
                try {
                    existingLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)oldUuid));
                    String pathAsString = existingLocation.toString();
                    throw new UuidAlreadyExistsException(this.getSourceName(), oldUuid, pathAsString, intoWorkspace.getName());
                }
                catch (PathNotFoundException pnfe) {
                    break;
                }
            }
            case REPLACE_EXISTING_NODE: {
                try {
                    if (desiredSegment != null) {
                        Location nLocation = Location.create((Path)this.pathFactory.create(actualNewParent.location.getPath(), new Path.Segment[]{desiredSegment}));
                        existingLocation = this.getActualLocation(intoWorkspace, nLocation);
                        nLocation = Location.create((Path)nLocation.getPath(), (UUID)UUID.fromString(existingLocation.uuid));
                        assert (nLocation.getUuid() != null);
                        deletedLocations.putAll(this.computeDeletedLocations(intoWorkspace, nLocation, true));
                        newUuid = existingLocation.childEntity.getId().getChildUuidString();
                        break;
                    }
                    existingLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)oldUuid));
                    deletedLocations.putAll(this.computeDeletedLocations(intoWorkspace, existingLocation.location, true));
                }
                catch (PathNotFoundException pnfe) {}
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected UuidConflictBehavior value: " + (Object)((Object)uuidConflictBehavior));
            }
        }
        oldUuidsToNewUuids.put(original.getId().getChildUuidString(), newUuid);
        if (existingLocation != null && existingLocation.childEntity.getParentUuidString().equals(actualNewParent.uuid)) {
            if (desiredName == null) {
                assert (desiredSegment != null);
                desiredName = desiredSegment.getName();
            }
            NamespaceEntity namespace = NamespaceEntity.findByUri(entities, desiredName.getNamespaceUri());
            ChildEntity existingChild = existingLocation.childEntity;
            existingChild.setChildName(desiredName.getLocalName());
            existingChild.setChildNamespace(namespace);
            existingChild.setParentUuidString(actualNewParent.uuid);
            existingChild.setAllowsSameNameChildren(original.getAllowsSameNameChildren());
            existingChild.setIndexInParent(original.getIndexInParent());
            existingChild.setSameNameSiblingIndex(original.getSameNameSiblingIndex());
            Location parentLocation = actualNewParent.location;
            assert (parentLocation.hasPath());
            Name segmentName = this.nameFactory.create(existingChild.getChildNamespace().getUri(), existingChild.getChildName());
            Path.Segment newSegment = this.pathFactory.createSegment(segmentName, existingChild.getSameNameSiblingIndex());
            Path newPath = this.pathFactory.create(parentLocation.getPath(), new Path.Segment[]{newSegment});
            newLocation = new ActualLocation(Location.create((Path)newPath, (UUID)UUID.fromString(newUuid)), newUuid, existingChild);
        } else {
            boolean allowSnS = original.getAllowsSameNameChildren();
            if (desiredName == null) {
                assert (desiredSegment != null);
                desiredName = desiredSegment.getName();
            }
            newLocation = this.addNewChild(intoWorkspace.getId(), actualNewParent, newUuid, desiredName, allowSnS);
        }
        assert (newLocation != null);
        addedLocations.put(newLocation.location, newLocation.childEntity);
        return newLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CopyBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualFromLocation = null;
        Location actualToLocation = null;
        try {
            WorkspaceEntity fromWorkspace = this.getExistingWorkspace(request.fromWorkspace(), (Request)request);
            if (fromWorkspace == null) {
                return;
            }
            WorkspaceEntity intoWorkspace = this.getExistingWorkspace(request.intoWorkspace(), (Request)request);
            if (intoWorkspace == null) {
                return;
            }
            Long fromWorkspaceId = fromWorkspace.getId();
            Long intoWorkspaceId = intoWorkspace.getId();
            assert (fromWorkspaceId != null);
            assert (intoWorkspaceId != null);
            Location fromLocation = request.from();
            ActualLocation actualFrom = this.getActualLocation(fromWorkspace, fromLocation);
            actualFromLocation = actualFrom.location;
            Path fromPath = actualFromLocation.getPath();
            Location newParentLocation = request.into();
            ActualLocation actualNewParent = this.getActualLocation(intoWorkspace, newParentLocation);
            assert (actualNewParent != null);
            HashMap<String, String> originalToNewUuid = new HashMap<String, String>();
            SubgraphQuery query = SubgraphQuery.create(this.getExecutionContext(), this.entities, fromWorkspaceId, actualFromLocation.getUuid(), fromPath, 0);
            try {
                ChildEntity original;
                List<ChildEntity> originalNodes = query.getNodes(true, true);
                Iterator<ChildEntity> originalIter = originalNodes.iterator();
                HashMap<Location, ChildEntity> addedLocations = new HashMap<Location, ChildEntity>();
                HashMap<String, Location> deletedLocations = new HashMap<String, Location>();
                if (originalIter.hasNext()) {
                    original = originalIter.next();
                    Name desiredName = request.desiredName();
                    if (desiredName == null) {
                        desiredName = fromPath.getLastSegment().getName();
                    }
                    actualToLocation = this.copyNode((EntityManager)this.entities, (WorkspaceEntity)fromWorkspace, (WorkspaceEntity)intoWorkspace, (ChildEntity)original, (ActualLocation)actualNewParent, (UuidConflictBehavior)UuidConflictBehavior.ALWAYS_CREATE_NEW_UUID, (Name)desiredName, null, originalToNewUuid, addedLocations, deletedLocations).location;
                }
                while (originalIter.hasNext()) {
                    original = originalIter.next();
                    String newParentUuidOfCopy = (String)originalToNewUuid.get(original.getParentUuidString());
                    assert (newParentUuidOfCopy != null);
                    actualNewParent = this.getActualLocation(intoWorkspace, Location.create((UUID)UUID.fromString(newParentUuidOfCopy)));
                    Name desiredName = this.nameFactory.create(original.getChildNamespace().getUri(), original.getChildName());
                    this.copyNode(this.entities, fromWorkspace, intoWorkspace, original, actualNewParent, UuidConflictBehavior.ALWAYS_CREATE_NEW_UUID, desiredName, null, originalToNewUuid, addedLocations, deletedLocations);
                }
                this.entities.flush();
                HashSet<String> newNodesWithReferenceProperties = new HashSet<String>();
                for (ReferenceEntity reference : query.getInternalReferences()) {
                    String newFromUuid = (String)originalToNewUuid.get(reference.getId().getFromUuidString());
                    assert (newFromUuid != null);
                    String newToUuid = (String)originalToNewUuid.get(reference.getId().getToUuidString());
                    assert (newToUuid != null);
                    ReferenceEntity copy = new ReferenceEntity(new ReferenceId(intoWorkspaceId, newFromUuid, newToUuid));
                    this.entities.persist((Object)copy);
                    newNodesWithReferenceProperties.add(newFromUuid);
                }
                for (ReferenceEntity reference : query.getOutwardReferences()) {
                    String oldToUuid = reference.getId().getToUuidString();
                    String newFromUuid = (String)originalToNewUuid.get(reference.getId().getFromUuidString());
                    assert (newFromUuid != null);
                    ActualLocation refTargetLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)UUID.fromString(oldToUuid)));
                    if (refTargetLocation == null) {
                        ValueFactory refFactory = this.getExecutionContext().getValueFactories().getReferenceFactory();
                        HashMap invalidRefs = new HashMap();
                        UUID fromUuid = UUID.fromString(reference.getId().getFromUuidString());
                        ActualLocation actualRefFromLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)fromUuid));
                        Location refFromLocation = actualRefFromLocation.location;
                        ArrayList<Object> refs = (ArrayList<Object>)invalidRefs.get(fromLocation);
                        if (refs == null) {
                            refs = new ArrayList<Object>();
                            invalidRefs.put(refFromLocation, refs);
                        }
                        UUID toUuid = UUID.fromString(oldToUuid);
                        refs.add(refFactory.create(toUuid));
                        String msg = JpaConnectorI18n.invalidReferences.text(new Object[]{reference.getId().getFromUuidString()});
                        throw new ReferentialIntegrityException(invalidRefs, msg);
                    }
                    ReferenceEntity copy = new ReferenceEntity(new ReferenceId(intoWorkspaceId, newFromUuid, oldToUuid));
                    this.entities.persist((Object)copy);
                    newNodesWithReferenceProperties.add(newFromUuid);
                }
                HashSet<PropertiesEntity> addedProps = new HashSet<PropertiesEntity>();
                for (PropertiesEntity original2 : query.getProperties(true, true)) {
                    String copyUuid = (String)originalToNewUuid.get(original2.getId().getUuidString());
                    assert (copyUuid != null);
                    boolean compressed = original2.isCompressed();
                    byte[] originalData = original2.getData();
                    NodeId propertiesId = new NodeId(intoWorkspaceId, copyUuid);
                    PropertiesEntity copy = (PropertiesEntity)this.entities.find(PropertiesEntity.class, (Object)propertiesId);
                    if (copy == null) {
                        copy = new PropertiesEntity(propertiesId);
                    }
                    copy.setCompressed(compressed);
                    if (newNodesWithReferenceProperties.contains(copyUuid)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStream os = compressed ? new GZIPOutputStream(baos) : baos;
                        ObjectOutputStream oos = new ObjectOutputStream(os);
                        ByteArrayInputStream bais = new ByteArrayInputStream(originalData);
                        InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                        ObjectInputStream ois = new ObjectInputStream(is);
                        try {
                            this.serializer.adjustReferenceProperties(ois, oos, originalToNewUuid);
                        }
                        finally {
                            try {
                                ois.close();
                            }
                            finally {
                                oos.close();
                            }
                        }
                        copy.setData(baos.toByteArray());
                    } else {
                        copy.setData(originalData);
                    }
                    copy.setPropertyCount(original2.getPropertyCount());
                    copy.setReferentialIntegrityEnforced(original2.isReferentialIntegrityEnforced());
                    addedProps.add(copy);
                    this.entities.persist((Object)copy);
                }
                this.entities.flush();
            }
            finally {
                query.close();
            }
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        request.setActualLocations(actualFromLocation, actualToLocation);
        this.recordChange((ChangeRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CloneBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualFromLocation = null;
        Location actualToLocation = null;
        Set removedLocations = null;
        try {
            WorkspaceEntity fromWorkspace = this.getExistingWorkspace(request.fromWorkspace(), (Request)request);
            if (fromWorkspace == null) {
                return;
            }
            WorkspaceEntity intoWorkspace = this.getExistingWorkspace(request.intoWorkspace(), (Request)request);
            if (intoWorkspace == null) {
                return;
            }
            Long fromWorkspaceId = fromWorkspace.getId();
            Long intoWorkspaceId = intoWorkspace.getId();
            assert (fromWorkspaceId != null);
            assert (intoWorkspaceId != null);
            Location fromLocation = request.from();
            ActualLocation actualFrom = this.getActualLocation(fromWorkspace, fromLocation);
            actualFromLocation = actualFrom.location;
            Path fromPath = actualFromLocation.getPath();
            Location newParentLocation = request.into();
            ActualLocation actualNewParent = this.getActualLocation(intoWorkspace, newParentLocation);
            assert (actualNewParent != null);
            HashMap<String, String> originalToNewUuid = new HashMap<String, String>();
            SubgraphQuery query = SubgraphQuery.create(this.getExecutionContext(), this.entities, fromWorkspaceId, actualFromLocation.getUuid(), fromPath, 0);
            UuidConflictBehavior conflictBehavior = request.removeExisting() ? UuidConflictBehavior.REPLACE_EXISTING_NODE : UuidConflictBehavior.THROW_EXCEPTION;
            try {
                ChildEntity original;
                List<ChildEntity> originalNodes = query.getNodes(true, true);
                Iterator<ChildEntity> originalIter = originalNodes.iterator();
                HashMap<Location, ChildEntity> addedLocations = new HashMap<Location, ChildEntity>();
                HashMap<String, Location> deletedLocations = new HashMap<String, Location>();
                if (originalIter.hasNext()) {
                    Name desiredName;
                    original = originalIter.next();
                    actualToLocation = this.copyNode((EntityManager)this.entities, (WorkspaceEntity)fromWorkspace, (WorkspaceEntity)intoWorkspace, (ChildEntity)original, (ActualLocation)actualNewParent, (UuidConflictBehavior)conflictBehavior, (Name)desiredName, (Path.Segment)((desiredName = request.desiredName()) != null ? null : fromPath.getLastSegment()), originalToNewUuid, addedLocations, deletedLocations).location;
                }
                while (originalIter.hasNext()) {
                    original = originalIter.next();
                    String newParentUuidOfCopy = (String)originalToNewUuid.get(original.getParentUuidString());
                    assert (newParentUuidOfCopy != null);
                    actualNewParent = this.getActualLocation(intoWorkspace, Location.create((UUID)UUID.fromString(newParentUuidOfCopy)));
                    Name desiredName = this.nameFactory.create(original.getChildNamespace().getUri(), original.getChildName());
                    this.copyNode(this.entities, fromWorkspace, intoWorkspace, original, actualNewParent, conflictBehavior, desiredName, null, originalToNewUuid, addedLocations, deletedLocations);
                }
                this.entities.flush();
                HashSet<String> newNodesWithReferenceProperties = new HashSet<String>();
                for (ReferenceEntity reference : query.getInternalReferences()) {
                    String newFromUuid = (String)originalToNewUuid.get(reference.getId().getFromUuidString());
                    assert (newFromUuid != null);
                    String newToUuid = (String)originalToNewUuid.get(reference.getId().getToUuidString());
                    assert (newToUuid != null);
                    ReferenceEntity copy = new ReferenceEntity(new ReferenceId(intoWorkspaceId, newFromUuid, newToUuid));
                    this.entities.persist((Object)copy);
                    newNodesWithReferenceProperties.add(newFromUuid);
                }
                for (ReferenceEntity reference : query.getOutwardReferences()) {
                    String oldToUuid = reference.getId().getToUuidString();
                    String newFromUuid = (String)originalToNewUuid.get(reference.getId().getFromUuidString());
                    assert (newFromUuid != null);
                    ActualLocation refTargetLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)UUID.fromString(oldToUuid)));
                    if (refTargetLocation == null) {
                        ValueFactory refFactory = this.getExecutionContext().getValueFactories().getReferenceFactory();
                        HashMap hashMap = new HashMap();
                        UUID fromUuid = UUID.fromString(reference.getId().getFromUuidString());
                        ActualLocation actualRefFromLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)fromUuid));
                        Location refFromLocation = actualRefFromLocation.location;
                        ArrayList<Object> refs = (ArrayList<Object>)hashMap.get(fromLocation);
                        if (refs == null) {
                            refs = new ArrayList<Object>();
                            hashMap.put(refFromLocation, refs);
                        }
                        UUID toUuid = UUID.fromString(oldToUuid);
                        refs.add(refFactory.create(toUuid));
                        String msg = JpaConnectorI18n.invalidReferences.text(new Object[]{reference.getId().getFromUuidString()});
                        throw new ReferentialIntegrityException(hashMap, msg);
                    }
                    ReferenceEntity copy = new ReferenceEntity(new ReferenceId(intoWorkspaceId, newFromUuid, oldToUuid));
                    this.entities.persist((Object)copy);
                    newNodesWithReferenceProperties.add(newFromUuid);
                }
                HashSet<PropertiesEntity> addedProps = new HashSet<PropertiesEntity>();
                for (PropertiesEntity original2 : query.getProperties(true, true)) {
                    String copyUuid = (String)originalToNewUuid.get(original2.getId().getUuidString());
                    assert (copyUuid != null);
                    boolean compressed = original2.isCompressed();
                    byte[] originalData = original2.getData();
                    NodeId nodeId = new NodeId(intoWorkspaceId, copyUuid);
                    PropertiesEntity copy = (PropertiesEntity)this.entities.find(PropertiesEntity.class, (Object)nodeId);
                    if (copy == null) {
                        copy = new PropertiesEntity(nodeId);
                    }
                    copy.setCompressed(compressed);
                    if (newNodesWithReferenceProperties.contains(copyUuid)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStream os = compressed ? new GZIPOutputStream(baos) : baos;
                        ObjectOutputStream oos = new ObjectOutputStream(os);
                        ByteArrayInputStream bais = new ByteArrayInputStream(originalData);
                        InputStream is = compressed ? new GZIPInputStream(bais) : bais;
                        ObjectInputStream ois = new ObjectInputStream(is);
                        try {
                            this.serializer.adjustReferenceProperties(ois, oos, originalToNewUuid);
                        }
                        finally {
                            try {
                                ois.close();
                            }
                            finally {
                                oos.close();
                            }
                        }
                        copy.setData(baos.toByteArray());
                    } else {
                        copy.setData(originalData);
                    }
                    copy.setPropertyCount(original2.getPropertyCount());
                    copy.setReferentialIntegrityEnforced(original2.isReferentialIntegrityEnforced());
                    addedProps.add(copy);
                    this.entities.persist((Object)copy);
                }
                this.entities.flush();
                if (request.removeExisting()) {
                    HashMap<String, Location> netDeletedLocations = new HashMap<String, Location>(deletedLocations);
                    netDeletedLocations.values().removeAll(addedLocations.keySet());
                    if (netDeletedLocations.size() > 0) {
                        List<ReferenceEntity> invalidReferences = ReferenceEntity.getReferencesToUuids(intoWorkspace.getId(), netDeletedLocations.keySet(), this.entities);
                        Iterator<ReferenceEntity> iter = invalidReferences.iterator();
                        while (iter.hasNext()) {
                            ReferenceEntity invalidRef = iter.next();
                            if (!netDeletedLocations.keySet().contains(invalidRef.getId().getFromUuidString())) continue;
                            iter.remove();
                        }
                        if (invalidReferences.size() > 0) {
                            ValueFactory refFactory = this.getExecutionContext().getValueFactories().getReferenceFactory();
                            HashMap invalidRefs = new HashMap();
                            for (ReferenceEntity referenceEntity : invalidReferences) {
                                UUID fromUuid = UUID.fromString(referenceEntity.getId().getFromUuidString());
                                ActualLocation actualRefFromLocation = this.getActualLocation(intoWorkspace, Location.create((UUID)fromUuid));
                                Location refFromLocation = actualRefFromLocation.location;
                                ArrayList<Object> refs = (ArrayList<Object>)invalidRefs.get(fromLocation);
                                if (refs == null) {
                                    refs = new ArrayList<Object>();
                                    invalidRefs.put(refFromLocation, refs);
                                }
                                UUID toUuid = UUID.fromString(referenceEntity.getId().getToUuidString());
                                refs.add(refFactory.create(toUuid));
                            }
                            String msg = JpaConnectorI18n.unableToDeleteBecauseOfReferences.text(new Object[0]);
                            throw new ReferentialIntegrityException(invalidRefs, msg);
                        }
                        for (Location location : netDeletedLocations.values()) {
                            ActualLocation node = this.getActualLocation(intoWorkspace, location);
                            ChildEntity childEntity = node.childEntity;
                            if (childEntity != null) {
                                this.entities.remove((Object)node.childEntity);
                            }
                            PropertiesEntity.deletePropertiesFor(intoWorkspace.getId(), node.uuid, this.entities);
                        }
                        this.cache.removeBranch(intoWorkspaceId, netDeletedLocations.values());
                    }
                    if (!deletedLocations.isEmpty()) {
                        removedLocations = Collections.unmodifiableSet(new HashSet(deletedLocations.values()));
                    }
                    LargeValueEntity.deleteUnused(this.entities);
                }
            }
            finally {
                query.close();
            }
        }
        catch (Throwable e) {
            request.setError(e);
            return;
        }
        request.setActualLocations(actualFromLocation, actualToLocation);
        request.setRemovedNodes(removedLocations);
        this.recordChange((ChangeRequest)request);
    }

    public void process(DeleteBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location location = this.delete((Request)request, request.at(), request.inWorkspace(), true);
        if (location != null) {
            request.setActualLocationOfNode(location);
            this.recordChange((ChangeRequest)request);
        }
    }

    public void process(DeleteChildrenRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location location = this.delete((Request)request, request.at(), request.inWorkspace(), false);
        if (location != null) {
            request.setActualLocationOfNode(location);
            this.recordChange((ChangeRequest)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Location delete(Request request, Location location, String workspaceName, boolean deleteTopOfBranch) {
        Location actualLocation = null;
        try {
            WorkspaceEntity workspace = this.getExistingWorkspace(workspaceName, request);
            if (workspace == null) {
                return null;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            ActualLocation actual = this.getActualLocation(workspace, location);
            actualLocation = actual.location;
            Path path = actualLocation.getPath();
            SubgraphQuery query = SubgraphQuery.create(this.getExecutionContext(), this.entities, workspaceId, actualLocation.getUuid(), path, 0);
            try {
                ChildEntity deleted = query.getNode();
                String parentUuidString = deleted.getParentUuidString();
                String childName = deleted.getChildName();
                long nsId = deleted.getChildNamespace().getId();
                int indexInParent = deleted.getIndexInParent();
                List<Location> deletedLocations = query.getNodeLocations(true, true);
                query.deleteSubgraph(deleteTopOfBranch);
                List<ReferenceEntity> invalidReferences = query.getInwardReferences();
                if (invalidReferences.size() > 0) {
                    ValueFactory refFactory = this.getExecutionContext().getValueFactories().getReferenceFactory();
                    HashMap invalidRefs = new HashMap();
                    for (ReferenceEntity entity : invalidReferences) {
                        UUID fromUuid = UUID.fromString(entity.getId().getFromUuidString());
                        ActualLocation actualFromLocation = this.getActualLocation(workspace, Location.create((UUID)fromUuid));
                        Location fromLocation = actualFromLocation.location;
                        ArrayList<Object> refs = (ArrayList<Object>)invalidRefs.get(fromLocation);
                        if (refs == null) {
                            refs = new ArrayList<Object>();
                            invalidRefs.put(fromLocation, refs);
                        }
                        UUID toUuid = UUID.fromString(entity.getId().getToUuidString());
                        refs.add(refFactory.create(toUuid));
                    }
                    String msg = JpaConnectorI18n.unableToDeleteBecauseOfReferences.text(new Object[0]);
                    throw new ReferentialIntegrityException(invalidRefs, msg);
                }
                if (deleteTopOfBranch) {
                    ChildEntity.adjustSnsIndexesAndIndexesAfterRemoving(this.entities, workspaceId, parentUuidString, childName, nsId, indexInParent);
                    this.entities.flush();
                }
                this.cache.removeBranch(workspaceId, deletedLocations);
            }
            finally {
                query.close();
            }
        }
        catch (Throwable e) {
            request.setError(e);
            return null;
        }
        return actualLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Location> computeDeletedLocations(WorkspaceEntity workspace, Location topNodeLocation, boolean deleteTopOfBranch) {
        Location actualLocation = null;
        if (workspace == null) {
            return null;
        }
        Long workspaceId = workspace.getId();
        assert (workspaceId != null);
        ActualLocation actual = this.getActualLocation(workspace, topNodeLocation);
        actualLocation = actual.location;
        Path path = actualLocation.getPath();
        SubgraphQuery query = SubgraphQuery.create(this.getExecutionContext(), this.entities, workspaceId, actualLocation.getUuid(), path, 0);
        try {
            List<Location> deletedLocations = query.getNodeLocations(true, true);
            HashMap<String, Location> results = new HashMap<String, Location>(deletedLocations.size());
            for (Location location : deletedLocations) {
                results.put(location.getUuid().toString(), location);
            }
            HashMap<String, Location> hashMap = results;
            return hashMap;
        }
        finally {
            query.close();
        }
    }

    private Location moveNodeToLastChild(WorkspaceEntity workspace, ActualLocation actualFromLocation, ActualLocation actualIntoLocation, Name desiredName) {
        Integer index;
        long workspaceId = workspace.getId();
        Path oldPath = actualFromLocation.location.getPath();
        ChildEntity fromEntity = actualFromLocation.childEntity;
        int oldIndex = fromEntity.getIndexInParent();
        String oldParentUuid = fromEntity.getParentUuidString();
        String toUuidString = actualIntoLocation.uuid;
        String childOldLocalName = fromEntity.getChildName();
        String childLocalName = null;
        NamespaceEntity ns = null;
        Name childName = desiredName;
        if (childName != null) {
            childLocalName = desiredName.getLocalName();
            String childNsUri = childName.getNamespaceUri();
            ns = this.namespaces.get(childNsUri, true);
        } else {
            childName = oldPath.getLastSegment().getName();
            childLocalName = fromEntity.getChildName();
            ns = fromEntity.getChildNamespace();
        }
        int nextSnsIndex = 1;
        int nextIndexInParent = 1;
        Query query = this.entities.createNamedQuery("ChildEntity.findMaximumSnsIndex");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuid", (Object)toUuidString);
        query.setParameter("ns", (Object)ns.getId());
        query.setParameter("childName", (Object)childLocalName);
        try {
            index = (Integer)query.getSingleResult();
            if (index != null) {
                nextSnsIndex = index + 1;
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
        query = this.entities.createNamedQuery("ChildEntity.findMaximumChildIndex");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuid", (Object)toUuidString);
        try {
            index = (Integer)query.getSingleResult();
            if (index != null) {
                nextIndexInParent = index + 1;
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
        fromEntity.setParentUuidString(toUuidString);
        fromEntity.setChildName(childLocalName);
        fromEntity.setChildNamespace(ns);
        fromEntity.setIndexInParent(nextIndexInParent);
        fromEntity.setSameNameSiblingIndex(nextSnsIndex);
        this.entities.flush();
        Path newParentPath = actualIntoLocation.location.getPath();
        Path newPath = this.pathFactory.create(newParentPath, childName, nextSnsIndex);
        Location newLocation = actualFromLocation.location.with(newPath);
        ChildEntity.adjustSnsIndexesAndIndexesAfterRemoving(this.entities, workspaceId, oldParentUuid, childOldLocalName, ns.getId(), oldIndex);
        this.cache.moveNode(workspaceId, actualFromLocation.location, oldIndex, newLocation);
        return newLocation;
    }

    private Location moveNodeBefore(WorkspaceEntity workspace, ActualLocation actualFromLocation, ActualLocation actualIntoLocation, ActualLocation actualBeforeLocation) {
        long workspaceId = workspace.getId();
        ChildEntity fromEntity = actualFromLocation.childEntity;
        assert (fromEntity != null);
        Path oldPath = actualFromLocation.location.getPath();
        String oldParentUuid = fromEntity.getParentUuidString();
        String toUuidString = actualIntoLocation.uuid;
        Location beforeLocation = actualBeforeLocation.location;
        ChildEntity beforeEntity = actualBeforeLocation.childEntity;
        if (beforeEntity == null) {
            beforeEntity = this.findNode(workspaceId, actualBeforeLocation.uuid);
        }
        assert (beforeEntity != null);
        Name childName = oldPath.getLastSegment().getName();
        String childLocalName = fromEntity.getChildName();
        NamespaceEntity ns = fromEntity.getChildNamespace();
        boolean sameParent = oldParentUuid.equals(toUuidString);
        if (sameParent) {
            int snsCount;
            if (fromEntity.getIndexInParent() < beforeEntity.getIndexInParent()) {
                int oldIndex = beforeEntity.getIndexInParent();
                snsCount = ChildEntity.adjustSnsIndexesAndIndexes(this.entities, workspaceId, fromEntity.getParentUuidString(), fromEntity.getIndexInParent(), beforeEntity.getIndexInParent(), fromEntity.getChildNamespace().getId(), fromEntity.getChildName(), -1);
                fromEntity.setIndexInParent(oldIndex);
                fromEntity.setSameNameSiblingIndex(fromEntity.getSameNameSiblingIndex() + snsCount);
            } else {
                int oldIndex = beforeEntity.getIndexInParent();
                snsCount = ChildEntity.adjustSnsIndexesAndIndexes(this.entities, workspaceId, fromEntity.getParentUuidString(), beforeEntity.getIndexInParent() - 1, fromEntity.getIndexInParent() - 1, fromEntity.getChildNamespace().getId(), fromEntity.getChildName(), 1);
                fromEntity.setIndexInParent(oldIndex);
                fromEntity.setSameNameSiblingIndex(fromEntity.getSameNameSiblingIndex() - snsCount);
            }
            Path newPath = this.pathFactory.create(oldPath.getParent(), new Path.Segment[]{this.pathFactory.createSegment(fromEntity.getChildName(), fromEntity.getSameNameSiblingIndex())});
            return actualFromLocation.location.with(newPath);
        }
        int oldIndex = fromEntity.getIndexInParent();
        Query query = this.entities.createNamedQuery("ChildEntity.findAllUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)toUuidString);
        int nextIndexInParent = 0;
        int nextSnsIndex = 1;
        try {
            List children = query.getResultList();
            Path beforePath = beforeLocation.getPath();
            Path.Segment beforeSegment = beforePath.getLastSegment();
            boolean foundBefore = false;
            for (ChildEntity child : children) {
                NamespaceEntity namespace = child.getChildNamespace();
                if (namespace.getUri().equals(ns.getUri()) && child.getChildName().equals(childLocalName) && child.getSameNameSiblingIndex() == beforeSegment.getIndex()) {
                    foundBefore = true;
                    nextIndexInParent = child.getIndexInParent();
                    nextSnsIndex = beforeSegment.getIndex();
                }
                if (!foundBefore) continue;
                child.setIndexInParent(child.getIndexInParent() + 1);
                if (child.getChildName().equals(childLocalName) && namespace.getUri().equals(ns.getUri())) {
                    child.setSameNameSiblingIndex(child.getSameNameSiblingIndex() + 1);
                }
                this.entities.persist((Object)child);
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
        fromEntity.setParentUuidString(toUuidString);
        fromEntity.setChildName(childLocalName);
        fromEntity.setChildNamespace(ns);
        fromEntity.setIndexInParent(nextIndexInParent);
        fromEntity.setSameNameSiblingIndex(nextSnsIndex);
        this.entities.flush();
        Path newParentPath = actualIntoLocation.location.getPath();
        Path newPath = this.pathFactory.create(newParentPath, childName, nextSnsIndex);
        Location oldLocation = actualFromLocation.location;
        Location newLocation = oldLocation.with(newPath);
        ChildEntity.adjustSnsIndexesAndIndexesAfterRemoving(this.entities, workspaceId, oldParentUuid, childLocalName, ns.getId(), -1);
        this.cache.moveNode(workspaceId, oldLocation, oldIndex, newLocation);
        return newLocation;
    }

    public void process(MoveBranchRequest request) {
        this.logger.trace(request.toString(), new Object[0]);
        Location actualOldLocation = null;
        Location actualNewLocation = null;
        try {
            Path oldPath;
            WorkspaceEntity workspace = this.getExistingWorkspace(request.inWorkspace(), (Request)request);
            if (workspace == null) {
                return;
            }
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            Location fromLocation = request.from();
            ActualLocation actualLocation = this.getActualLocation(workspace, fromLocation);
            if (actualLocation.childEntity == null) {
                actualLocation = new ActualLocation(actualLocation.location, actualLocation.uuid, this.findNode(workspaceId, actualLocation.uuid));
            }
            if ((oldPath = (actualOldLocation = actualLocation.location).getPath()).isRoot()) {
                String msg = JpaConnectorI18n.unableToMoveRootNode.text(new Object[]{this.getSourceName()});
                throw new InvalidRequestException(msg);
            }
            if (request.hasNoEffect()) {
                actualNewLocation = actualOldLocation;
            } else {
                Location beforeLocation = request.before();
                if (beforeLocation == null) {
                    ActualLocation actualIntoLocation = this.getActualLocation(workspace, request.into());
                    actualNewLocation = this.moveNodeToLastChild(workspace, actualLocation, actualIntoLocation, request.desiredName());
                } else {
                    ActualLocation actualBeforeLocation = this.getActualLocation(workspace, beforeLocation);
                    ActualLocation actualIntoLocation = this.getActualLocation(workspace, Location.create((Path)beforeLocation.getPath().getParent()));
                    actualNewLocation = this.moveNodeBefore(workspace, actualLocation, actualIntoLocation, actualBeforeLocation);
                }
            }
        }
        catch (Throwable e) {
            System.err.flush();
            System.out.flush();
            e.printStackTrace();
            System.err.flush();
            request.setError(e);
            return;
        }
        request.setActualLocations(actualOldLocation, actualNewLocation);
        this.recordChange((ChangeRequest)request);
    }

    public void process(VerifyWorkspaceRequest request) {
        WorkspaceEntity workspace;
        String workspaceName = request.workspaceName();
        if (workspaceName == null) {
            workspaceName = this.nameOfDefaultWorkspace;
        }
        if ((workspace = this.getExistingWorkspace(workspaceName, (Request)request)) != null) {
            Long workspaceId = workspace.getId();
            assert (workspaceId != null);
            ActualLocation actual = this.getActualLocation(workspace, Location.create((Path)this.pathFactory.createRootPath()));
            request.setActualRootLocation(actual.location);
            request.setActualWorkspaceName(workspace.getName());
        }
    }

    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.workspaces.getWorkspaceNames();
        for (String name : this.predefinedWorkspaceNames) {
            names.add(name);
        }
        request.setAvailableWorkspaceNames(Collections.unmodifiableSet(names));
        this.setCacheableInfo((CacheableRequest)request);
    }

    public void process(CreateWorkspaceRequest request) {
        String name = request.desiredNameOfNewWorkspace();
        if (!this.creatingWorkspacesAllowed) {
            String msg = JpaConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName()});
            request.setError((Throwable)new InvalidRequestException(msg));
            return;
        }
        Set<String> existingNames = this.workspaces.getWorkspaceNames();
        int counter = 0;
        block3: while (existingNames.contains(name)) {
            switch (request.conflictBehavior()) {
                case CREATE_WITH_ADJUSTED_NAME: {
                    name = request.desiredNameOfNewWorkspace() + ++counter;
                    continue block3;
                }
            }
            String msg = JpaConnectorI18n.workspaceAlreadyExists.text(new Object[]{this.getSourceName(), name});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
            return;
        }
        WorkspaceEntity entity = this.workspaces.create(name);
        request.setActualWorkspaceName(entity.getName());
        Location root = Location.create((Path)this.pathFactory.createRootPath());
        request.setActualRootLocation(this.getActualLocation((WorkspaceEntity)entity, (Location)root).location);
        this.recordChange((ChangeRequest)request);
    }

    public void process(CloneWorkspaceRequest request) {
        if (!this.creatingWorkspacesAllowed) {
            String msg = JpaConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName()});
            request.setError((Throwable)new InvalidRequestException(msg));
            return;
        }
        Set<String> existingNames = this.workspaces.getWorkspaceNames();
        String name = request.desiredNameOfTargetWorkspace();
        int counter = 0;
        block6: while (existingNames.contains(name)) {
            switch (request.targetConflictBehavior()) {
                case CREATE_WITH_ADJUSTED_NAME: {
                    name = request.desiredNameOfTargetWorkspace() + ++counter;
                    continue block6;
                }
            }
            String msg = JpaConnectorI18n.workspaceAlreadyExists.text(new Object[]{this.getSourceName(), name});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
            return;
        }
        String fromWorkspaceName = request.nameOfWorkspaceToBeCloned();
        WorkspaceEntity fromWorkspace = this.workspaces.get(fromWorkspaceName, false);
        if (fromWorkspace == null) {
            switch (request.cloneConflictBehavior()) {
                case SKIP_CLONE: {
                    break;
                }
                default: {
                    String msg = JpaConnectorI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), fromWorkspaceName});
                    request.setError((Throwable)new InvalidRequestException(msg));
                    return;
                }
            }
        }
        WorkspaceEntity intoWorkspace = this.workspaces.create(name);
        String newWorkspaceName = intoWorkspace.getName();
        request.setActualWorkspaceName(newWorkspaceName);
        if (fromWorkspace != null) {
            Object copy;
            Serializable copyId;
            Long fromWorkspaceId = fromWorkspace.getId();
            Long intoWorkspaceId = intoWorkspace.getId();
            Query query = this.entities.createNamedQuery("ChildEntity.findInWorkspace");
            query.setParameter("workspaceId", (Object)fromWorkspaceId);
            List childEntities = query.getResultList();
            for (ChildEntity child : childEntities) {
                ChildId origId = child.getId();
                copyId = new ChildId(intoWorkspaceId, origId.getChildUuidString());
                copy = new ChildEntity((ChildId)copyId, child.getParentUuidString(), child.getIndexInParent(), child.getChildNamespace(), child.getChildName());
                ((ChildEntity)copy).setAllowsSameNameChildren(child.getAllowsSameNameChildren());
                ((ChildEntity)copy).setSameNameSiblingIndex(child.getSameNameSiblingIndex());
                this.entities.persist(copy);
            }
            this.entities.flush();
            query = this.entities.createNamedQuery("PropertiesEntity.findInWorkspace");
            query.setParameter("workspaceId", (Object)fromWorkspaceId);
            List properties = query.getResultList();
            for (PropertiesEntity property : properties) {
                copyId = new NodeId(intoWorkspaceId, property.getId().getUuidString());
                copy = new PropertiesEntity((NodeId)copyId);
                ((PropertiesEntity)copy).setCompressed(property.isCompressed());
                ((PropertiesEntity)copy).setData(property.getData());
                ((PropertiesEntity)copy).setPropertyCount(property.getPropertyCount());
                ((PropertiesEntity)copy).setReferentialIntegrityEnforced(property.isReferentialIntegrityEnforced());
                Collection<LargeValueId> ids = property.getLargeValues();
                if (ids.size() != 0) {
                    ((PropertiesEntity)copy).getLargeValues().addAll(ids);
                }
                this.entities.persist(copy);
            }
            this.entities.flush();
            query = this.entities.createNamedQuery("ReferenceEntity.findInWorkspace");
            query.setParameter("workspaceId", (Object)fromWorkspaceId);
            List references = query.getResultList();
            for (ReferenceEntity reference : references) {
                ReferenceId from = reference.getId();
                ReferenceId copy2 = new ReferenceId(fromWorkspaceId, from.getFromUuidString(), from.getToUuidString());
                this.entities.persist((Object)new ReferenceEntity(copy2));
            }
            this.entities.flush();
        }
        Location root = Location.create((Path)this.pathFactory.createRootPath(), (UUID)this.rootNodeUuid);
        request.setActualRootLocation(this.getActualLocation((WorkspaceEntity)intoWorkspace, (Location)root).location);
        this.recordChange((ChangeRequest)request);
    }

    public void process(DestroyWorkspaceRequest request) {
        WorkspaceEntity workspace = this.getExistingWorkspace(request.workspaceName(), (Request)request);
        if (workspace == null) {
            return;
        }
        Long workspaceId = workspace.getId();
        assert (workspaceId != null);
        ActualLocation actual = this.getActualLocation(workspace, Location.create((Path)this.pathFactory.createRootPath()));
        this.workspaces.destroy(workspace.getName());
        Query delete = this.entities.createQuery("delete PropertiesEntity entity where entity.id.workspaceId = :workspaceId");
        delete.setParameter("workspaceId", (Object)workspaceId);
        delete.executeUpdate();
        delete = this.entities.createQuery("delete ChildEntity entity where entity.id.workspaceId = :workspaceId");
        delete.setParameter("workspaceId", (Object)workspaceId);
        delete.executeUpdate();
        delete = this.entities.createQuery("delete ReferenceEntity entity where entity.id.workspaceId = :workspaceId");
        delete.setParameter("workspaceId", (Object)workspaceId);
        delete.executeUpdate();
        LargeValueEntity.deleteUnused(this.entities);
        request.setActualRootLocation(actual.location);
        this.recordChange((ChangeRequest)request);
    }

    public void close() {
        this.verifyReferences();
        super.close();
    }

    protected WorkspaceEntity getExistingWorkspace(String workspaceName, Request request) {
        WorkspaceEntity workspace = this.workspaces.get(workspaceName, false);
        if (workspace == null) {
            for (String name : this.predefinedWorkspaceNames) {
                if (!workspaceName.equals(name)) continue;
                return this.workspaces.create(workspaceName);
            }
            String msg = JpaConnectorI18n.workspaceDoesNotExist.text(new Object[]{this.getSourceName(), workspaceName});
            request.setError((Throwable)new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected void verifyReferences() throws ReferentialIntegrityException {
        if (!this.enforceReferentialIntegrity) {
            return;
        }
        if (!this.workspaceIdsWithChangedReferences.isEmpty()) {
            HashMap invalidRefs = new HashMap();
            for (Long workspaceId : this.workspaceIdsWithChangedReferences) {
                ReferenceEntity.deleteUnenforcedReferences(workspaceId, this.entities);
                int numUnresolved = ReferenceEntity.countAllReferencesResolved(workspaceId, this.entities);
                if (numUnresolved == 0) continue;
                List<ReferenceEntity> references = ReferenceEntity.verifyAllReferencesResolved(workspaceId, this.entities);
                ValueFactory refFactory = this.getExecutionContext().getValueFactories().getReferenceFactory();
                for (ReferenceEntity entity : references) {
                    ReferenceId id = entity.getId();
                    UUID fromUuid = UUID.fromString(id.getFromUuidString());
                    Location location = Location.create((UUID)fromUuid);
                    WorkspaceEntity dummyWorkspaceReference = new WorkspaceEntity();
                    dummyWorkspaceReference.setId(id.getWorkspaceId());
                    dummyWorkspaceReference.setName("<unknown>");
                    location = this.getActualLocation((WorkspaceEntity)dummyWorkspaceReference, (Location)location).location;
                    ArrayList<Object> refs = (ArrayList<Object>)invalidRefs.get(location);
                    if (refs == null) {
                        refs = new ArrayList<Object>();
                        invalidRefs.put(location, refs);
                    }
                    UUID toUuid = UUID.fromString(id.getToUuidString());
                    refs.add(refFactory.create(toUuid));
                }
            }
            this.workspaceIdsWithChangedReferences.clear();
            if (!invalidRefs.isEmpty()) {
                String msg = JpaConnectorI18n.invalidReferences.text(new Object[]{this.getSourceName()});
                throw new ReferentialIntegrityException(invalidRefs, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createProperties(WorkspaceEntity workspace, String uuidString, Collection<Property> properties) throws IOException {
        assert (uuidString != null);
        NodeId nodeId = new NodeId(workspace.getId(), uuidString);
        PropertiesEntity props = new PropertiesEntity(nodeId);
        boolean processProperties = true;
        if (properties.isEmpty()) {
            processProperties = false;
        } else if (properties.size() == 1 && properties.iterator().next().getName().equals(JcrLexicon.NAME)) {
            processProperties = false;
        }
        if (processProperties) {
            References refs = this.enforceReferentialIntegrity ? new References() : null;
            LargeValueSerializer largeValues = new LargeValueSerializer(props);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream os = this.compressData ? new GZIPOutputStream(baos) : baos;
            ObjectOutputStream oos = new ObjectOutputStream(os);
            int numProperties = properties.size();
            try {
                Serializer.ReferenceValues refValues = refs != null ? refs : Serializer.NO_REFERENCES_VALUES;
                this.serializer.serializeProperties(oos, numProperties, properties, largeValues, refValues);
            }
            finally {
                oos.close();
            }
            props.setData(baos.toByteArray());
            props.setPropertyCount(numProperties);
            if (refs != null && refs.hasWritten()) {
                for (Reference reference : refs.getWritten()) {
                    String toUuid = this.resolveToUuid(workspace, reference);
                    if (toUuid == null) continue;
                    ReferenceId id = new ReferenceId(workspace.getId(), uuidString, toUuid);
                    ReferenceEntity refEntity = new ReferenceEntity(id);
                    this.entities.persist((Object)refEntity);
                    this.workspaceIdsWithChangedReferences.add(workspace.getId());
                }
            }
        } else {
            props.setData(null);
            props.setPropertyCount(0);
        }
        props.setCompressed(this.compressData);
        props.setReferentialIntegrityEnforced(true);
        this.entities.persist((Object)props);
        return uuidString;
    }

    protected String resolveToUuid(WorkspaceEntity workspace, Reference reference) {
        try {
            UUID uuid = (UUID)this.uuidFactory.create(reference);
            ActualLocation actualLocation = this.getActualLocation(workspace, Location.create((UUID)uuid));
            return actualLocation.uuid;
        }
        catch (ValueFormatException e) {
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected ActualLocation getActualLocation(WorkspaceEntity workspace, Location original) throws PathNotFoundException {
        Location cached;
        assert (original != null);
        long workspaceId = workspace.getId();
        Property uuidProperty = original.getIdProperty(ModeShapeLexicon.UUID);
        String uuidString = uuidProperty != null && !uuidProperty.isEmpty() ? (String)this.stringFactory.create(uuidProperty.getFirstValue()) : null;
        Path path = original.getPath();
        if (path != null && (cached = this.cache.getLocationFor(workspaceId, path)) != null) {
            return new ActualLocation(original, cached.getUuid().toString(), null);
        }
        if (uuidString != null) {
            String nodeUuidString = uuidString;
            LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
            ChildEntity entity = null;
            ChildEntity originalEntity = null;
            while (uuidString != null && !uuidString.equals(this.rootNodeUuidString)) {
                Query query = this.entities.createNamedQuery("ChildEntity.findByChildUuid");
                query.setParameter("workspaceId", (Object)workspaceId);
                query.setParameter("childUuidString", (Object)uuidString);
                try {
                    entity = (ChildEntity)query.getSingleResult();
                    if (originalEntity == null) {
                        originalEntity = entity;
                    }
                    String localName = entity.getChildName();
                    String uri = entity.getChildNamespace().getUri();
                    int sns = entity.getSameNameSiblingIndex();
                    Name name = this.nameFactory.create(uri, localName);
                    segments.addFirst(this.pathFactory.createSegment(name, sns));
                    uuidString = entity.getParentUuidString();
                }
                catch (NoResultException e) {
                    if (uuidString.equals(this.rootNodeUuidString)) continue;
                    String workspaceName = workspace.getName();
                    String msg = JpaConnectorI18n.invalidUuidForWorkspace.text(new Object[]{uuidString, workspaceName});
                    throw new PathNotFoundException(original, this.pathFactory.createRootPath(), msg);
                }
            }
            Path fullPath = this.pathFactory.createAbsolutePath(segments);
            Location newLocation = original.with(fullPath);
            this.cache.addNewNode(workspaceId, newLocation);
            return new ActualLocation(newLocation, nodeUuidString, originalEntity);
        }
        if (path == null) {
            String propName = ModeShapeLexicon.UUID.getString(this.getExecutionContext().getNamespaceRegistry());
            String msg = JpaConnectorI18n.locationShouldHavePathAndOrProperty.text(new Object[]{this.getSourceName(), propName});
            throw new PathNotFoundException(original, this.pathFactory.createRootPath(), msg);
        }
        if (path.isRoot()) {
            Location newLocation = original.with(this.rootNodeUuid);
            this.cache.addNewNode(workspaceId, newLocation);
            return new ActualLocation(newLocation, this.rootNodeUuidString, null);
        }
        Location cachedParent = this.cache.getLocationFor(workspaceId, path.getParent());
        if (cachedParent != null) {
            ChildEntity child = this.findByPathSegment(workspaceId, cachedParent.getUuid().toString(), path.getLastSegment());
            if (child == null) {
                throw new PathNotFoundException(original, cachedParent.getPath(), JpaConnectorI18n.nodeDoesNotExist.text(new Object[]{path}));
            }
            uuidString = child.getId().getChildUuidString();
            Location newLocation = original.with(UUID.fromString(uuidString));
            this.cache.addNewNode(workspaceId, newLocation);
            return new ActualLocation(original, uuidString, child);
        }
        String parentUuid = this.rootNodeUuidString;
        ChildEntity child = null;
        for (Path.Segment segment : path) {
            child = this.findByPathSegment(workspaceId, parentUuid, segment);
            if (child == null) {
                Path lowest = path;
                while (lowest.getLastSegment() != segment) {
                    lowest = lowest.getParent();
                }
                lowest = lowest.getParent();
                throw new PathNotFoundException(original, lowest);
            }
            parentUuid = child.getId().getChildUuidString();
        }
        assert (child != null);
        uuidString = child.getId().getChildUuidString();
        Location newLocation = original.with(UUID.fromString(uuidString));
        this.cache.addNewNode(workspaceId, newLocation);
        return new ActualLocation(newLocation, uuidString, child);
    }

    protected ChildEntity findNode(long workspaceId, String uuidString) {
        Query query = this.entities.createNamedQuery("ChildEntity.findByChildUuid");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("childUuidString", (Object)uuidString);
        try {
            return (ChildEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    protected ChildEntity findByPathSegment(Long workspaceId, String parentUuid, Path.Segment pathSegment) {
        assert (this.namespaces != null);
        assert (parentUuid != null);
        assert (pathSegment != null);
        assert (workspaceId != null);
        Name name = pathSegment.getName();
        String localName = name.getLocalName();
        String nsUri = name.getNamespaceUri();
        NamespaceEntity ns = this.namespaces.get(nsUri, false);
        if (ns == null) {
            return null;
        }
        int snsIndex = pathSegment.hasIndex() ? pathSegment.getIndex() : 1;
        Query query = this.entities.createNamedQuery("ChildEntity.findByPathSegment");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)parentUuid);
        query.setParameter("ns", (Object)ns.getId());
        query.setParameter("childName", (Object)localName);
        query.setParameter("sns", (Object)snsIndex);
        try {
            return (ChildEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    protected String createHexValuesString(Collection<String> hexValues) {
        if (hexValues == null || hexValues.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String hexValue : hexValues) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(hexValue);
        }
        return sb.toString();
    }

    protected Collection<String> createHexValues(String hexValuesString) {
        return Arrays.asList(hexValuesString.split(","));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class References
    implements Serializer.ReferenceValues {
        private Set<Reference> read;
        private Set<Reference> removed;
        private Set<Reference> written;

        protected References() {
        }

        @Override
        public void read(Reference reference) {
            if (this.read == null) {
                this.read = new HashSet<Reference>();
            }
            this.read.add(reference);
        }

        @Override
        public void remove(Reference reference) {
            if (this.removed == null) {
                this.removed = new HashSet<Reference>();
            }
            this.removed.add(reference);
        }

        @Override
        public void write(Reference reference) {
            if (this.written == null) {
                this.written = new HashSet<Reference>();
            }
            this.written.add(reference);
        }

        public boolean hasRead() {
            return this.read != null;
        }

        public boolean hasRemoved() {
            return this.removed != null;
        }

        public boolean hasWritten() {
            return this.written != null;
        }

        public Set<Reference> getRead() {
            if (this.read != null) {
                return this.read;
            }
            return Collections.emptySet();
        }

        public Set<Reference> getRemoved() {
            if (this.removed != null) {
                return this.removed;
            }
            return Collections.emptySet();
        }

        public Set<Reference> getWritten() {
            if (this.written != null) {
                return this.written;
            }
            return Collections.emptySet();
        }
    }

    @Immutable
    protected static class ActualLocation {
        protected final Location location;
        protected final String uuid;
        protected final ChildEntity childEntity;

        protected ActualLocation(Location location, String uuid, ChildEntity childEntity) {
            assert (location != null);
            assert (uuid != null);
            this.location = location;
            this.uuid = uuid;
            this.childEntity = childEntity;
        }

        public String toString() {
            return this.location.toString() + " (uuid=" + this.uuid + ") " + this.childEntity;
        }
    }

    protected class SkippedLargeValues
    implements Serializer.LargeValues {
        protected Collection<String> skippedKeys = new HashSet<String>();
        protected final Serializer.LargeValues delegate;

        SkippedLargeValues(Serializer.LargeValues delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public long getMinimumSize() {
            return this.delegate.getMinimumSize();
        }

        public Object read(ValueFactories valueFactories, byte[] hash, long length) throws IOException {
            String key = StringUtil.getHexString((byte[])hash);
            this.skippedKeys.add(key);
            return null;
        }

        public void write(byte[] hash, long length, PropertyType type, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    protected class RecordingLargeValues
    implements Serializer.LargeValues {
        protected final Collection<String> readKeys = new HashSet<String>();
        protected final Collection<String> writtenKeys = new HashSet<String>();
        protected final Serializer.LargeValues delegate;

        RecordingLargeValues(Serializer.LargeValues delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public long getMinimumSize() {
            return this.delegate.getMinimumSize();
        }

        public Object read(ValueFactories valueFactories, byte[] hash, long length) throws IOException {
            String key = StringUtil.getHexString((byte[])hash);
            this.readKeys.add(key);
            return this.delegate.read(valueFactories, hash, length);
        }

        public void write(byte[] hash, long length, PropertyType type, Object value) throws IOException {
            String key = StringUtil.getHexString((byte[])hash);
            this.writtenKeys.add(key);
            this.delegate.write(hash, length, type, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LargeValueSerializer
    implements Serializer.LargeValues {
        private final PropertiesEntity properties;
        private final Set<String> written;

        public LargeValueSerializer(PropertiesEntity entity) {
            this.properties = entity;
            this.written = null;
        }

        public LargeValueSerializer(PropertiesEntity entity, Set<String> written) {
            this.properties = entity;
            this.written = written;
        }

        @Override
        public long getMinimumSize() {
            return BasicRequestProcessor.this.largeValueMinimumSizeInBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object read(ValueFactories valueFactories, byte[] hash, long length) throws IOException {
            String hashStr = StringUtil.getHexString((byte[])hash);
            LargeValueId largeValueId = new LargeValueId(hashStr);
            LargeValueEntity entity = (LargeValueEntity)BasicRequestProcessor.this.entities.find(LargeValueEntity.class, (Object)largeValueId);
            if (entity != null) {
                byte[] data = entity.getData();
                if (entity.isCompressed()) {
                    GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(data));
                    try {
                        data = IoUtil.readBytes((InputStream)stream);
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                }
                return valueFactories.getValueFactory(entity.getType()).create(data);
            }
            throw new IOException(JpaConnectorI18n.unableToReadLargeValue.text(new Object[]{BasicRequestProcessor.this.getSourceName(), hashStr}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void write(byte[] hash, long length, PropertyType type, Object value) throws IOException {
            block20: {
                if (value == null) {
                    return;
                }
                hashStr = StringUtil.getHexString((byte[])hash);
                if (this.written != null) {
                    this.written.add(hashStr);
                }
                id = new LargeValueId(hashStr);
                for (LargeValueId existing : this.properties.getLargeValues()) {
                    if (!existing.equals(id)) continue;
                    return;
                }
                entity = (LargeValueEntity)BasicRequestProcessor.this.entities.find(LargeValueEntity.class, (Object)id);
                if (entity != null) break block20;
                entity = new LargeValueEntity();
                entity.setCompressed(true);
                entity.setId(id);
                entity.setLength(length);
                entity.setType(type);
                factories = BasicRequestProcessor.this.getExecutionContext().getValueFactories();
                bytes = null;
                switch (1.$SwitchMap$org$modeshape$graph$property$PropertyType[type.ordinal()]) {
                    case 1: {
                        binary = (Binary)factories.getBinaryFactory().create(value);
                        stream = null;
                        try {
                            binary.acquire();
                            stream = binary.getStream();
                            if (BasicRequestProcessor.this.compressData) {
                                stream = new GZIPInputStream(stream);
                            }
                            bytes = IoUtil.readBytes((InputStream)stream);
                        }
                        catch (Throwable var14_14) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            finally {
                                binary.release();
                            }
                            throw var14_14;
                        }
                        try {
                            if (stream == null) break;
                            stream.close();
                            break;
                        }
                        finally {
                            binary.release();
                        }
                    }
                    default: {
                        str = (String)factories.getStringFactory().create(value);
                        if (!BasicRequestProcessor.this.compressData) ** GOTO lbl59
                        bs = new ByteArrayOutputStream();
                        strStream = new GZIPOutputStream(bs);
                        try {
                            IoUtil.write((String)str, (OutputStream)strStream);
                        }
                        finally {
                            strStream.close();
                        }
                        bytes = bs.toByteArray();
                        break;
lbl59:
                        // 1 sources

                        bytes = str.getBytes();
                    }
                }
                entity.setData(bytes);
                BasicRequestProcessor.this.entities.persist((Object)entity);
            }
            if (!LargeValueSerializer.$assertionsDisabled && id.getHash() == null) {
                throw new AssertionError();
            }
            this.properties.getLargeValues().add(id);
        }
    }

    protected class NextChildIndexes {
        protected final int nextIndexInParent;
        protected final int nextSnsIndex;

        protected NextChildIndexes(int nextIndexInParent, int nextSnsIndex) {
            this.nextIndexInParent = nextIndexInParent;
            this.nextSnsIndex = nextSnsIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UuidConflictBehavior {
        ALWAYS_CREATE_NEW_UUID,
        REPLACE_EXISTING_NODE,
        THROW_EXCEPTION;

    }
}

