/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.HashCode;
import org.modeshape.connector.store.jpa.model.basic.ChildId;
import org.modeshape.connector.store.jpa.model.common.NamespaceEntity;

@Entity
@Table(name="DNA_BASIC_CHILDREN")
@org.hibernate.annotations.Table(appliesTo="DNA_BASIC_CHILDREN", indexes={@Index(name="CHILDINDEX_INX", columnNames={"WORKSPACE_ID", "PARENT_UUID", "CHILD_INDEX"}), @Index(name="CHILDNAME_INX", columnNames={"WORKSPACE_ID", "PARENT_UUID", "CHILD_NAME_NS_ID", "CHILD_NAME_LOCAL", "SNS_INDEX"})})
@NamedQueries(value={@NamedQuery(name="ChildEntity.findByPathSegment", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuidString AND child.childNamespace.id = :ns AND child.childName = :childName AND child.sameNameSiblingIndex = :sns"), @NamedQuery(name="ChildEntity.findAllUnderParent", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuidString order by child.indexInParent"), @NamedQuery(name="ChildEntity.findRangeUnderParent", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuidString and child.indexInParent >= :firstIndex and child.indexInParent < :afterIndex order by child.indexInParent"), @NamedQuery(name="ChildEntity.findChildrenAfterIndexUnderParent", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuidString and child.indexInParent >= :afterIndex order by child.indexInParent"), @NamedQuery(name="ChildEntity.findByChildUuid", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId and child.id.childUuidString = :childUuidString"), @NamedQuery(name="ChildEntity.findMaximumSnsIndex", query="select max(child.sameNameSiblingIndex) from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuid AND child.childNamespace.id = :ns AND child.childName = :childName"), @NamedQuery(name="ChildEntity.findMaximumChildIndex", query="select max(child.indexInParent) from ChildEntity as child where child.id.workspaceId = :workspaceId and child.parentUuidString = :parentUuid"), @NamedQuery(name="ChildEntity.findInWorkspace", query="select child from ChildEntity as child where child.id.workspaceId = :workspaceId")})
public class ChildEntity {
    @Id
    private ChildId id;
    @Column(name="PARENT_UUID", nullable=false, length=36)
    private String parentUuidString;
    @Column(name="CHILD_INDEX", nullable=false, unique=false)
    private int indexInParent;
    @ManyToOne
    @JoinColumn(name="CHILD_NAME_NS_ID", nullable=false)
    private NamespaceEntity childNamespace;
    @Column(name="CHILD_NAME_LOCAL", nullable=false, unique=false, length=512)
    private String childName;
    @Column(name="SNS_INDEX", nullable=false, unique=false)
    private int sameNameSiblingIndex;
    @Column(name="ALLOWS_SNS", nullable=false, unique=false)
    private boolean allowsSameNameChildren;

    public ChildEntity() {
    }

    public ChildEntity(ChildId id, String parentUuidString, int indexInParent, NamespaceEntity ns, String name) {
        this.id = id;
        this.parentUuidString = parentUuidString;
        this.indexInParent = indexInParent;
        this.childNamespace = ns;
        this.childName = name;
        this.sameNameSiblingIndex = 1;
    }

    public ChildEntity(ChildId id, String parentUuidString, int indexInParent, NamespaceEntity ns, String name, int sameNameSiblingIndex) {
        this.id = id;
        this.parentUuidString = parentUuidString;
        this.indexInParent = indexInParent;
        this.childNamespace = ns;
        this.childName = name;
        this.sameNameSiblingIndex = sameNameSiblingIndex;
    }

    public ChildId getId() {
        return this.id;
    }

    public void setId(ChildId childId) {
        this.id = childId;
    }

    public String getParentUuidString() {
        return this.parentUuidString;
    }

    public void setParentUuidString(String parentUuidString) {
        this.parentUuidString = parentUuidString;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public void setIndexInParent(int index) {
        this.indexInParent = index;
    }

    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String childName) {
        this.childName = childName;
    }

    public NamespaceEntity getChildNamespace() {
        return this.childNamespace;
    }

    public void setChildNamespace(NamespaceEntity childNamespace) {
        this.childNamespace = childNamespace;
    }

    public int getSameNameSiblingIndex() {
        return this.sameNameSiblingIndex;
    }

    public void setSameNameSiblingIndex(int sameNameSiblingIndex) {
        this.sameNameSiblingIndex = sameNameSiblingIndex;
    }

    public boolean getAllowsSameNameChildren() {
        return this.allowsSameNameChildren;
    }

    public void setAllowsSameNameChildren(boolean allowsSameNameChildren) {
        this.allowsSameNameChildren = allowsSameNameChildren;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildEntity) {
            ChildEntity that = (ChildEntity)obj;
            return !(this.id == null ? that.id != null : !this.id.equals(that.id));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.childNamespace != null) {
            sb.append('{').append(this.childNamespace).append("}:");
        }
        sb.append(this.childName);
        if (this.sameNameSiblingIndex > 1) {
            sb.append('[').append(this.sameNameSiblingIndex).append(']');
        }
        if (this.id != null) {
            sb.append(" (id=").append(this.id.getChildUuidString()).append(")");
            String parentId = this.getParentUuidString();
            if (parentId != null) {
                sb.append(" is ");
                sb.append(Inflector.getInstance().ordinalize(this.indexInParent));
                sb.append(" child of ");
                sb.append(parentId);
                sb.append(" in workspace ");
                sb.append(this.id.getWorkspaceId());
            } else {
                sb.append(" is root in workspace ");
                sb.append(this.id.getWorkspaceId());
            }
        }
        return sb.toString();
    }

    public static void adjustSnsIndexesAndIndexesAfterRemoving(EntityManager entities, Long workspaceId, String uuidParent, String childName, long childNamespaceIndex, int childIndex) {
        Query query = entities.createNamedQuery("ChildEntity.findChildrenAfterIndexUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)uuidParent);
        query.setParameter("afterIndex", (Object)childIndex);
        for (ChildEntity entity : query.getResultList()) {
            entity.setIndexInParent(entity.getIndexInParent() - 1);
            if (!entity.getChildName().equals(childName) || entity.getChildNamespace().getId() != childNamespaceIndex) continue;
            entity.setSameNameSiblingIndex(entity.getSameNameSiblingIndex() - 1);
        }
    }

    public static int adjustSnsIndexesAndIndexes(EntityManager entities, Long workspaceId, String uuidParent, int afterIndex, int untilIndex, long childNamespaceIndex, String childName, int modifier) {
        int snsCount = 0;
        Query query = entities.createNamedQuery("ChildEntity.findChildrenAfterIndexUnderParent");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("parentUuidString", (Object)uuidParent);
        query.setParameter("afterIndex", (Object)afterIndex);
        int index = afterIndex;
        for (ChildEntity entity : query.getResultList()) {
            if (++index > untilIndex) break;
            entity.setIndexInParent(entity.getIndexInParent() + modifier);
            if (!entity.getChildName().equals(childName) || entity.getChildNamespace().getId() != childNamespaceIndex) continue;
            entity.setSameNameSiblingIndex(entity.getSameNameSiblingIndex() + modifier);
            ++snsCount;
        }
        return snsCount;
    }
}

