/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.connector.store.jpa.model.basic.NodeId;

@Embeddable
@net.jcip.annotations.Immutable
@Immutable
public class ChildId
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="WORKSPACE_ID", nullable=false)
    private Long workspaceId;
    @Column(name="CHILD_UUID", nullable=false, length=36)
    private String childUuidString;

    public ChildId() {
    }

    public ChildId(Long workspaceId, NodeId childId) {
        this.workspaceId = workspaceId;
        if (childId != null) {
            this.childUuidString = childId.getUuidString();
        }
    }

    public ChildId(Long workspaceId, String childUuid) {
        this.workspaceId = workspaceId;
        this.childUuidString = childUuid;
    }

    public String getChildUuidString() {
        return this.childUuidString;
    }

    public Long getWorkspaceId() {
        return this.workspaceId;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.workspaceId, this.childUuidString});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildId) {
            ChildId that = (ChildId)obj;
            if (this.workspaceId == null ? that.workspaceId != null : !this.workspaceId.equals(that.workspaceId)) {
                return false;
            }
            return !(this.childUuidString == null ? that.childUuidString != null : !this.childUuidString.equals(that.childUuidString));
        }
        return false;
    }

    public String toString() {
        return "Node " + this.childUuidString + " in workspace " + this.workspaceId;
    }
}

