/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import org.modeshape.connector.store.jpa.model.basic.LargeValueId;
import org.modeshape.graph.property.PropertyType;

@Entity
@Table(name="DNA_BASIC_LARGE_VALUES")
@NamedQuery(name="LargeValueEntity.deleteUnused", query="delete LargeValueEntity value where value.id not in (select values.hash from PropertiesEntity prop join prop.largeValues values)")
public class LargeValueEntity {
    @Id
    private LargeValueId id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", nullable=false)
    private PropertyType type;
    @Column(name="LENGTH", nullable=false)
    private long length;
    @Column(name="COMPRESSED", nullable=true)
    private Boolean compressed;
    @Lob
    @Column(name="DATA", nullable=false)
    private byte[] data;

    public LargeValueId getId() {
        return this.id;
    }

    public void setId(LargeValueId id) {
        this.id = id;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isCompressed() {
        return this.compressed != null && this.compressed != false;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LargeValueEntity) {
            LargeValueEntity that = (LargeValueEntity)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Large " + this.type + " value (hash=" + this.getId().getHash() + ",compressed=" + this.isCompressed() + ")";
    }

    public static int deleteUnused(EntityManager manager) {
        assert (manager != null);
        Query delete = manager.createNamedQuery("LargeValueEntity.deleteUnused");
        int result = delete.executeUpdate();
        manager.flush();
        return result;
    }
}

