/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.util.Collection;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionOfElements;
import org.modeshape.connector.store.jpa.model.basic.LargeValueId;
import org.modeshape.connector.store.jpa.model.basic.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DNA_BASIC_NODEPROPS")
@NamedQueries(value={@NamedQuery(name="PropertiesEntity.findByUuid", query="select prop from PropertiesEntity as prop where prop.id.workspaceId = :workspaceId and prop.id.uuidString = :uuid"), @NamedQuery(name="PropertiesEntity.deleteByUuid", query="delete PropertiesEntity prop where prop.id.workspaceId = :workspaceId and prop.id.uuidString = :uuid"), @NamedQuery(name="PropertiesEntity.findInWorkspace", query="select prop from PropertiesEntity as prop where prop.id.workspaceId = :workspaceId"), @NamedQuery(name="PropertiesEntity.withLargeValues", query="select prop from PropertiesEntity as prop where prop.id.workspaceId = :workspaceId and size(prop.largeValues) > 0")})
public class PropertiesEntity {
    @Id
    private NodeId id;
    @Lob
    @Column(name="DATA", nullable=true, unique=false)
    private byte[] data;
    @Column(name="NUM_PROPS", nullable=false)
    private int propertyCount;
    @Column(name="COMPRESSED", nullable=true)
    private Boolean compressed;
    @Column(name="ENFORCEREFINTEG", nullable=false)
    private boolean referentialIntegrityEnforced = true;
    @CollectionOfElements(fetch=FetchType.LAZY)
    @JoinTable(name="ModeShape_LARGEVALUE_USAGES", joinColumns={@JoinColumn(name="WORKSPACE_ID"), @JoinColumn(name="NODE_UUID")})
    private Collection<LargeValueId> largeValues = new HashSet<LargeValueId>();

    public PropertiesEntity() {
    }

    public PropertiesEntity(NodeId id) {
        this.setId(id);
    }

    public NodeId getId() {
        return this.id;
    }

    public void setId(NodeId id) {
        this.id = id;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public void setPropertyCount(int propertyCount) {
        this.propertyCount = propertyCount;
    }

    public boolean isCompressed() {
        return this.compressed != null && this.compressed != false;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public Collection<LargeValueId> getLargeValues() {
        return this.largeValues;
    }

    public boolean isReferentialIntegrityEnforced() {
        return this.referentialIntegrityEnforced;
    }

    public void setReferentialIntegrityEnforced(boolean referentialIntegrityEnforced) {
        this.referentialIntegrityEnforced = referentialIntegrityEnforced;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertiesEntity) {
            PropertiesEntity that = (PropertiesEntity)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Properties for " + this.id;
    }

    public static int deletePropertiesFor(Long workspaceId, String uuid, EntityManager manager) {
        assert (manager != null);
        Query delete = manager.createNamedQuery("PropertiesEntity.deleteByUuid");
        delete.setParameter("uuid", (Object)uuid);
        delete.setParameter("workspaceId", (Object)workspaceId);
        int result = delete.executeUpdate();
        manager.flush();
        return result;
    }
}

