/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.modeshape.connector.store.jpa.model.basic.ReferenceId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DNA_BASIC_REFERENCES")
@org.hibernate.annotations.Table(appliesTo="DNA_BASIC_REFERENCES", indexes={@Index(name="REFINDEX_INX", columnNames={"WORKSPACE_ID", "FROM_UUID", "TO_UUID"}), @Index(name="REFTOUUID_INX", columnNames={"WORKSPACE_ID", "TO_UUID"})})
@NamedQueries(value={@NamedQuery(name="ReferenceEntity.removeReferencesFrom", query="delete ReferenceEntity where id.workspaceId = :workspaceId and id.fromUuidString = :fromUuid"), @NamedQuery(name="ReferenceEntity.removeNonEnforcedReferences", query="delete ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.fromUuidString not in ( select props.id.uuidString from PropertiesEntity props where props.referentialIntegrityEnforced = true and props.id.workspaceId = :workspaceId )"), @NamedQuery(name="ReferenceEntity.countUnresolveReferences", query="select count(*) from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString not in ( select props.id.uuidString from PropertiesEntity props where props.referentialIntegrityEnforced = true and props.id.workspaceId = :workspaceId )"), @NamedQuery(name="ReferenceEntity.getUnresolveReferences", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString not in ( select props.id.uuidString from PropertiesEntity props where props.referentialIntegrityEnforced = true and props.id.workspaceId = :workspaceId )"), @NamedQuery(name="ReferenceEntity.findInWorkspace", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId"), @NamedQuery(name="ReferenceEntity.getInwardReferencesForList", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString in (:toUuidList)")})
public class ReferenceEntity {
    @Id
    private ReferenceId id;

    public ReferenceEntity() {
    }

    public ReferenceEntity(ReferenceId id) {
        this.id = id;
    }

    public ReferenceId getId() {
        return this.id;
    }

    public void setId(ReferenceId id) {
        this.id = id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceEntity) {
            ReferenceEntity that = (ReferenceEntity)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.id.toString();
    }

    public static int deleteReferencesFrom(Long workspaceId, String uuid, EntityManager manager) {
        assert (manager != null);
        Query delete = manager.createNamedQuery("ReferenceEntity.removeReferencesFrom");
        delete.setParameter("fromUuid", (Object)uuid);
        delete.setParameter("workspaceId", (Object)workspaceId);
        int result = delete.executeUpdate();
        manager.flush();
        return result;
    }

    public static int deleteUnenforcedReferences(Long workspaceId, EntityManager manager) {
        assert (manager != null);
        Query delete = manager.createNamedQuery("ReferenceEntity.removeNonEnforcedReferences");
        delete.setParameter("workspaceId", (Object)workspaceId);
        int result = delete.executeUpdate();
        manager.flush();
        return result;
    }

    public static int countAllReferencesResolved(Long workspaceId, EntityManager manager) {
        assert (manager != null);
        Query query = manager.createNamedQuery("ReferenceEntity.getUnresolveReferences");
        query.setParameter("workspaceId", (Object)workspaceId);
        try {
            return (Integer)query.getSingleResult();
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public static List<ReferenceEntity> verifyAllReferencesResolved(Long workspaceId, EntityManager manager) {
        assert (manager != null);
        Query query = manager.createNamedQuery("ReferenceEntity.getUnresolveReferences");
        query.setParameter("workspaceId", (Object)workspaceId);
        return query.getResultList();
    }

    public static List<ReferenceEntity> getReferencesToUuids(Long workspaceId, Collection<String> uuids, EntityManager manager) {
        assert (manager != null);
        Query query = manager.createNamedQuery("ReferenceEntity.getInwardReferencesForList");
        query.setParameter("workspaceId", (Object)workspaceId);
        query.setParameter("toUuidList", uuids);
        return query.getResultList();
    }
}

