/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Immutable;
import org.modeshape.common.util.HashCode;

@Embeddable
@net.jcip.annotations.Immutable
@Immutable
public class ReferenceId
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="WORKSPACE_ID", nullable=false)
    private Long workspaceId;
    @Column(name="FROM_UUID", nullable=false, updatable=false, length=36)
    private String fromUuidString;
    @Column(name="TO_UUID", nullable=false, updatable=false, length=36)
    private String toUuidString;

    public ReferenceId() {
    }

    public ReferenceId(Long workspaceId, String fromUuid, String toUuid) {
        this.workspaceId = workspaceId;
        this.fromUuidString = fromUuid;
        this.toUuidString = toUuid;
    }

    public String getFromUuidString() {
        return this.fromUuidString;
    }

    public String getToUuidString() {
        return this.toUuidString;
    }

    public Long getWorkspaceId() {
        return this.workspaceId;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.fromUuidString, this.toUuidString});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceId) {
            ReferenceId that = (ReferenceId)obj;
            if (this.workspaceId == null ? that.workspaceId != null : !this.workspaceId.equals(that.workspaceId)) {
                return false;
            }
            if (this.fromUuidString == null ? that.fromUuidString != null : !this.fromUuidString.equals(that.fromUuidString)) {
                return false;
            }
            return !(this.toUuidString == null ? that.toUuidString != null : !this.toUuidString.equals(that.toUuidString));
        }
        return false;
    }

    public String toString() {
        return "Reference from " + this.fromUuidString + " to " + this.toUuidString + " in workspace " + this.workspaceId;
    }
}

