/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.Index;

@Entity
@Table(name="DNA_SUBGRAPH_NODES")
@org.hibernate.annotations.Table(appliesTo="DNA_SUBGRAPH_NODES", indexes={@Index(name="QUERYID_INX", columnNames={"QUERY_ID", "UUID"})})
@NamedQueries(value={@NamedQuery(name="SubgraphNodeEntity.insertChildren", query="insert into SubgraphNodeEntity(queryId,nodeUuid,depth,parentIndexInParent,indexInParent) select parentNode.queryId, child.id.childUuidString, parentNode.depth+1, parentNode.indexInParent, child.indexInParent from ChildEntity child, SubgraphNodeEntity parentNode where child.id.workspaceId = :workspaceId and child.parentUuidString = parentNode.nodeUuid and parentNode.queryId = :queryId and parentNode.depth = :parentDepth"), @NamedQuery(name="SubgraphNodeEntity.getCount", query="select count(*) from SubgraphNodeEntity where queryId = :queryId"), @NamedQuery(name="SubgraphNodeEntity.getPropertiesEntities", query="select props from PropertiesEntity props, SubgraphNodeEntity node where props.id.workspaceId = :workspaceId and props.id.uuidString = node.nodeUuid and node.queryId = :queryId and node.depth >= :depth and node.depth <= :maxDepth order by node.depth, node.parentIndexInParent, node.indexInParent"), @NamedQuery(name="SubgraphNodeEntity.getPropertiesEntitiesWithLargeValues", query="select props from PropertiesEntity props, SubgraphNodeEntity node where props.id.workspaceId = :workspaceId and props.id.uuidString = node.nodeUuid and node.queryId = :queryId and node.depth >= :depth and size(props.largeValues) > 0"), @NamedQuery(name="SubgraphNodeEntity.getChildEntities", query="select child from ChildEntity child, SubgraphNodeEntity node where child.id.workspaceId = :workspaceId and child.id.childUuidString = node.nodeUuid and node.queryId = :queryId and node.depth >= :depth and node.depth <= :maxDepth order by node.depth, node.parentIndexInParent, node.indexInParent"), @NamedQuery(name="SubgraphNodeEntity.getInternalReferences", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId) and ref.id.fromUuidString in (select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId)"), @NamedQuery(name="SubgraphNodeEntity.getOutwardReferences", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString not in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId) and ref.id.fromUuidString in (select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId)"), @NamedQuery(name="SubgraphNodeEntity.getInwardReferences", query="select ref from ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.toUuidString in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId) and ref.id.fromUuidString not in (select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId)"), @NamedQuery(name="SubgraphNodeEntity.deletePropertiesEntities", query="delete PropertiesEntity props where props.id.workspaceId = :workspaceId and props.id.uuidString in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId )"), @NamedQuery(name="SubgraphNodeEntity.deleteChildEntities", query="delete ChildEntity child where child.id.workspaceId = :workspaceId and child.id.childUuidString in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId )"), @NamedQuery(name="SubgraphNodeEntity.deleteReferences", query="delete ReferenceEntity as ref where ref.id.workspaceId = :workspaceId and ref.id.fromUuidString in ( select node.nodeUuid from SubgraphNodeEntity node where node.queryId = :queryId )"), @NamedQuery(name="SubgraphNodeEntity.deleteByQueryId", query="delete SubgraphNodeEntity where queryId = :queryId")})
public class SubgraphNodeEntity {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="QUERY_ID", nullable=false, unique=false, updatable=false)
    private Long queryId;
    @Column(name="UUID", updatable=false, nullable=false, length=36)
    private String nodeUuid;
    @Column(name="DEPTH", updatable=false, nullable=false)
    private int depth;
    @Column(name="PARENT_NUM", updatable=false, nullable=false)
    private int parentIndexInParent;
    @Column(name="CHILD_NUM", updatable=false, nullable=false)
    private int indexInParent;

    public SubgraphNodeEntity() {
    }

    public SubgraphNodeEntity(Long queryId, String nodeUuid, int depth) {
        this.queryId = queryId;
        this.nodeUuid = nodeUuid;
        this.depth = depth;
    }

    public Long getId() {
        return this.id;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getNodeUuid() {
        return this.nodeUuid;
    }

    public Long getQueryId() {
        return this.queryId;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public int getParentIndexInParent() {
        return this.parentIndexInParent;
    }

    public int hashCode() {
        return this.id != null ? this.id.intValue() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubgraphNodeEntity) {
            SubgraphNodeEntity that = (SubgraphNodeEntity)obj;
            if (this.id.equals(that.id)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "" + this.id + " - Query " + this.queryId + "; depth=" + this.depth + "; node=" + this.nodeUuid + " at index " + this.indexInParent;
    }
}

