/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.basic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.modeshape.connector.store.jpa.model.basic.ChildEntity;
import org.modeshape.connector.store.jpa.model.basic.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.basic.PropertiesEntity;
import org.modeshape.connector.store.jpa.model.basic.ReferenceEntity;
import org.modeshape.connector.store.jpa.model.basic.SubgraphNodeEntity;
import org.modeshape.connector.store.jpa.model.basic.SubgraphQueryEntity;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubgraphQuery {
    private final ExecutionContext context;
    private final EntityManager manager;
    private final Long workspaceId;
    private SubgraphQueryEntity query;
    private final int maxDepth;
    private final Path subgraphRootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubgraphQuery create(ExecutionContext context, EntityManager entities, Long workspaceId, UUID subgraphRootUuid, Path subgraphRootPath, int maxDepth) {
        assert (entities != null);
        assert (subgraphRootUuid != null);
        assert (workspaceId != null);
        assert (maxDepth >= 0);
        if (maxDepth == 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        String subgraphRootUuidString = subgraphRootUuid.toString();
        SubgraphQueryEntity query = new SubgraphQueryEntity(workspaceId, subgraphRootUuidString);
        entities.persist((Object)query);
        Long queryId = query.getId();
        try {
            SubgraphNodeEntity root = new SubgraphNodeEntity(queryId, subgraphRootUuidString, 0);
            entities.persist((Object)root);
            Query statement = entities.createNamedQuery("SubgraphNodeEntity.insertChildren");
            int numChildrenInserted = 0;
            for (int parentLevel = 0; parentLevel <= maxDepth; ++parentLevel) {
                statement.setParameter("queryId", (Object)queryId);
                statement.setParameter("workspaceId", (Object)workspaceId);
                statement.setParameter("parentDepth", (Object)parentLevel);
                numChildrenInserted = statement.executeUpdate();
                if (numChildrenInserted != 0) {
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException t) {
            try {
                Query search = entities.createNamedQuery("SubgraphNodeEntity.deleteByQueryId");
                search.setParameter("queryId", (Object)query.getId());
                search.executeUpdate();
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                entities.remove((Object)query);
                throw throwable;
            }
            entities.remove((Object)query);
            throw t;
        }
        return new SubgraphQuery(context, entities, workspaceId, query, subgraphRootPath, maxDepth);
    }

    protected SubgraphQuery(ExecutionContext context, EntityManager manager, Long workspaceId, SubgraphQueryEntity query, Path subgraphRootPath, int maxDepth) {
        assert (manager != null);
        assert (query != null);
        assert (context != null);
        assert (subgraphRootPath != null);
        assert (workspaceId != null);
        this.context = context;
        this.manager = manager;
        this.workspaceId = workspaceId;
        this.query = query;
        this.maxDepth = maxDepth;
        this.subgraphRootPath = subgraphRootPath;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public EntityManager getEntityManager() {
        return this.manager;
    }

    public Path getSubgraphRootPath() {
        return this.subgraphRootPath;
    }

    public SubgraphQueryEntity getSubgraphQueryEntity() {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        return this.query;
    }

    public int getNodeCount(boolean includeRoot) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getCount");
        search.setParameter("queryId", (Object)this.query.getId());
        try {
            return (Integer)search.getSingleResult() - (includeRoot ? 0 : 1);
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    public ChildEntity getNode() {
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getChildEntities");
        search.setParameter("queryId", (Object)this.query.getId());
        search.setParameter("workspaceId", (Object)this.workspaceId);
        search.setParameter("depth", (Object)0);
        search.setParameter("maxDepth", (Object)0);
        return (ChildEntity)search.getSingleResult();
    }

    public List<ChildEntity> getNodes(boolean includeRoot, boolean includeChildrenOfMaxDepthNodes) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getChildEntities");
        search.setParameter("queryId", (Object)this.query.getId());
        search.setParameter("workspaceId", (Object)this.workspaceId);
        search.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        search.setParameter("maxDepth", (Object)(includeChildrenOfMaxDepthNodes ? this.maxDepth : this.maxDepth - 1));
        return search.getResultList();
    }

    public List<PropertiesEntity> getProperties(boolean includeRoot, boolean includeChildrenOfMaxDepthNodes) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getPropertiesEntities");
        search.setParameter("queryId", (Object)this.query.getId());
        search.setParameter("workspaceId", (Object)this.workspaceId);
        search.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        search.setParameter("maxDepth", (Object)(includeChildrenOfMaxDepthNodes ? this.maxDepth : this.maxDepth - 1));
        return search.getResultList();
    }

    public List<Location> getNodeLocations(boolean includeRoot, boolean includeChildrenOfMaxDepthNodes) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        HashMap<String, Path> pathByUuid = new HashMap<String, Path>();
        LinkedList<Location> locations = new LinkedList<Location>();
        String subgraphRootUuid = this.query.getRootUuid();
        pathByUuid.put(subgraphRootUuid, this.subgraphRootPath);
        UUID uuid = UUID.fromString(subgraphRootUuid);
        if (includeRoot) {
            locations.add(Location.create((Path)this.subgraphRootPath, (UUID)uuid));
        }
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        NameFactory nameFactory = this.context.getValueFactories().getNameFactory();
        for (ChildEntity entity : this.getNodes(false, includeChildrenOfMaxDepthNodes)) {
            String parentUuid = entity.getParentUuidString();
            Path parentPath = (Path)pathByUuid.get(parentUuid);
            assert (parentPath != null);
            String nsUri = entity.getChildNamespace().getUri();
            String localName = entity.getChildName();
            int sns = entity.getSameNameSiblingIndex();
            Name childName = nameFactory.create(nsUri, localName);
            Path childPath = pathFactory.create(parentPath, childName, sns);
            String childUuid = entity.getId().getChildUuidString();
            pathByUuid.put(childUuid, childPath);
            uuid = UUID.fromString(childUuid);
            locations.add(Location.create((Path)childPath, (UUID)uuid));
        }
        return locations;
    }

    public List<ReferenceEntity> getInternalReferences() {
        Query references = this.manager.createNamedQuery("SubgraphNodeEntity.getInternalReferences");
        references.setParameter("queryId", (Object)this.query.getId());
        references.setParameter("workspaceId", (Object)this.workspaceId);
        return references.getResultList();
    }

    public List<ReferenceEntity> getOutwardReferences() {
        Query references = this.manager.createNamedQuery("SubgraphNodeEntity.getOutwardReferences");
        references.setParameter("queryId", (Object)this.query.getId());
        references.setParameter("workspaceId", (Object)this.workspaceId);
        return references.getResultList();
    }

    public List<ReferenceEntity> getInwardReferences() {
        Query references = this.manager.createNamedQuery("SubgraphNodeEntity.getInwardReferences");
        references.setParameter("queryId", (Object)this.query.getId());
        references.setParameter("workspaceId", (Object)this.workspaceId);
        return references.getResultList();
    }

    public void deleteSubgraph(boolean includeRoot) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        Query withLargeValues = this.manager.createNamedQuery("SubgraphNodeEntity.getPropertiesEntitiesWithLargeValues");
        withLargeValues.setParameter("queryId", (Object)this.query.getId());
        withLargeValues.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        withLargeValues.setParameter("workspaceId", (Object)this.workspaceId);
        List propertiesWithLargeValues = withLargeValues.getResultList();
        if (propertiesWithLargeValues.size() != 0) {
            for (PropertiesEntity props : propertiesWithLargeValues) {
                props.getLargeValues().clear();
            }
            this.manager.flush();
        }
        Query delete = this.manager.createNamedQuery("SubgraphNodeEntity.deletePropertiesEntities");
        delete.setParameter("queryId", (Object)this.query.getId());
        delete.setParameter("workspaceId", (Object)this.workspaceId);
        delete.executeUpdate();
        delete = this.manager.createNamedQuery("SubgraphNodeEntity.deleteChildEntities");
        delete.setParameter("queryId", (Object)this.query.getId());
        delete.setParameter("workspaceId", (Object)this.workspaceId);
        delete.executeUpdate();
        delete = this.manager.createNamedQuery("SubgraphNodeEntity.deleteReferences");
        delete.setParameter("queryId", (Object)this.query.getId());
        delete.setParameter("workspaceId", (Object)this.workspaceId);
        delete.executeUpdate();
        LargeValueEntity.deleteUnused(this.manager);
        this.manager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.query == null) {
            return;
        }
        try {
            Query search = this.manager.createNamedQuery("SubgraphNodeEntity.deleteByQueryId");
            search.setParameter("queryId", (Object)this.query.getId());
            search.executeUpdate();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.manager.remove((Object)this.query);
                Object var5_6 = null;
                this.query = null;
            }
            catch (Throwable throwable2) {
                Object var5_7 = null;
                this.query = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.manager.remove((Object)this.query);
            Object var5_4 = null;
            this.query = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.query = null;
            throw throwable;
        }
    }
}

