/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.model.simple.SimpleJpaRepository;
import org.modeshape.connector.store.jpa.model.simple.SimpleRequestProcessor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.map.MapRepositoryTransaction;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.Request;

@NotThreadSafe
public class SimpleJpaConnection
implements RepositoryConnection {
    private SimpleJpaRepository repository;
    private final JpaSource source;
    private EntityManager entityManager;

    public SimpleJpaConnection(JpaSource source) {
        this.source = source;
    }

    public boolean ping(long time, TimeUnit unit) {
        return this.entityManager == null || this.entityManager.isOpen();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getCachePolicy();
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public XAResource getXAResource() {
        return null;
    }

    private void acquireRepository() {
        this.entityManager = this.source.getEntityManagers().checkout();
        this.entityManager.getTransaction().begin();
        this.repository = new SimpleJpaRepository(this.source.getName(), this.source.getRootUuid(), this.source.getDefaultWorkspaceName(), this.source.getPredefinedWorkspaceNames(), this.entityManager, this.source.getRepositoryContext().getExecutionContext(), this.source.isCompressData(), this.source.isCreatingWorkspacesAllowed(), this.source.getLargeValueSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRepository() {
        this.repository = null;
        if (this.entityManager != null) {
            try {
                this.source.getEntityManagers().checkin(this.entityManager);
                Object var2_1 = null;
                this.entityManager = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.entityManager = null;
                throw throwable;
            }
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Logger logger = context.getLogger(this.getClass());
        Stopwatch sw = null;
        if (logger.isTraceEnabled()) {
            sw = new Stopwatch();
            sw.start();
        }
        this.acquireRepository();
        Observer observer = this.source.getRepositoryContext().getObserver();
        SimpleRequestProcessor processor = new SimpleRequestProcessor(context, this.repository, observer, this.source.areUpdatesAllowed());
        boolean commit = true;
        MapRepositoryTransaction txn = this.repository.startTransaction(request.isReadOnly());
        try {
            processor.process(request);
            if (request.hasError() && !request.isReadOnly()) {
                commit = false;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                processor.close();
                Object var12_13 = null;
            }
            catch (Throwable throwable2) {
                Object var12_14 = null;
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable2;
            }
            try {
                if (commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
            throw throwable;
        }
        try {
            processor.close();
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                if (commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
            throw throwable;
        }
        try {
            if (commit) {
                txn.commit();
            } else {
                txn.rollback();
            }
        }
        catch (Throwable commitOrRollbackError) {
            if (commit && !request.hasError()) {
                request.setError(commitOrRollbackError);
            }
            commit = false;
        }
        if (commit) {
            processor.notifyObserverOfChanges();
        }
        this.releaseRepository();
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace(this.getClass().getSimpleName() + ".execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }
}

