/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.model.common.WorkspaceEntity;
import org.modeshape.connector.store.jpa.model.simple.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.simple.NodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SimpleJpaTransaction;
import org.modeshape.connector.store.jpa.model.simple.SubgraphQuery;
import org.modeshape.connector.store.jpa.util.Namespaces;
import org.modeshape.connector.store.jpa.util.Serializer;
import org.modeshape.connector.store.jpa.util.Workspaces;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.map.AbstractMapWorkspace;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapRepository;
import org.modeshape.graph.connector.map.MapRepositoryTransaction;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.request.LockBranchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJpaRepository
extends MapRepository {
    protected final EntityManager entityManager;
    protected final Workspaces workspaceEntities;
    protected final Namespaces namespaceEntities;
    protected final ExecutionContext context;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    private final List<String> predefinedWorkspaceNames;
    protected final boolean compressData;
    protected final boolean creatingWorkspacesAllowed;
    protected final long minimumSizeOfLargeValuesInBytes;

    public SimpleJpaRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName, String[] predefinedWorkspaceNames, EntityManager entityManager, ExecutionContext context, boolean compressData, boolean creatingWorkspacesAllowed, long minimumSizeOfLargeValuesInBytes) {
        super(sourceName, rootNodeUuid, defaultWorkspaceName);
        this.context = context;
        ValueFactories valueFactories = context.getValueFactories();
        this.nameFactory = valueFactories.getNameFactory();
        this.pathFactory = valueFactories.getPathFactory();
        this.predefinedWorkspaceNames = Arrays.asList(predefinedWorkspaceNames);
        this.compressData = compressData;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.minimumSizeOfLargeValuesInBytes = minimumSizeOfLargeValuesInBytes;
        this.entityManager = entityManager;
        this.workspaceEntities = new Workspaces(entityManager);
        this.namespaceEntities = new Namespaces(entityManager);
        super.initialize();
    }

    public SimpleJpaRepository(String sourceName, UUID rootNodeUuid, EntityManager entityManager, ExecutionContext context, boolean compressData, boolean creatingWorkspacesAllowed, long minimumSizeOfLargeValuesInBytes) {
        super(sourceName, rootNodeUuid);
        this.context = context;
        ValueFactories valueFactories = context.getValueFactories();
        this.nameFactory = valueFactories.getNameFactory();
        this.pathFactory = valueFactories.getPathFactory();
        this.predefinedWorkspaceNames = Collections.emptyList();
        this.compressData = compressData;
        this.creatingWorkspacesAllowed = creatingWorkspacesAllowed;
        this.minimumSizeOfLargeValuesInBytes = minimumSizeOfLargeValuesInBytes;
        this.entityManager = entityManager;
        this.workspaceEntities = new Workspaces(entityManager);
        this.namespaceEntities = new Namespaces(entityManager);
        super.initialize();
    }

    final boolean creatingWorkspacesAllowed() {
        return this.creatingWorkspacesAllowed;
    }

    protected MapWorkspace createWorkspace(ExecutionContext context, String name) {
        WorkspaceEntity entity = this.workspaceEntities.get(name, false);
        if (entity != null) {
            return new Workspace(this, name, entity.getId().intValue());
        }
        entity = this.workspaceEntities.create(name);
        this.entityManager.flush();
        Workspace workspace = new Workspace(this, name, entity.getId().intValue());
        workspace.createRootNode();
        return workspace;
    }

    public MapWorkspace getWorkspace(String name) {
        WorkspaceEntity entity;
        MapWorkspace workspace = super.getWorkspace(name);
        if (workspace != null) {
            return workspace;
        }
        if (name == null) {
            name = this.getDefaultWorkspaceName();
        }
        if ((entity = this.workspaceEntities.get(name, false)) == null) {
            if (this.predefinedWorkspaceNames.contains(name)) {
                return this.createWorkspace(this.context, name);
            }
            return null;
        }
        return new Workspace(this, name, entity.getId());
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> workspaceNames = new HashSet<String>(super.getWorkspaceNames());
        workspaceNames.addAll(this.predefinedWorkspaceNames);
        return workspaceNames;
    }

    public MapRepositoryTransaction startTransaction(boolean readonly) {
        EntityTransaction txn = this.entityManager.getTransaction();
        return new SimpleJpaTransaction(txn);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$modeshape$graph$property$PropertyType;

        static {
            $SwitchMap$org$modeshape$graph$property$PropertyType = new int[PropertyType.values().length];
            try {
                1.$SwitchMap$org$modeshape$graph$property$PropertyType[PropertyType.BINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$modeshape$graph$property$PropertyType[PropertyType.URI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LargeValueSerializer
    implements Serializer.LargeValues {
        private final NodeEntity node;
        private final Set<String> written;

        public LargeValueSerializer(NodeEntity entity) {
            this.node = entity;
            this.written = null;
        }

        public LargeValueSerializer(NodeEntity entity, Set<String> written) {
            this.node = entity;
            this.written = written;
        }

        @Override
        public long getMinimumSize() {
            return SimpleJpaRepository.this.minimumSizeOfLargeValuesInBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object read(ValueFactories valueFactories, byte[] hash, long length) throws IOException {
            String hashStr = StringUtil.getHexString((byte[])hash);
            LargeValueEntity entity = (LargeValueEntity)SimpleJpaRepository.this.entityManager.find(LargeValueEntity.class, (Object)hashStr);
            if (entity != null) {
                byte[] data = entity.getData();
                if (entity.isCompressed()) {
                    GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(data));
                    try {
                        data = IoUtil.readBytes((InputStream)stream);
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                }
                return valueFactories.getValueFactory(entity.getType()).create(data);
            }
            throw new IOException(JpaConnectorI18n.unableToReadLargeValue.text(new Object[]{SimpleJpaRepository.this.getSourceName(), hashStr}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void write(byte[] hash, long length, PropertyType type, Object value) throws IOException {
            block20: {
                if (value == null) {
                    return;
                }
                hashStr = StringUtil.getHexString((byte[])hash);
                if (this.written != null) {
                    this.written.add(hashStr);
                }
                for (LargeValueEntity existing : this.node.getLargeValues()) {
                    if (!existing.getHash().equals(hashStr)) continue;
                    return;
                }
                entity = (LargeValueEntity)SimpleJpaRepository.this.entityManager.find(LargeValueEntity.class, (Object)hashStr);
                if (entity != null) break block20;
                entity = new LargeValueEntity();
                entity.setCompressed(SimpleJpaRepository.this.compressData);
                entity.setHash(hashStr);
                entity.setLength(length);
                entity.setType(type);
                factories = SimpleJpaRepository.this.context.getValueFactories();
                bytes = null;
                switch (1.$SwitchMap$org$modeshape$graph$property$PropertyType[type.ordinal()]) {
                    case 1: {
                        binary = (Binary)factories.getBinaryFactory().create(value);
                        stream = null;
                        try {
                            binary.acquire();
                            stream = binary.getStream();
                            if (SimpleJpaRepository.this.compressData) {
                                stream = new GZIPInputStream(stream);
                            }
                            bytes = IoUtil.readBytes((InputStream)stream);
                        }
                        catch (Throwable var13_13) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            finally {
                                binary.release();
                            }
                            throw var13_13;
                        }
                        try {
                            if (stream == null) break;
                            stream.close();
                            break;
                        }
                        finally {
                            binary.release();
                        }
                    }
                    default: {
                        str = (String)factories.getStringFactory().create(value);
                        if (!SimpleJpaRepository.this.compressData) ** GOTO lbl58
                        bs = new ByteArrayOutputStream();
                        strStream = new GZIPOutputStream(bs);
                        try {
                            IoUtil.write((String)str, (OutputStream)strStream);
                        }
                        finally {
                            strStream.close();
                        }
                        bytes = bs.toByteArray();
                        break;
lbl58:
                        // 1 sources

                        bytes = str.getBytes();
                    }
                }
                entity.setData(bytes);
                SimpleJpaRepository.this.entityManager.persist((Object)entity);
            }
            if (!LargeValueSerializer.$assertionsDisabled && entity.getHash() == null) {
                throw new AssertionError();
            }
            this.node.getLargeValues().add(entity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected class JpaNode
    implements MapNode {
        private final NodeEntity entity;
        private Map<Name, Property> properties = null;

        protected JpaNode(NodeEntity entity) {
            this.entity = entity;
        }

        public JpaNode(UUID uuid) {
            this.entity = new NodeEntity();
            this.entity.setNodeUuidString(uuid.toString());
        }

        private final JpaNode jpaNodeFor(MapNode node) {
            if (!(node instanceof JpaNode)) {
                throw new IllegalStateException();
            }
            return (JpaNode)node;
        }

        public void addChild(int index, MapNode child) {
            this.entity.addChild(index, this.jpaNodeFor((MapNode)child).entity);
        }

        public void addChild(MapNode child) {
            this.entity.addChild(this.jpaNodeFor((MapNode)child).entity);
        }

        public List<MapNode> getChildren() {
            ArrayList<JpaNode> children = new ArrayList<JpaNode>(this.entity.getChildren().size());
            for (NodeEntity child : this.entity.getChildren()) {
                children.add(new JpaNode(child));
            }
            return Collections.unmodifiableList(children);
        }

        public Path.Segment getName() {
            return SimpleJpaRepository.this.pathFactory.createSegment(SimpleJpaRepository.this.nameFactory.create(this.entity.getChildNamespace().getUri(), this.entity.getChildName()), this.entity.getSameNameSiblingIndex());
        }

        public MapNode getParent() {
            if (this.entity.getParent() == null) {
                return null;
            }
            return new JpaNode(this.entity.getParent());
        }

        private void ensurePropertiesLoaded() {
            if (this.properties != null) {
                return;
            }
            LinkedList<Property> propsCollection = new LinkedList<Property>();
            if (this.entity.getData() != null) {
                Serializer serializer = new Serializer(SimpleJpaRepository.this.context, true);
                ObjectInputStream ois = null;
                try {
                    LargeValueSerializer largeValues = new LargeValueSerializer(this.entity);
                    ois = new ObjectInputStream(new ByteArrayInputStream(this.entity.getData()));
                    serializer.deserializeAllProperties(ois, propsCollection, largeValues);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException(cnfe);
                }
                finally {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception ex) {}
                }
            }
            PropertyFactory propertyFactory = SimpleJpaRepository.this.context.getPropertyFactory();
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            properties.put(ModeShapeLexicon.UUID, propertyFactory.create(ModeShapeLexicon.UUID, new Object[]{this.getUuid()}));
            for (Property prop : propsCollection) {
                properties.put(prop.getName(), prop);
            }
            this.properties = properties;
        }

        private void serializeProperties() {
            Serializer serializer = new Serializer(SimpleJpaRepository.this.context, true);
            ObjectOutputStream oos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                LargeValueSerializer largeValues = new LargeValueSerializer(this.entity);
                int numberOfPropertiesToSerialize = this.properties.size() - 1;
                serializer.serializeProperties(oos, numberOfPropertiesToSerialize, this.properties.values(), largeValues, Serializer.NO_REFERENCES_VALUES);
                oos.flush();
                this.entity.setData(baos.toByteArray());
                this.entity.setPropertyCount(this.properties.size());
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception ignore) {}
            }
        }

        public MapNode removeProperty(Name propertyName) {
            this.ensurePropertiesLoaded();
            if (this.properties.containsKey(propertyName)) {
                this.properties.remove(propertyName);
                this.serializeProperties();
            }
            return this;
        }

        public Map<Name, Property> getProperties() {
            this.ensurePropertiesLoaded();
            return this.properties;
        }

        public Property getProperty(ExecutionContext context, String name) {
            return this.getProperty((Name)context.getValueFactories().getNameFactory().create(name));
        }

        public Property getProperty(Name name) {
            this.ensurePropertiesLoaded();
            return this.properties.get(name);
        }

        public Set<Name> getUniqueChildNames() {
            List<NodeEntity> children = this.entity.getChildren();
            HashSet<Name> uniqueNames = new HashSet<Name>(children.size());
            for (NodeEntity child : children) {
                uniqueNames.add(SimpleJpaRepository.this.nameFactory.create(child.getChildNamespace().getUri(), child.getChildName()));
            }
            return uniqueNames;
        }

        public UUID getUuid() {
            if (this.entity.getNodeUuidString() == null) {
                return null;
            }
            return UUID.fromString(this.entity.getNodeUuidString());
        }

        public boolean removeChild(MapNode child) {
            List<NodeEntity> children = this.entity.getChildren();
            int index = -1;
            String childUuidString = this.jpaNodeFor((MapNode)child).entity.getNodeUuidString();
            for (int i = 0; i < children.size(); ++i) {
                if (!childUuidString.equals(children.get(i).getNodeUuidString())) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return false;
            }
            this.entity.removeChild(index);
            assert (!this.entity.getChildren().contains(child));
            assert (child.getParent() == null);
            return true;
        }

        public void clearChildren() {
            this.entity.getChildren().clear();
        }

        public void setName(Path.Segment name) {
            this.entity.setChildNamespace(SimpleJpaRepository.this.namespaceEntities.get(name.getName().getNamespaceUri(), true));
            this.entity.setChildName(name.getName().getLocalName());
            this.entity.setSameNameSiblingIndex(name.getIndex());
        }

        public void setParent(MapNode parent) {
            if (parent == null) {
                this.entity.setParent(null);
            } else {
                this.entity.setParent(this.jpaNodeFor((MapNode)parent).entity);
            }
        }

        public MapNode setProperty(ExecutionContext context, String name, Object ... values) {
            PropertyFactory propertyFactory = context.getPropertyFactory();
            return this.setProperty(propertyFactory.create((Name)SimpleJpaRepository.this.nameFactory.create(name), values));
        }

        public MapNode setProperty(Property property) {
            this.ensurePropertiesLoaded();
            this.properties.put(property.getName(), property);
            this.serializeProperties();
            return this;
        }

        public MapNode setProperties(Iterable<Property> properties) {
            this.ensurePropertiesLoaded();
            for (Property property : properties) {
                this.properties.put(property.getName(), property);
            }
            this.serializeProperties();
            return this;
        }

        public String toString() {
            if (this.entity.getNodeUuidString().equals(SimpleJpaRepository.this.rootNodeUuid.toString())) {
                return "<root>";
            }
            return this.getName().getString() + " (" + this.entity.getNodeUuidString() + ")";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JpaNode)) {
                return false;
            }
            JpaNode other = (JpaNode)obj;
            return this.entity.getNodeUuidString().equals(other.entity.getNodeUuidString());
        }

        public int hashCode() {
            return this.entity.getNodeUuidString().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Workspace
    extends AbstractMapWorkspace {
        private final long workspaceId;
        private final Map<Path, MapNode> nodesByPath;

        public Workspace(MapRepository repository, String name, long workspaceId) {
            super(repository, name);
            this.nodesByPath = new HashMap<Path, MapNode>();
            this.workspaceId = workspaceId;
        }

        void createRootNode() {
            this.initialize();
        }

        public MapNode copyNode(ExecutionContext context, MapNode original, MapWorkspace newWorkspace, MapNode newParent, Name desiredName, boolean recursive) {
            HashMap oldToNewUuids = new HashMap();
            MapNode copyRoot = this.copyNode(context, original, newWorkspace, newParent, desiredName, true, oldToNewUuids);
            PropertyFactory propertyFactory = context.getPropertyFactory();
            UuidFactory uuidFactory = context.getValueFactories().getUuidFactory();
            ValueFactory referenceFactory = context.getValueFactories().getReferenceFactory();
            boolean refChanged = false;
            for (Map.Entry oldToNew : oldToNewUuids.entrySet()) {
                JpaNode oldNode = this.getNode((UUID)oldToNew.getKey());
                MapNode newNode = newWorkspace.getNode((UUID)oldToNew.getValue());
                assert (oldNode != null);
                assert (newNode != null);
                for (Map.Entry entry : newNode.getProperties().entrySet()) {
                    Property property = (Property)entry.getValue();
                    ArrayList<Object> newValues = new ArrayList<Object>();
                    boolean foundReference = false;
                    Iterator iter = property.getValues();
                    while (iter.hasNext()) {
                        Object value = iter.next();
                        PropertyType type = PropertyType.discoverType(value);
                        if (type == PropertyType.REFERENCE) {
                            UUID oldReferencedUuid = (UUID)uuidFactory.create(value);
                            UUID newReferencedUuid = (UUID)oldToNewUuids.get(oldReferencedUuid);
                            if (newReferencedUuid == null) continue;
                            newValues.add(referenceFactory.create(newReferencedUuid));
                            foundReference = true;
                            refChanged = true;
                            continue;
                        }
                        newValues.add(value);
                    }
                    if (!foundReference) continue;
                    Property newProperty = propertyFactory.create(property.getName(), newValues);
                    entry.setValue(newProperty);
                }
                if (!refChanged) continue;
                ((JpaNode)newNode).serializeProperties();
            }
            return copyRoot;
        }

        protected void correctSameNameSiblingIndexes(ExecutionContext context, MapNode parentNode, Name name) {
            int snsIndex = 1;
            int parentIndex = 0;
            List children = parentNode.getChildren();
            for (MapNode child : children) {
                NodeEntity childNode = ((JpaNode)child).entity;
                if (parentIndex != childNode.getIndexInParent()) {
                    childNode.setIndexInParent(parentIndex);
                }
                if (name.equals(child.getName().getName())) {
                    if (snsIndex != childNode.getSameNameSiblingIndex()) {
                        childNode.setSameNameSiblingIndex(snsIndex);
                    }
                    ++snsIndex;
                }
                ++parentIndex;
            }
        }

        protected void addNodeToMap(MapNode node) {
            assert (node != null);
            NodeEntity nodeEntity = ((JpaNode)node).entity;
            nodeEntity.setWorkspaceId(this.workspaceId);
            nodeEntity.setReferentialIntegrityEnforced(false);
            SimpleJpaRepository.this.entityManager.persist((Object)nodeEntity);
        }

        protected MapNode removeNodeFromMap(UUID nodeUuid) {
            throw new IllegalStateException("This code should be unreachable");
        }

        protected void removeUuidReference(MapNode node) {
            SubgraphQuery branch = SubgraphQuery.create(SimpleJpaRepository.this.entityManager, this.workspaceId, node.getUuid(), 0);
            branch.deleteSubgraph(true);
            branch.close();
        }

        protected MapNode createMapNode(UUID uuid) {
            return new JpaNode(uuid);
        }

        protected void removeAllNodesFromMap() {
            Query query = SimpleJpaRepository.this.entityManager.createQuery("NodeEntity.deleteAllInWorkspace");
            query.setParameter("workspaceId", (Object)this.workspaceId);
            query.executeUpdate();
        }

        public JpaNode getNode(UUID nodeUuid) {
            assert (nodeUuid != null);
            Query query = SimpleJpaRepository.this.entityManager.createNamedQuery("NodeEntity.findByNodeUuid");
            query.setParameter("workspaceId", (Object)this.workspaceId);
            query.setParameter("nodeUuidString", (Object)nodeUuid.toString());
            try {
                NodeEntity result = (NodeEntity)query.getSingleResult();
                return new JpaNode(result);
            }
            catch (NoResultException e) {
                return null;
            }
        }

        public MapNode getNode(Path path) {
            MapNode node = this.nodesByPath.get(path);
            if (node != null) {
                return node;
            }
            node = super.getNode(path);
            this.nodesByPath.put(path, node);
            return node;
        }

        public List<MapNode> getBranch(Location rootLocation, int maximumDepth) {
            assert (rootLocation.getUuid() != null || rootLocation.getPath() != null);
            UUID subgraphRootUuid = rootLocation.getUuid();
            if (subgraphRootUuid == null) {
                MapNode rootNode = this.getNode(rootLocation.getPath());
                subgraphRootUuid = rootNode.getUuid();
                assert (subgraphRootUuid != null);
            }
            SubgraphQuery subgraph = SubgraphQuery.create(SimpleJpaRepository.this.entityManager, this.workspaceId, subgraphRootUuid, maximumDepth);
            List<NodeEntity> entities = subgraph.getNodes(true, true);
            ArrayList<MapNode> nodes = new ArrayList<MapNode>(entities.size());
            for (NodeEntity entity : entities) {
                nodes.add(new JpaNode(entity));
            }
            subgraph.close();
            return nodes;
        }

        public void lockNode(MapNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
        }

        public void unlockNode(MapNode node) {
        }
    }
}

