/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.modeshape.connector.store.jpa.model.simple.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.simple.NodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SubgraphNodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SubgraphQueryEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubgraphQuery {
    private final EntityManager manager;
    private final Long workspaceId;
    private SubgraphQueryEntity query;
    private final int maxDepth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubgraphQuery create(EntityManager entities, Long workspaceId, UUID subgraphRootUuid, int maxDepth) {
        assert (entities != null);
        assert (subgraphRootUuid != null);
        assert (workspaceId != null);
        assert (maxDepth >= 0);
        if (maxDepth == 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        String subgraphRootUuidString = subgraphRootUuid.toString();
        SubgraphQueryEntity query = new SubgraphQueryEntity(workspaceId, subgraphRootUuidString);
        entities.persist((Object)query);
        Long queryId = query.getId();
        try {
            SubgraphNodeEntity root = new SubgraphNodeEntity(queryId, subgraphRootUuidString, 0);
            entities.persist((Object)root);
            Query statement = entities.createNamedQuery("SubgraphNodeEntity.insertChildren");
            int numChildrenInserted = 0;
            for (int parentLevel = 0; parentLevel <= maxDepth; ++parentLevel) {
                statement.setParameter("queryId", (Object)queryId);
                statement.setParameter("workspaceId", (Object)workspaceId);
                statement.setParameter("parentDepth", (Object)parentLevel);
                numChildrenInserted = statement.executeUpdate();
                if (numChildrenInserted != 0) {
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException t) {
            try {
                Query search = entities.createNamedQuery("SubgraphNodeEntity.deleteByQueryId");
                search.setParameter("queryId", (Object)query.getId());
                search.executeUpdate();
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                entities.remove((Object)query);
                throw throwable;
            }
            entities.remove((Object)query);
            throw t;
        }
        return new SubgraphQuery(entities, workspaceId, query, maxDepth);
    }

    protected SubgraphQuery(EntityManager manager, Long workspaceId, SubgraphQueryEntity query, int maxDepth) {
        assert (manager != null);
        assert (query != null);
        assert (workspaceId != null);
        this.manager = manager;
        this.workspaceId = workspaceId;
        this.query = query;
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public EntityManager getEntityManager() {
        return this.manager;
    }

    public NodeEntity getNode() {
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getChildEntities");
        search.setParameter("queryId", (Object)this.query.getId());
        search.setParameter("workspaceId", (Object)this.workspaceId);
        search.setParameter("depth", (Object)0);
        search.setParameter("maxDepth", (Object)0);
        return (NodeEntity)search.getSingleResult();
    }

    public List<NodeEntity> getNodes(boolean includeRoot, boolean includeChildrenOfMaxDepthNodes) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        Query search = this.manager.createNamedQuery("SubgraphNodeEntity.getChildEntities");
        search.setParameter("queryId", (Object)this.query.getId());
        search.setParameter("workspaceId", (Object)this.workspaceId);
        search.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        search.setParameter("maxDepth", (Object)(includeChildrenOfMaxDepthNodes ? this.maxDepth : this.maxDepth - 1));
        return search.getResultList();
    }

    public void deleteSubgraph(boolean includeRoot) {
        if (this.query == null) {
            throw new IllegalStateException();
        }
        List<NodeEntity> nodes = this.getNodes(true, true);
        ArrayList<String> uuids = new ArrayList<String>(nodes.size());
        for (NodeEntity node : nodes) {
            uuids.add(node.getNodeUuidString());
        }
        Query withLargeValues = this.manager.createNamedQuery("SubgraphNodeEntity.getNodeEntitiesWithLargeValues");
        withLargeValues.setParameter("queryId", (Object)this.query.getId());
        withLargeValues.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        withLargeValues.setParameter("workspaceId", (Object)this.workspaceId);
        List nodesWithLargeValues = withLargeValues.getResultList();
        if (nodesWithLargeValues.size() != 0) {
            for (NodeEntity node : nodesWithLargeValues) {
                node.getLargeValues().clear();
            }
            this.manager.flush();
        }
        Query delete = this.manager.createNamedQuery("SubgraphNodeEntity.clearParentReferences");
        delete.setParameter("queryId", (Object)this.query.getId());
        delete.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        delete.setParameter("workspaceId", (Object)this.workspaceId);
        delete.executeUpdate();
        delete = this.manager.createNamedQuery("SubgraphNodeEntity.deleteChildEntities");
        delete.setParameter("queryId", (Object)this.query.getId());
        delete.setParameter("depth", (Object)(includeRoot ? 0 : 1));
        delete.setParameter("workspaceId", (Object)this.workspaceId);
        delete.executeUpdate();
        LargeValueEntity.deleteUnused(this.manager);
        this.manager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.query == null) {
            return;
        }
        try {
            Query search = this.manager.createNamedQuery("SubgraphNodeEntity.deleteByQueryId");
            search.setParameter("queryId", (Object)this.query.getId());
            search.executeUpdate();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.manager.remove((Object)this.query);
                Object var5_6 = null;
                this.query = null;
            }
            catch (Throwable throwable2) {
                Object var5_7 = null;
                this.query = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            this.manager.remove((Object)this.query);
            Object var5_4 = null;
            this.query = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.query = null;
            throw throwable;
        }
    }
}

