/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.SecureHash;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serializer {
    public static final LargeValues NO_LARGE_VALUES = new NoLargeValues();
    public static final ReferenceValues NO_REFERENCES_VALUES = new NoReferenceValues();
    private final PropertyFactory propertyFactory;
    private final ValueFactories valueFactories;
    private final boolean excludeUuidProperty;

    public Serializer(ExecutionContext context, boolean excludeUuidProperty) {
        this.propertyFactory = context.getPropertyFactory();
        this.valueFactories = context.getValueFactories();
        this.excludeUuidProperty = excludeUuidProperty;
    }

    public void serializeProperties(ObjectOutputStream stream, int number, Iterable<Property> properties, LargeValues largeValues, ReferenceValues references) throws IOException {
        assert (number >= 0);
        assert (properties != null);
        assert (largeValues != null);
        stream.writeInt(number);
        for (Property property : properties) {
            if (property == null) continue;
            this.serializeProperty(stream, property, largeValues, references);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serializeProperty(ObjectOutputStream stream, Property property, LargeValues largeValues, ReferenceValues references) throws IOException {
        assert (stream != null);
        assert (property != null);
        assert (largeValues != null);
        assert (references != null);
        Name name = property.getName();
        if (this.excludeUuidProperty && ModeShapeLexicon.UUID.equals(name)) {
            return false;
        }
        stream.writeObject(name.getString(Path.NO_OP_ENCODER));
        stream.writeInt(property.size());
        for (Object value : property) {
            byte[] hash;
            if (value instanceof String) {
                String stringValue = (String)value;
                if (largeValues != null && (long)stringValue.length() > largeValues.getMinimumSize()) {
                    hash = this.computeHash(stringValue);
                    stream.writeChar(76);
                    stream.writeInt(hash.length);
                    stream.write(hash);
                    stream.writeLong(stringValue.length());
                    largeValues.write(this.computeHash(stringValue), stringValue.length(), PropertyType.STRING, stringValue);
                    continue;
                }
                stream.writeChar(83);
                stream.writeObject(stringValue);
                continue;
            }
            if (value instanceof Boolean) {
                stream.writeChar(98);
                stream.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Long) {
                stream.writeChar(108);
                stream.writeLong((Long)value);
                continue;
            }
            if (value instanceof Double) {
                stream.writeChar(100);
                stream.writeDouble((Double)value);
                continue;
            }
            if (value instanceof Integer) {
                stream.writeChar(105);
                stream.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Short) {
                stream.writeChar(115);
                stream.writeShort(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Float) {
                stream.writeChar(102);
                stream.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof UUID) {
                stream.writeChar(85);
                UUID uuid = (UUID)value;
                stream.writeLong(uuid.getMostSignificantBits());
                stream.writeLong(uuid.getLeastSignificantBits());
                continue;
            }
            if (value instanceof URI) {
                URI uri = (URI)value;
                String stringValue = uri.toString();
                if (largeValues != null && (long)stringValue.length() > largeValues.getMinimumSize()) {
                    byte[] hash2 = this.computeHash(stringValue);
                    stream.writeChar(76);
                    stream.writeInt(hash2.length);
                    stream.write(hash2);
                    stream.writeLong(stringValue.length());
                    largeValues.write(this.computeHash(stringValue), stringValue.length(), PropertyType.URI, stringValue);
                    continue;
                }
                stream.writeChar(73);
                stream.writeObject(stringValue);
                continue;
            }
            if (value instanceof Name) {
                stream.writeChar(78);
                stream.writeObject(((Name)value).getString(Path.NO_OP_ENCODER));
                continue;
            }
            if (value instanceof Path) {
                stream.writeChar(80);
                stream.writeObject(((Path)value).getString());
                continue;
            }
            if (value instanceof DateTime) {
                stream.writeChar(84);
                stream.writeObject(((DateTime)value).getString());
                continue;
            }
            if (value instanceof BigDecimal) {
                stream.writeChar(68);
                stream.writeObject(value);
                continue;
            }
            if (value instanceof Character) {
                stream.writeChar(99);
                char c = ((Character)value).charValue();
                stream.writeChar(c);
                continue;
            }
            if (value instanceof Reference) {
                stream.writeChar(82);
                Reference ref = (Reference)value;
                stream.writeObject(ref.getString());
                references.write(ref);
                continue;
            }
            if (value instanceof Binary) {
                long length;
                block32: {
                    Binary binary = (Binary)value;
                    hash = null;
                    length = 0L;
                    try {
                        binary.acquire();
                        length = binary.getSize();
                        if (largeValues != null && length > largeValues.getMinimumSize()) {
                            hash = binary.getHash();
                            stream.writeChar(76);
                            stream.writeInt(hash.length);
                            stream.write(hash);
                            stream.writeLong(length);
                            break block32;
                        }
                        stream.writeChar(66);
                        stream.writeLong(length);
                        InputStream data = binary.getStream();
                        try {
                            byte[] buffer = new byte[1024];
                            int numRead = 0;
                            while ((numRead = data.read(buffer)) > -1) {
                                stream.write(buffer, 0, numRead);
                            }
                        }
                        finally {
                            data.close();
                        }
                    }
                    finally {
                        binary.release();
                    }
                }
                if (largeValues == null || hash == null) continue;
                largeValues.write(hash, length, PropertyType.BINARY, value);
                continue;
            }
            stream.writeChar(79);
            stream.writeObject(value);
        }
        stream.flush();
        return true;
    }

    public int reserializeProperties(ObjectInputStream input, ObjectOutputStream output, Map<Name, Property> updatedProperties, LargeValues largeValues, LargeValues removedLargeValues, Set<Name> createdProperties, ReferenceValues references) throws IOException, ClassNotFoundException {
        assert (input != null);
        assert (output != null);
        assert (updatedProperties != null);
        assert (createdProperties != null);
        assert (largeValues != null);
        assert (references != null);
        HashMap<Name, Property> allProperties = new HashMap<Name, Property>();
        createdProperties.addAll(updatedProperties.keySet());
        int count = input.readInt();
        for (int i = 0; i != count; ++i) {
            String nameStr = (String)input.readObject();
            Name name = (Name)this.valueFactories.getNameFactory().create(nameStr);
            assert (name != null);
            if (updatedProperties.containsKey(name)) {
                this.deserializePropertyValues(input, name, true, largeValues, removedLargeValues, references);
            } else {
                Object[] values = this.deserializePropertyValues(input, name, false, largeValues, removedLargeValues, references);
                Property property = this.propertyFactory.create(name, values);
                assert (property != null);
                allProperties.put(name, property);
            }
            createdProperties.remove(name);
        }
        for (Map.Entry<Name, Property> entry : updatedProperties.entrySet()) {
            Property updated = entry.getValue();
            Name name = entry.getKey();
            if (updated == null) {
                allProperties.remove(name);
                continue;
            }
            allProperties.put(name, updated);
        }
        int numProperties = allProperties.size();
        output.writeInt(numProperties);
        for (Property property : allProperties.values()) {
            if (property == null) continue;
            this.serializeProperty(output, property, largeValues, references);
        }
        return numProperties;
    }

    public void adjustReferenceProperties(ObjectInputStream input, ObjectOutputStream output, Map<String, String> oldUuidToNewUuid) throws IOException, ClassNotFoundException {
        assert (input != null);
        assert (output != null);
        assert (oldUuidToNewUuid != null);
        UuidFactory uuidFactory = this.valueFactories.getUuidFactory();
        ValueFactory referenceFactory = this.valueFactories.getReferenceFactory();
        int count = input.readInt();
        output.writeInt(count);
        for (int i = 0; i != count; ++i) {
            Object name = input.readObject();
            output.writeObject(name);
            int numValues = input.readInt();
            output.writeInt(numValues);
            block22: for (int j = 0; j != numValues; ++j) {
                char type = input.readChar();
                output.writeChar(type);
                switch (type) {
                    case 'S': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'b': {
                        output.writeBoolean(input.readBoolean());
                        continue block22;
                    }
                    case 'i': {
                        output.writeInt(input.readInt());
                        continue block22;
                    }
                    case 'l': {
                        output.writeLong(input.readLong());
                        continue block22;
                    }
                    case 's': {
                        output.writeShort(input.readShort());
                        continue block22;
                    }
                    case 'f': {
                        output.writeFloat(input.readFloat());
                        continue block22;
                    }
                    case 'd': {
                        output.writeDouble(input.readDouble());
                        continue block22;
                    }
                    case 'c': {
                        output.writeChar(input.readChar());
                        continue block22;
                    }
                    case 'U': {
                        output.writeLong(input.readLong());
                        output.writeLong(input.readLong());
                        continue block22;
                    }
                    case 'I': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'N': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'P': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'T': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'D': {
                        output.writeObject(input.readObject());
                        continue block22;
                    }
                    case 'R': {
                        String refValue = (String)input.readObject();
                        Reference ref = (Reference)referenceFactory.create(refValue);
                        try {
                            UUID toUuid = (UUID)uuidFactory.create(ref);
                            String newUuid = oldUuidToNewUuid.get(toUuid.toString());
                            if (newUuid != null) {
                                ref = (Reference)referenceFactory.create(newUuid);
                                refValue = ref.getString();
                            }
                        }
                        catch (ValueFormatException e) {
                            // empty catch block
                        }
                        output.writeObject(refValue);
                        continue block22;
                    }
                    case 'B': {
                        long binaryLength = input.readLong();
                        byte[] content = new byte[(int)binaryLength];
                        input.read(content);
                        output.writeLong(binaryLength);
                        output.write(content);
                        continue block22;
                    }
                    case 'L': {
                        int hashLength = input.readInt();
                        byte[] hash = new byte[hashLength];
                        input.read(hash);
                        long length = input.readLong();
                        output.writeInt(hash.length);
                        output.write(hash);
                        output.writeLong(length);
                        continue block22;
                    }
                    default: {
                        output.writeObject(input.readObject());
                    }
                }
            }
        }
    }

    public void deserializeAllProperties(ObjectInputStream stream, Collection<Property> properties, LargeValues largeValues) throws IOException, ClassNotFoundException {
        assert (stream != null);
        assert (properties != null);
        int count = stream.readInt();
        for (int i = 0; i != count; ++i) {
            Property property = this.deserializeProperty(stream, largeValues);
            assert (property != null);
            properties.add(property);
        }
    }

    public void deserializeSomeProperties(ObjectInputStream stream, Collection<Property> properties, LargeValues largeValues, LargeValues skippedLargeValues, Name ... names) throws IOException, ClassNotFoundException {
        assert (stream != null);
        assert (properties != null);
        assert (names != null);
        assert (names.length > 0);
        Name nameToRead = null;
        HashSet<Name> namesToRead = null;
        if (names.length == 1) {
            nameToRead = names[0];
        } else {
            namesToRead = new HashSet<Name>();
            for (Name name : names) {
                if (name == null) continue;
                namesToRead.add(name);
            }
        }
        boolean read = false;
        int count = stream.readInt();
        for (int i = 0; i != count; ++i) {
            String nameStr = (String)stream.readObject();
            Name name = (Name)this.valueFactories.getNameFactory().create(nameStr);
            assert (name != null);
            boolean bl = read = name.equals(nameToRead) || namesToRead != null && namesToRead.contains(namesToRead);
            if (read) {
                Object[] values = this.deserializePropertyValues(stream, name, false, largeValues, skippedLargeValues, null);
                Property property = this.propertyFactory.create(name, values);
                assert (property != null);
                properties.add(property);
                continue;
            }
            this.deserializePropertyValues(stream, name, true, largeValues, skippedLargeValues, null);
        }
    }

    public Property deserializeProperty(ObjectInputStream stream, LargeValues largeValues) throws IOException, ClassNotFoundException {
        String nameStr = (String)stream.readObject();
        Name name = (Name)this.valueFactories.getNameFactory().create(nameStr);
        assert (name != null);
        Object[] values = this.deserializePropertyValues(stream, name, false, largeValues, largeValues, null);
        return this.propertyFactory.create(name, values);
    }

    public Object[] deserializePropertyValues(ObjectInputStream stream, Name propertyName, boolean skip, LargeValues largeValues, LargeValues skippedLargeValues, ReferenceValues references) throws IOException, ClassNotFoundException {
        assert (stream != null);
        assert (propertyName != null);
        assert (largeValues != null);
        assert (skippedLargeValues != null);
        int size = stream.readInt();
        Object[] values = skip ? null : new Object[size];
        for (int i = 0; i != size; ++i) {
            Object value = null;
            char type = stream.readChar();
            switch (type) {
                case 'S': {
                    String stringValue = (String)stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getStringFactory().create(stringValue);
                    break;
                }
                case 'b': {
                    boolean booleanValue = stream.readBoolean();
                    if (skip) break;
                    value = this.valueFactories.getBooleanFactory().create(booleanValue);
                    break;
                }
                case 'i': {
                    int intValue = stream.readInt();
                    if (skip) break;
                    value = this.valueFactories.getLongFactory().create(intValue);
                    break;
                }
                case 'l': {
                    long longValue = stream.readLong();
                    if (skip) break;
                    value = this.valueFactories.getLongFactory().create(longValue);
                    break;
                }
                case 's': {
                    short shortValue = stream.readShort();
                    if (skip) break;
                    value = this.valueFactories.getLongFactory().create((int)shortValue);
                    break;
                }
                case 'f': {
                    float floatValue = stream.readFloat();
                    if (skip) break;
                    value = this.valueFactories.getDoubleFactory().create(floatValue);
                    break;
                }
                case 'd': {
                    double doubleValue = stream.readDouble();
                    if (skip) break;
                    value = this.valueFactories.getDoubleFactory().create(doubleValue);
                    break;
                }
                case 'c': {
                    String charValue = "" + stream.readChar();
                    if (skip) break;
                    value = this.valueFactories.getStringFactory().create(charValue);
                    break;
                }
                case 'U': {
                    long msb = stream.readLong();
                    long lsb = stream.readLong();
                    if (skip) break;
                    UUID uuid = new UUID(msb, lsb);
                    value = this.valueFactories.getUuidFactory().create(uuid);
                    break;
                }
                case 'I': {
                    String uriStr = (String)stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getUriFactory().create(uriStr);
                    break;
                }
                case 'N': {
                    String nameValueStr = (String)stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getNameFactory().create(nameValueStr);
                    break;
                }
                case 'P': {
                    String pathStr = (String)stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getPathFactory().create(pathStr);
                    break;
                }
                case 'T': {
                    String dateTimeStr = (String)stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getDateFactory().create(dateTimeStr);
                    break;
                }
                case 'D': {
                    Object bigDecimal = stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getDecimalFactory().create(bigDecimal);
                    break;
                }
                case 'R': {
                    String refValue = (String)stream.readObject();
                    Reference ref = (Reference)this.valueFactories.getReferenceFactory().create(refValue);
                    if (skip) {
                        if (references == null) break;
                        references.remove(ref);
                        break;
                    }
                    value = ref;
                    if (references == null) break;
                    references.read(ref);
                    break;
                }
                case 'B': {
                    long binaryLength = stream.readLong();
                    byte[] content = new byte[(int)binaryLength];
                    stream.readFully(content, 0, content.length);
                    if (skip) break;
                    value = this.valueFactories.getBinaryFactory().create(content);
                    break;
                }
                case 'L': {
                    int hashLength = stream.readInt();
                    byte[] hash = new byte[hashLength];
                    stream.readFully(hash, 0, hashLength);
                    long length = stream.readLong();
                    if (skip) {
                        skippedLargeValues.read(this.valueFactories, hash, length);
                        break;
                    }
                    BinaryFactory factory = this.valueFactories.getBinaryFactory();
                    value = factory.find(hash);
                    if (value != null) break;
                    value = largeValues.read(this.valueFactories, hash, length);
                    break;
                }
                default: {
                    Object object = stream.readObject();
                    if (skip) break;
                    value = this.valueFactories.getObjectFactory().create(object);
                }
            }
            if (value == null) continue;
            values[i] = value;
        }
        return values;
    }

    public byte[] computeHash(String value) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])value.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    protected static class NoReferenceValues
    implements ReferenceValues {
        protected NoReferenceValues() {
        }

        public void read(Reference arg0) {
        }

        public void remove(Reference arg0) {
        }

        public void write(Reference arg0) {
        }
    }

    public static interface ReferenceValues {
        public void read(Reference var1);

        public void write(Reference var1);

        public void remove(Reference var1);
    }

    protected static class NoLargeValues
    implements LargeValues {
        protected NoLargeValues() {
        }

        public long getMinimumSize() {
            return Long.MAX_VALUE;
        }

        public void write(byte[] hash, long length, PropertyType type, Object value) {
        }

        public Object read(ValueFactories valueFactories, byte[] hash, long length) {
            return null;
        }
    }

    public static interface LargeValues {
        public long getMinimumSize();

        public void write(byte[] var1, long var2, PropertyType var4, Object var5) throws IOException;

        public Object read(ValueFactories var1, byte[] var2, long var3) throws IOException;
    }
}

