/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.util.UUID;
import javax.persistence.EntityManager;
import org.modeshape.common.util.CheckArg;
import org.modeshape.connector.store.jpa.Model;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;

public class StoreOptions {
    public static final String ROOT_NODE_UUID = "org.modeshape.store.rootNodeUuid";
    public static final String VERSION = "org.modeshape.store.version";
    public static final String MODEL = "org.modeshape.store.model";
    private final EntityManager entityManager;

    public StoreOptions(EntityManager manager) {
        CheckArg.isNotNull((Object)manager, (String)"manager");
        this.entityManager = manager;
    }

    public UUID getRootNodeUuid() {
        String value = this.getOption(ROOT_NODE_UUID);
        if (value == null && (value = this.getOption("org.jboss.dna.store.rootNodeUuid")) != null) {
            this.setOption(ROOT_NODE_UUID, value);
        }
        return value != null ? UUID.fromString(value) : null;
    }

    public void setRootNodeUuid(UUID uuid) {
        CheckArg.isNotNull((Object)uuid, (String)"uuid");
        this.setOption(ROOT_NODE_UUID, uuid.toString());
    }

    public String getVersion() {
        String value = this.getOption(VERSION);
        if (value == null && (value = this.getOption("org.jboss.dna.store.version")) != null) {
            this.setOption(VERSION, value);
        }
        return value;
    }

    public void setVersion(String version) {
        this.setOption(VERSION, version);
    }

    public String getModelName() {
        String value = this.getOption(MODEL);
        if (value == null && (value = this.getOption("org.jboss.dna.store.model")) != null) {
            this.setOption(MODEL, value);
        }
        return value;
    }

    public void setModelName(Model model) {
        String modelName = model != null ? model.getName() : null;
        this.setOption(MODEL, modelName);
    }

    public String getOption(String name) {
        StoreOptionEntity entity = (StoreOptionEntity)this.entityManager.find(StoreOptionEntity.class, (Object)name);
        return entity != null ? entity.getValue() : null;
    }

    public void setOption(String name, String value) {
        StoreOptionEntity entity;
        CheckArg.isNotEmpty((String)name, (String)"name");
        if (value != null) {
            value = value.trim();
        }
        if ((entity = (StoreOptionEntity)this.entityManager.find(StoreOptionEntity.class, (Object)name)) == null) {
            if (value != null) {
                entity = new StoreOptionEntity(name, value);
                this.entityManager.persist((Object)entity);
            }
        } else if (value != null) {
            entity.setValue(value);
        } else {
            this.entityManager.remove((Object)entity);
        }
    }

    public void removeOption(String name) {
        StoreOptionEntity entity = new StoreOptionEntity(name);
        this.entityManager.remove((Object)entity);
    }

    public static final class Dna {
        public static final String ROOT_NODE_UUID = "org.jboss.dna.store.rootNodeUuid";
        public static final String VERSION = "org.jboss.dna.store.version";
        public static final String MODEL = "org.jboss.dna.store.model";
    }
}

