/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.connector.store.jpa.model.common.WorkspaceEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Workspaces {
    private final EntityManager entityManager;
    private final Map<String, WorkspaceEntity> cache = new HashMap<String, WorkspaceEntity>();

    public Workspaces(EntityManager manager) {
        this.entityManager = manager;
    }

    public WorkspaceEntity create(String workspaceName) {
        assert (workspaceName != null);
        WorkspaceEntity entity = this.cache.get(workspaceName);
        if (entity != null) {
            return null;
        }
        entity = WorkspaceEntity.findByName(this.entityManager, workspaceName, false);
        if (entity != null) {
            return null;
        }
        entity = WorkspaceEntity.findByName(this.entityManager, workspaceName, true);
        this.cache.put(workspaceName, entity);
        return entity;
    }

    public WorkspaceEntity get(String workspaceName, boolean createIfRequired) {
        WorkspaceEntity entity = this.cache.get(workspaceName);
        if (entity == null && (entity = WorkspaceEntity.findByName(this.entityManager, workspaceName, createIfRequired)) != null) {
            this.cache.put(workspaceName, entity);
        }
        return entity;
    }

    public Set<String> getWorkspaceNames() {
        return WorkspaceEntity.findAllNames(this.entityManager);
    }

    public boolean destroy(String workspaceName) {
        assert (workspaceName != null);
        WorkspaceEntity entity = this.cache.remove(workspaceName);
        if (entity == null) {
            entity = WorkspaceEntity.findByName(this.entityManager, workspaceName, false);
        }
        if (entity != null) {
            this.entityManager.remove((Object)entity);
        }
        return entity != null;
    }
}

